/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.cablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnIntList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDelMarineCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDelMarineCableRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCable;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCableList;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TEMarineDelCableHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_DEL_MARINE_CABLE = 2179337;

    public int handleRequest(AsnDelMarineCableReq req, AsnDelMarineCableRsp rsp, TaskMgr tm, TETaskInfo info) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("cablemgr").append(File.separator).append("cablemgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_DEL_MARINE_CABLE);
        marineLogInfo.setOperateName(res.getString("slm_delete_cable"));
        marineLogInfo.setOperateDesc(this.getDetailStr(req, res));
        marineLogInfo.setOperateObject(res.getString("slm_delete_cable"));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = req.userID.intValue();
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnMarineCableList cableList = req.marineCableList;
        if (cableList.isEmpty()) {
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(0);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 0;
        }
        ArrayList<TEDaoNameValuePair> deleteCriterion = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = null;
        int len = cableList.size();
        for (int i = 0; i < len; ++i) {
            AsnMarineCable asnCable = (AsnMarineCable)cableList.get(i);
            aPair = new TEDaoNameValuePair("CableID", String.valueOf(asnCable.cableID));
            deleteCriterion.add(aPair);
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.deleteByID(TEMarineCablePO.class, deleteCriterion);
        }
        catch (Exception e) {
            normalLogger.error("DB oper error!", (Throwable)e);
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            AsnIntList asnCableIDLst = this.getAsnCableIDLst(cableList);
            TEMarineCableNoticeMgr.sendDelCableNtfToC(asnCableIDLst);
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        } else {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public String getDetailStr(AsnDelMarineCableReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineCableList cableList = req.marineCableList;
        AsnMarineCable cable = null;
        int len = cableList.size();
        for (int i = 0; i < len; ++i) {
            cable = (AsnMarineCable)cableList.get(i);
            bf.append(res.getString("name_str")).append(':');
            bf.append(new String(cable.cableName)).append(';');
        }
        return bf.toString();
    }

    private AsnIntList getAsnCableIDLst(AsnMarineCableList asnCableList) {
        if (null == asnCableList || asnCableList.isEmpty()) {
            return null;
        }
        AsnIntList asnCableIDLst = new AsnIntList();
        int len = asnCableList.size();
        for (int i = 0; i < len; ++i) {
            AsnMarineCable asnCable = (AsnMarineCable)asnCableList.get(i);
            asnCableIDLst.add(asnCable.cableID.intValue());
        }
        return asnCableIDLst;
    }
}

