/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.cablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCreateMarineCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCreateMarineCableRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCable;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCableList;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEMarineCreateCableHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static final int CABLE_ID_BEGIN = 1;
    private static final int CABLE_ID_INVALID = -1;
    private static int TECMDCODE_CREATE_MARINE_CABLE = 2179335;

    public int handleRequest(AsnCreateMarineCableReq req, AsnCreateMarineCableRsp rsp, TaskMgr tm, TETaskInfo info) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("cablemgr").append(File.separator).append("cablemgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_CREATE_MARINE_CABLE);
        marineLogInfo.setOperateName(res.getString("slm_create_cable"));
        marineLogInfo.setOperateDesc(this.getDetailStr(req, res));
        marineLogInfo.setOperateObject(res.getString("slm_create_cable"));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = req.userID.intValue();
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnMarineCableList cableList = req.marineCableList;
        if (cableList.isEmpty()) {
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(0);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 0;
        }
        GetNextCableID nextCableID = this.getNextCableID(req, rsp);
        if (0 != nextCableID.getResult()) {
            marineLogInfo.setErrCode(2);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        AsnMarineCable asnCable = (AsnMarineCable)cableList.get(0);
        asnCable.cableID = BigInteger.valueOf(nextCableID.getCableID());
        TEMarineCablePO cablePO = TEMarineCableMgrTask.asnCable2POCable(asnCable);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((Object)cablePO);
        }
        catch (Exception e) {
            normalLogger.error("DB oper error!", (Throwable)e);
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            TEMarineCableNoticeMgr.sendCreateCableNtfToC(asnCable);
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        } else {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private GetNextCableID getNextCableID(AsnCreateMarineCableReq req, AsnCreateMarineCableRsp rsp) {
        GetNextCableID nextCableID = new GetNextCableID();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
        }
        catch (Exception e) {
            normalLogger.error("DB oper error!", (Throwable)e);
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            nextCableID.setResult(2);
            return nextCableID;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            nextCableID.setResult(2);
            return nextCableID;
        }
        int retCode = dbResult.getResult();
        TEMarineCablePO cablePO = null;
        int curCableID = -1;
        int maxCableID = 1;
        if (0 != retCode) {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
            nextCableID.setResult(2);
        } else {
            List data = dbResult.getData();
            for (Object obj : data) {
                cablePO = (TEMarineCablePO)obj;
                curCableID = cablePO.getCableID();
                if (maxCableID >= curCableID) continue;
                maxCableID = curCableID;
            }
            nextCableID.setCableID(maxCableID + 1);
            nextCableID.setResult(0);
        }
        return nextCableID;
    }

    public String getDetailStr(AsnCreateMarineCableReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineCableList cableList = req.marineCableList;
        AsnMarineCable cable = null;
        int len = cableList.size();
        for (int i = 0; i < len; ++i) {
            cable = (AsnMarineCable)cableList.get(i);
            bf.append(res.getString("source_str")).append(':');
            String srcStationName = new String(cable.srcStationName);
            if (!srcStationName.trim().equals("")) {
                bf.append(srcStationName).append('-');
            }
            bf.append(new String(cable.srcNodeName)).append(',');
            bf.append(res.getString("sink_str")).append(':');
            String sinkStationName = new String(cable.sinkStationName);
            if (!sinkStationName.trim().equals("")) {
                bf.append(sinkStationName).append('-');
            }
            bf.append(new String(cable.sinkNodeName)).append(',');
            bf.append(res.getString("name_str")).append(':');
            bf.append(new String(cable.cableName)).append(',');
            bf.append(res.getString("cablelenlable")).append(':');
            bf.append(cable.cableLen).append(',');
            bf.append(res.getString("cableresistancelabel")).append(':');
            bf.append((double)cable.cableResistance.intValue() / 10.0).append(',');
            bf.append(res.getString("cable20resistancelabel")).append(':');
            bf.append((double)cable.cable20Resistance.intValue() / 10.0).append(',');
            bf.append(res.getString("cablecurtemplabel")).append(':');
            bf.append(cable.curtemperature.intValue()).append(',');
            bf.append(res.getString("rpt_num_str")).append(':');
            bf.append(cable.rptNum).append(',');
            bf.append(res.getString("memo_str")).append(':');
            bf.append(new String(cable.cableMemo)).append(';');
        }
        return bf.toString();
    }

    static class GetNextCableID {
        private int cableID;
        private int result = 2;

        GetNextCableID() {
        }

        public int getCableID() {
            return this.cableID;
        }

        public void setCableID(int cableID) {
            this.cableID = cableID;
        }

        public int getResult() {
            return this.result;
        }

        public void setResult(int result) {
            this.result = result;
        }
    }
}

