/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.cablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnBindMarineLineReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnBindMarineLineRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCableBindDetailErr;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCableBindDetailErrList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnGetMarineCableBindLineInfoReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnGetMarineCableBindLineInfoRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCableBindLine;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCableBindLineList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnMarineLineStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnNeLineStr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnNeLineStrList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryLineStr;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineStruct;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEQueryLineData;
import com.huawei.nglct.po.embeddednemgrmo.marine.TECableBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineDevicePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineSpanPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationNEPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class TEMarineCableBindLineHandler {
    private static final byte BINDED = 1;
    private static final byte UNBINDED = 0;
    private static final int MARINE_CABLE_ENDPOINT_CTB = 0;
    private static final int MARINE_CABLE_ENDPOINT_BU = 1;
    static final int BU_BU_CABLE = 0;
    static final int STN_STN_CABLE = 1;
    static final int STN_AND_BU_CABLE = 2;
    private static final int BIND_ACTION = 0;
    private static final TIntIntHashMap CABLETYPEMAP = new TIntIntHashMap();
    public static final int OADM_BU_TYPE = 1;
    public static final int PS_BU_TYPE = 2;
    public static final int OEQ_TYPE = 3;
    static final int SINGLE_LINE = 0;
    static final int UNKONW_DST_LINE = 1;
    static final int NE_AND_BU_LINE = 2;
    static final int NE_NE_NON_BU_LINE = 3;
    static final int NE_NE_HAS_ONE_BU_LINE = 4;
    static final int NE_NE_HAS_MORE_BU_LINE = 5;
    private static final TIntObjectHashMap<int[]> LINE2CABLEMAP;
    private Map<String, TEQueryLineData> marineLineStrMap = new HashMap<String, TEQueryLineData>();

    private TEMarineCableBindLineHandler() {
    }

    public static int doBindAction(AsnBindMarineLineReq req, AsnBindMarineLineRsp rsp, TaskMgr tm) {
        int cableID = req.cableID.intValue();
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair id = new TEDaoNameValuePair();
        id.setName("CableID");
        id.setValue(String.valueOf(cableID));
        criteria.add(id);
        rsp.result.isSuccess = true;
        rsp.result.setRetCode(0);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findByID(TEMarineCablePO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        if (null == dbResult) {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1090614790);
            return 0;
        }
        if (dbResult.getResult() != 0) {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(dbResult.getResult());
            return 0;
        }
        TEMarineCablePO cable = (TEMarineCablePO)dbResult.getData().get(0);
        Set blist = cable.getBONDLineList();
        int bindAction = req.bindAction.intValue();
        AsnNeLineStrList lineList = req.lineList;
        AsnCableBindDetailErrList detailRet = rsp.detailRet;
        int llen = lineList.size();
        for (int li = 0; li < llen; ++li) {
            AsnNeLineStr al = (AsnNeLineStr)lineList.get(li);
            AsnCableBindDetailErr err = new AsnCableBindDetailErr();
            detailRet.add((Object)err);
            err.line = al;
            err.result.isSuccess = true;
            int lid = al.lineID.intValue();
            int srcid = al.srcNeID.intValue();
            int snkid = al.snkNeID.intValue();
            TECableBondLinePO po = new TECableBondLinePO();
            po.setLineId(lid);
            po.setSrcNeID((long)srcid);
            po.setSnkNeID((long)snkid);
            if (0 == bindAction) {
                if (blist.contains(po)) continue;
                blist.add(po);
                continue;
            }
            blist.remove(po);
        }
        try {
            dbResult = TECommonDaoService.update((Object)cable);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        if (null == dbResult) {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1090614790);
            rsp.detailRet.clear();
            return 0;
        }
        if (dbResult.getResult() != 0) {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(dbResult.getResult());
            rsp.detailRet.clear();
            return 0;
        }
        return 0;
    }

    private static int checkLine(AsnNeLineStr al) {
        int neID = al.srcNeID.intValue();
        int lineID = al.lineID.intValue();
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair neIDPair = new TEDaoNameValuePair();
        TEDaoNameValuePair lineIDPair = new TEDaoNameValuePair();
        neIDPair.setName("NeID");
        neIDPair.setValue(String.valueOf(neID));
        criteria.add(neIDPair);
        lineIDPair.setName("LineID");
        lineIDPair.setValue(String.valueOf(lineID));
        criteria.add(lineIDPair);
        TEDaoOperationResult dbresult = null;
        try {
            dbresult = TECommonDaoService.deleteByID((int[])new int[]{neID}, TESLMLinePO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return 1090614790;
        }
        int errCode = dbresult.getResult();
        if (0 != errCode) {
            return errCode;
        }
        return 0;
    }

    public static int getBondLineInfo(AsnGetMarineCableBindLineInfoReq req, AsnGetMarineCableBindLineInfoRsp rsp, TaskMgr tm) {
        int cableID = req.cableID.intValue();
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair id = new TEDaoNameValuePair();
        id.setName("CableID");
        id.setValue(String.valueOf(cableID));
        criteria.add(id);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findByID(TEMarineCablePO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        if (null == dbResult) {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1090614790);
            return 0;
        }
        if (dbResult.getResult() != 0) {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(dbResult.getResult());
            return 0;
        }
        TEMarineCablePO cable = (TEMarineCablePO)dbResult.getData().get(0);
        rsp.result.isSuccess = true;
        Set BONDLineList = cable.getBONDLineList();
        for (TECableBondLinePO bline : BONDLineList) {
            rsp.lineList.add((Object)TEMarineCableBindLineHandler.convert2AsnLine(bline));
        }
        return 0;
    }

    private static AsnMarineLineStruct getDefaultStruct() {
        AsnMarineLineStruct struct = new AsnMarineLineStruct();
        struct.neID = BigInteger.ZERO;
        struct.lineID = BigInteger.ZERO;
        struct.lmuSlotID = BigInteger.ZERO;
        struct.lmuPortID = BigInteger.ZERO;
        struct.lasSlotID = BigInteger.ZERO;
        struct.lasPortID = BigInteger.ZERO;
        struct.lmiSlotID = BigInteger.ZERO;
        struct.lmiPortID = BigInteger.ZERO;
        struct.probeWaveBand = BigInteger.ZERO;
        struct.probeWaveIndex = BigInteger.ZERO;
        struct.loadingWaveBand = BigInteger.ZERO;
        struct.loadingWaveIndex = BigInteger.ZERO;
        return struct;
    }

    private static AsnMarineCableBindLine convert2AsnLine(TECableBondLinePO bline) {
        AsnMarineCableBindLine asnLine = new AsnMarineCableBindLine();
        AsnQueryLineStr line = asnLine.line;
        line.srcLineStr = TEMarineCableBindLineHandler.getDefaultStruct();
        line.snkLineStr = TEMarineCableBindLineHandler.getDefaultStruct();
        line.srcLineStr.lineID = BigInteger.valueOf(bline.getLineId());
        line.srcLineStr.neID = BigInteger.valueOf(bline.getSrcNeID());
        line.snkLineStr.lineID = BigInteger.valueOf(bline.getLineId());
        line.snkLineStr.neID = BigInteger.valueOf(bline.getSnkNeID());
        line.remark = "".getBytes();
        line.isConsistent = BigInteger.ZERO;
        asnLine.status = BigInteger.valueOf(1L);
        return asnLine;
    }

    public static void getBondLineInfoImpl(TEMarineCablePO cablePO, AsnGetMarineCableBindLineInfoRsp rsp) {
        List<TESLMLinePO> linesOnCable = TEMarineCableBindLineHandler.getLineOnCable(cablePO);
        if (null == linesOnCable || linesOnCable.isEmpty()) {
            return;
        }
        HashMap<String, TEQueryLineData> marineLineStrMap = new HashMap<String, TEQueryLineData>();
        TEMarineCableBindLineHandler.getBiLineData(linesOnCable, marineLineStrMap);
        AsnMarineCableBindLineList lineList = rsp.lineList;
        Iterator itMap = marineLineStrMap.entrySet().iterator();
        TEQueryLineData lineStr = null;
        AsnQueryLineStr lineStrInfo = null;
        Set llist = cablePO.getBONDLineList();
        if (!marineLineStrMap.isEmpty()) {
            while (itMap.hasNext()) {
                AsnMarineCableBindLine bline = new AsnMarineCableBindLine();
                Map.Entry entry = itMap.next();
                lineStr = (TEQueryLineData)entry.getValue();
                bline.line = lineStrInfo = TEMarineLinePubFun.mgrLine2AsnLine(lineStr, null);
                TECableBondLinePO cp = new TECableBondLinePO();
                cp.setLineId(lineStr.getLineStrSrc().getLineID());
                cp.setSrcNeID(lineStr.getLineStrSrc().getNeID());
                cp.setSnkNeID(lineStr.getLineStrSrc().getOpNeID());
                int status = 0;
                if (llist.contains(cp)) {
                    status = 1;
                }
                bline.status = BigInteger.valueOf(status);
                lineList.add((Object)bline);
            }
        }
    }

    private static void getBiLineData(List<TESLMLinePO> data, Map<String, TEQueryLineData> marineLineStrMap) {
        TEMarineLineStruct lineStr = null;
        ArrayList<TEMarineLineStruct.SpanStruct> spanStrList = new ArrayList<TEMarineLineStruct.SpanStruct>();
        ArrayList<TEMarineLineStruct.EqptStruct> EqptStrList = new ArrayList<TEMarineLineStruct.EqptStruct>();
        TEMarineLineStruct.SpanStruct spanStr = null;
        TEMarineLineStruct.EqptStruct eqptStr = null;
        TESLMLinePO linePO = null;
        Iterator<TESLMLinePO> i$ = data.iterator();
        while (i$.hasNext()) {
            TESLMLinePO obj;
            linePO = obj = i$.next();
            lineStr = new TEMarineLineStruct();
            int direction = linePO.getDirection();
            lineStr.setDirection(direction);
            lineStr.setNeID(linePO.getNeID());
            lineStr.setLineID(linePO.getLineID());
            int lineID = linePO.getLineID();
            lineStr.setLmuSlot(linePO.getLMUSlot());
            lineStr.setLmuPort(linePO.getLMUPort());
            lineStr.setLasSlot(linePO.getLASSlot());
            lineStr.setLasPort(linePO.getLASPort());
            lineStr.setLmiSlot(linePO.getLMISlot());
            lineStr.setLmiPort(linePO.getLMIPort());
            lineStr.setOpNeID(linePO.getOppositeNEID());
            lineStr.setOpLmiSlot(linePO.getLMISlot());
            lineStr.setLoadingWaveBand(linePO.getCompensatoryWaveBand());
            lineStr.setLoadingWaveIndex(linePO.getCompensatoryWaveLenth());
            lineStr.setProbeWaveBand(linePO.getProbeWaveBand());
            lineStr.setProbeWaveIndex(linePO.getProbeWaveLenth());
            lineStr.setRemark(linePO.getRemark());
            lineStr.setSpanNum(linePO.getSpanNum());
            lineStr.setEqptNum(linePO.getEqptNum());
            for (TELineSpanPO spanObj : linePO.getSpanList()) {
                spanStr = new TEMarineLineStruct.SpanStruct();
                spanStr.setSpanID(spanObj.getSpanID());
                spanStr.setFiberType(spanObj.getFiberType());
                spanStr.setrefractiveIndex(spanObj.getAtteCoefficient());
                spanStr.setFiberLenth(spanObj.getFiberLenth());
                spanStr.setAtteCoefficient(spanObj.getAtteCoefficient());
                spanStrList.add(spanStr);
            }
            lineStr.setSpanStrList(spanStrList);
            for (TELineDevicePO eqptObj : linePO.getDeviceList()) {
                eqptStr = new TEMarineLineStruct.EqptStruct();
                eqptStr.setEqptID(eqptObj.getDeviceID());
                eqptStr.setEqptSpan(eqptObj.getSpanID());
                eqptStr.setEqptType(eqptObj.getDeviceType());
                eqptStr.setEqptName(eqptObj.getRemark());
                eqptStr.setEqptPos(eqptObj.getDistance());
                EqptStrList.add(eqptStr);
            }
            lineStr.setEqptStrList(EqptStrList);
            String keyStr = 1 == direction ? String.valueOf(linePO.getNeID()) + linePO.getOppositeNEID() + lineID : String.valueOf(linePO.getOppositeNEID()) + linePO.getNeID() + lineID;
            TEMarineCableBindLineHandler.fillMarineStrMap(keyStr, lineStr, marineLineStrMap, direction);
        }
    }

    private static void fillMarineStrMap(String keyStr, TEMarineLineStruct lineStr, Map<String, TEQueryLineData> marineLineStrMap, int direction) {
        TEQueryLineData marineLine = marineLineStrMap.get(keyStr);
        if (null == marineLine) {
            marineLine = new TEQueryLineData();
        }
        if (1 == direction) {
            marineLine.setLineStrSrc(lineStr);
        } else {
            marineLine.setLineStrSnk(lineStr);
        }
        marineLineStrMap.put(keyStr, marineLine);
    }

    static void autoBindLine(TEMarineCablePO cablePO) {
        List<TESLMLinePO> linesOnCable = TEMarineCableBindLineHandler.getLineOnCable(cablePO);
        if (null == linesOnCable || linesOnCable.isEmpty()) {
            return;
        }
        Set llist = cablePO.getBONDLineList();
        for (TESLMLinePO line : linesOnCable) {
            TECableBondLinePO cp = new TECableBondLinePO();
            cp.setLineId(line.getLineID());
            cp.setSrcNeID(line.getNeID());
            cp.setSnkNeID(line.getOppositeNEID());
            if (llist.contains(cp)) continue;
            llist.add(cp);
        }
        try {
            TECommonDaoService.update((Object)cablePO);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
    }

    private static boolean isBUDevType(int type) {
        return 1 == type || 2 == type;
    }

    static List<TESLMLinePO> getLineOnCable(TEMarineCablePO cablePO) {
        int cableType = TEMarineCableBindLineHandler.getCableType(cablePO);
        List<TEMarineStationPO> stations = TEMarineCableBindLineHandler.getAllStations();
        ArrayList<TESLMLinePO> linesOnCable = new ArrayList<TESLMLinePO>();
        List<TESLMLinePO> lines = TEMarineCableBindLineHandler.getAllRawLineInfo();
        for (TESLMLinePO line : lines) {
            int index;
            int cableSrcendType;
            TEMarineStationPO snkLineStation;
            TEMarineStationPO srcLineStation;
            int srcNEID = (int)line.getNeID();
            int snkNEID = (int)line.getOppositeNEID();
            ArrayList<TELineDevicePO> buDeviceList = new ArrayList<TELineDevicePO>();
            int lineType = TEMarineCableBindLineHandler.getLineType(line, buDeviceList);
            TEMarineCableBindLineHandler.sortBU(buDeviceList);
            boolean canContinue = TEMarineCableBindLineHandler.checkByLineTypeAndCableType(lineType, cableType);
            if (!canContinue || null == (srcLineStation = TEMarineCableBindLineHandler.getStationByNEID(srcNEID, stations)) || null == (snkLineStation = TEMarineCableBindLineHandler.getStationByNEID(snkNEID, stations))) continue;
            if (3 == lineType) {
                int cableSrcStnID = cablePO.SrcStationID;
                int cableSnkStnID = cablePO.SinkStationID;
                int lineSrcStnID = srcLineStation.StationID;
                int lineSnkStnID = snkLineStation.StationID;
                if ((cableSrcStnID != lineSrcStnID || cableSnkStnID != lineSnkStnID) && (cableSnkStnID != lineSrcStnID || cableSrcStnID != lineSnkStnID)) continue;
                linesOnCable.add(line);
                continue;
            }
            if (4 == lineType) {
                int cableStationID = -1;
                String cableBUName = null;
                cableSrcendType = cablePO.getSrcType();
                boolean cableSrcEndIsStation = true;
                if (0 == cableSrcendType) {
                    cableStationID = cablePO.getSrcStationID();
                    cableBUName = cablePO.getSinkNodeName();
                    cableSrcEndIsStation = true;
                } else if (1 == cableSrcendType) {
                    cableStationID = cablePO.getSinkStationID();
                    cableBUName = cablePO.getSrcNodeName();
                    cableSrcEndIsStation = false;
                }
                if (-1 == cableStationID || null == cableBUName) continue;
                boolean checkBUName = false;
                String lineBUName = ((TELineDevicePO)buDeviceList.get(0)).getRemark();
                checkBUName = cableBUName.equals(lineBUName);
                if (!checkBUName) continue;
                boolean checkStation = false;
                int tmpStnID = snkLineStation.getStationID();
                if (cableSrcEndIsStation) {
                    tmpStnID = srcLineStation.getStationID();
                }
                boolean bl = checkStation = cableStationID == tmpStnID;
                if (!checkStation) continue;
                linesOnCable.add(line);
                continue;
            }
            if (5 != lineType) continue;
            if (0 == cableType) {
                int rightindex;
                String cableSrcBUName = cablePO.getSrcNodeName();
                String cableSinkBUName = cablePO.getSinkNodeName();
                int leftindex = TEMarineCableBindLineHandler.findBUPos(cableSrcBUName, buDeviceList);
                if (-1 == leftindex || -1 == (rightindex = TEMarineCableBindLineHandler.findBUPos(cableSinkBUName, buDeviceList)) || Math.abs(leftindex - rightindex) != 1) continue;
                linesOnCable.add(line);
                continue;
            }
            if (2 != cableType) continue;
            int cableStnID = -1;
            String cableBUName = null;
            cableSrcendType = cablePO.getSrcType();
            if (0 == cableSrcendType) {
                cableStnID = cablePO.getSrcStationID();
                cableBUName = cablePO.getSinkNodeName();
            } else if (1 == cableSrcendType) {
                cableStnID = cablePO.getSinkStationID();
                cableBUName = cablePO.getSrcNodeName();
            }
            if (-1 == (index = TEMarineCableBindLineHandler.findBUPos(cableBUName, buDeviceList))) continue;
            if (0 == index && cableStnID == srcLineStation.StationID) {
                linesOnCable.add(line);
                continue;
            }
            if (buDeviceList.size() - 1 != index || cableStnID != snkLineStation.StationID) continue;
            linesOnCable.add(line);
        }
        return linesOnCable;
    }

    private static int findBUPos(String buName, List<TELineDevicePO> buDeviceList) {
        int pos = -1;
        int devSize = buDeviceList.size();
        for (int devIndex = 0; devIndex < devSize; ++devIndex) {
            TELineDevicePO dev = buDeviceList.get(devIndex);
            if (!dev.getRemark().equals(buName)) continue;
            pos = devIndex;
            break;
        }
        return pos;
    }

    private static void sortBU(List<TELineDevicePO> buNameList) {
        Collections.sort(buNameList, new BUComparator());
    }

    private static int getLineType(TESLMLinePO line, List<TELineDevicePO> buList) {
        int type = 0;
        int srcNEID = (int)line.getNeID();
        int snkNEID = (int)line.getOppositeNEID();
        if (srcNEID == 0 || snkNEID == 0) {
            type = 0;
            return type;
        }
        int buC = 0;
        Set DeviceList = line.getDeviceList();
        for (TELineDevicePO device : DeviceList) {
            int dtype = device.getDeviceType();
            if (!TEMarineCableBindLineHandler.isBUDevType(dtype)) continue;
            buList.add(device);
            ++buC;
        }
        if (buC == 0) {
            type = 3;
        } else if (buC == 1) {
            type = 4;
        } else if (buC > 1) {
            type = 5;
        }
        return type;
    }

    private static List<TESLMLinePO> getAllRawLineInfo() {
        ArrayList<TESLMLinePO> lineInfo = new ArrayList<TESLMLinePO>();
        int neID = 0;
        TIntArrayList neList = null;
        neList = TEMarineLinePubFun.getNeList();
        int size = neList.size();
        for (int i = 0; i < size; ++i) {
            int retCode;
            neID = neList.get(i);
            int[] metadata = new int[]{neID};
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.findAll((int[])metadata, TESLMLinePO.class);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().info("", (Throwable)e);
            }
            if (null == dbResult || 0 != (retCode = dbResult.getResult())) continue;
            lineInfo.addAll(dbResult.getData());
        }
        return lineInfo;
    }

    public static int getCableType(int src, int snk) {
        int code = src << 4 | snk;
        return CABLETYPEMAP.get(code);
    }

    private static int getCableType(TEMarineCablePO cablePO) {
        int srcType = cablePO.getSrcType();
        int snkType = cablePO.getSinkType();
        return TEMarineCableBindLineHandler.getCableType(srcType, snkType);
    }

    private static boolean checkByLineTypeAndCableType(int lineType, int cableType) {
        boolean result = false;
        int[] cc = (int[])LINE2CABLEMAP.get(lineType);
        if (null == cc) {
            result = false;
        } else {
            Arrays.sort(cc);
            int index = Arrays.binarySearch(cc, cableType);
            result = -1 != index;
        }
        return result;
    }

    private static TEMarineStationPO getStationByNEID(int neID, List<TEMarineStationPO> stations) {
        TEMarineStationPO tStation = null;
        Set nes = null;
        block0: for (TEMarineStationPO station : stations) {
            nes = station.getShelfList();
            for (TEMarineStationNEPO ne : nes) {
                if ((long)neID != ne.neID) continue;
                tStation = station;
                continue block0;
            }
        }
        return tStation;
    }

    private static List<TEMarineStationPO> getAllStations() {
        ArrayList<TEMarineStationPO> stations = new ArrayList<TEMarineStationPO>();
        try {
            int retCode;
            TEDaoOperationResult dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            if (null != dbResult && 0 == (retCode = dbResult.getResult())) {
                for (Object obj : dbResult.getData()) {
                    stations.add((TEMarineStationPO)obj);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        return stations;
    }

    public static List<TEMarineCablePO> getAllCables() {
        ArrayList<TEMarineCablePO> cables = new ArrayList<TEMarineCablePO>();
        try {
            int retCode;
            TEDaoOperationResult dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
            if (null != dbResult && 0 == (retCode = dbResult.getResult())) {
                for (Object obj : dbResult.getData()) {
                    cables.add((TEMarineCablePO)obj);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        return cables;
    }

    static {
        CABLETYPEMAP.put(0, 1);
        CABLETYPEMAP.put(17, 0);
        CABLETYPEMAP.put(16, 2);
        CABLETYPEMAP.put(1, 2);
        LINE2CABLEMAP = new TIntObjectHashMap();
        int[] NE_AND_BU_LINE_COLLEC = new int[]{0, 1};
        int[] NE_NE_NON_BU_LINE_COLLEC = new int[]{0, 2};
        int[] NE_NE_HAS_ONE_BU_LINE_COLLEC = new int[]{0, 1};
        int[] NE_NE_HAS_MORE_BU_LINE_COLLEC = new int[]{1};
        LINE2CABLEMAP.put(2, (Object)NE_AND_BU_LINE_COLLEC);
        LINE2CABLEMAP.put(3, (Object)NE_NE_NON_BU_LINE_COLLEC);
        LINE2CABLEMAP.put(4, (Object)NE_NE_HAS_ONE_BU_LINE_COLLEC);
        LINE2CABLEMAP.put(5, (Object)NE_NE_HAS_MORE_BU_LINE_COLLEC);
    }

    private static class BUComparator
    implements Comparator {
        private BUComparator() {
        }

        public int compare(Object o1, Object o2) {
            TELineDevicePO abu = (TELineDevicePO)o1;
            TELineDevicePO bbu = (TELineDevicePO)o2;
            if (abu.getSpanID() < bbu.getSpanID()) {
                return -1;
            }
            if (abu.getSpanID() > bbu.getSpanID()) {
                return 1;
            }
            return abu.getDistance() - bbu.getDistance();
        }
    }
}

