/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.common;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.common.TESLMSinkNEStruct;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TESLMLineUtil {
    private static final String UNKNOWN = "UNKNOWN";
    private static final int LINE_LMU_PORT_ID = 1;
    private static final int LINE_LMI_PORT_ID = 2;
    private static final int PARM_INDEX_SLOTID = 0;
    private static final int PARM_INDEX_NEID = 1;
    private static final int PARM_INDEX_NENAME = 2;
    private static final int PARM_INDEX_BDNAME = 3;
    private static final int PARM_INDEX_BDTYPE = 4;
    private static final int PARM_INDEX_PORTID = 5;
    private static final int PARM_INDEX_PORTNAME = 6;
    protected static final int NSERR_MARINE_LINE_NOT_CONSISTANT = 1090615103;
    private static final int EMPTY_RESULT = 38662;

    public static RowParams getOutputRowParams(Datainterface outputData, Output output) {
        int lineID = Integer.valueOf(output.getPart("lineID").getValue());
        ArrayList rowParamsList = outputData.getBussinessParams().getRowParamList();
        for (RowParams rowParams : rowParamsList) {
            int tmpLineID;
            Param param = rowParams.getParam("lineID");
            if (null == param || lineID != (tmpLineID = Integer.valueOf(param.getValue()).intValue())) continue;
            return rowParams;
        }
        return new RowParams();
    }

    private static void handleBaseUnit(int handleNEID, RowParams rowparams, Output output, String[] paramNames, int boardType) {
        if (7 != paramNames.length) {
            return;
        }
        int srcNEID = handleNEID;
        int slotID = TESLMLineUtil.getSlotID(output, boardType);
        int portID = TESLMLineUtil.getPortID(output, boardType);
        rowparams.addParam(paramNames[1], String.valueOf(srcNEID));
        rowparams.addParam(paramNames[0], String.valueOf(slotID));
        rowparams.addParam(paramNames[5], String.valueOf(portID));
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(srcNEID);
        if (null == ne) {
            rowparams.addParam(paramNames[2], UNKNOWN);
            rowparams.addParam(paramNames[3], UNKNOWN);
            rowparams.addParam(paramNames[4], String.valueOf(boardType));
            rowparams.addParam(paramNames[6], UNKNOWN);
            return;
        }
        rowparams.addParam(paramNames[2], ne.getNEName());
        TEBoard boardInfo = ne.getBoard(slotID);
        if (null == boardInfo) {
            rowparams.addParam(paramNames[3], UNKNOWN);
            rowparams.addParam(paramNames[4], String.valueOf(boardType));
            rowparams.addParam(paramNames[6], UNKNOWN);
            return;
        }
        rowparams.addParam(paramNames[3], boardInfo.getBoardName());
        rowparams.addParam(paramNames[4], String.valueOf(boardInfo.getBoardType()));
        String portName = TEConfigurationDataMgr.getInstance().getPortName(srcNEID, slotID, boardType, portID);
        rowparams.addParam(paramNames[6], portName);
    }

    private static int getSlotID(Output output, int boardType) {
        int slotID = 0;
        if (null == output) {
            return slotID;
        }
        switch (boardType) {
            case 1628: {
                slotID = Integer.valueOf(output.getPart("lmuSlot").getValue());
                break;
            }
            case 1629: {
                slotID = Integer.valueOf(output.getPart("lasSlot").getValue());
                break;
            }
            case 1630: {
                slotID = Integer.valueOf(output.getPart("lmiSlot").getValue());
                break;
            }
        }
        return slotID;
    }

    private static int getPortID(Output output, int boardType) {
        if (null == output) {
            return 0;
        }
        int portID = 2;
        if (1628 == boardType) {
            portID = 1;
        } else if (1629 == boardType) {
            portID = Integer.valueOf(output.getPart("lasPort").getValue());
        }
        return portID;
    }

    public static void setErrorMessageInfo(Datainterface outputData, int curNEID, int bigErrorCode, int resultCode) {
        BussinessParams bParam = null;
        if (null == outputData.getBussinessParams()) {
            bParam = new BussinessParams();
            outputData.setBussinessParams(bParam);
        } else {
            bParam = outputData.getBussinessParams();
        }
        String nename = TENEListMgr.getInstance().getNE(curNEID).getNEName();
        RowParams rParam = new RowParams();
        RowErrors rowError = new RowErrors();
        Param errorParam = new Param("nename", nename);
        rowError.addParam(errorParam);
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)curNEID, (int)resultCode));
        rParam.addRowErrors(rowError);
        bParam.addRowParams(rParam);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)bigErrorCode));
    }

    public static void setErrorMessageInfo(Datainterface outputData, int neid, int sendMessageResult, ArrayList operationList) {
        BussinessParams bParam;
        int errorcode;
        int result;
        ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Output outputArr;
            Operation tmpOper = (Operation)operationList.get(i);
            Output output = outputArr = tmpOper.getOutput()[0];
            for (Fault fault : output.getFault()) {
                if (null == fault.getCode()) continue;
                int code = 0;
                code = fault.getCode().equals("") ? 2 : Integer.parseInt(fault.getCode());
                if (code == 0 || code == 38662) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)neid, (int)code));
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)code));
                rowErrorList.add(rowError);
            }
        }
        if (65536 > sendMessageResult) {
            result = 0;
            if (!rowErrorList.isEmpty()) {
                result = 1;
            }
            if (rowErrorList.size() == operationList.size()) {
                result = 2;
            }
            if (rowErrorList.isEmpty()) {
                if (null == outputData.getErrorMessage() || null == outputData.getErrorMessage().getErrorcode()) {
                    result = 0;
                } else {
                    try {
                        errorcode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
                        result = errorcode == 0 ? 0 : 1;
                    }
                    catch (Exception e) {
                        result = 0;
                    }
                }
            }
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)result);
            outputData.setErrorMessage(bigErr);
            bParam = null;
            if (null == outputData.getBussinessParams()) {
                bParam = new BussinessParams();
                outputData.setBussinessParams(bParam);
            } else {
                bParam = outputData.getBussinessParams();
            }
            int size = rowErrorList.size();
            for (int i = 0; i < size; ++i) {
                RowParams rParam = new RowParams();
                RowErrors rError = (RowErrors)rowErrorList.get(i);
                rParam.addRowErrors(rError);
                bParam.addRowParams(rParam);
            }
        } else {
            result = 0;
            if (null == outputData.getErrorMessage() || null == outputData.getErrorMessage().getErrorcode()) {
                result = sendMessageResult;
            } else {
                try {
                    errorcode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
                    result = errorcode == 0 || errorcode == 1 ? 1 : sendMessageResult;
                }
                catch (Exception e) {
                    result = sendMessageResult;
                }
            }
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)result);
            outputData.setErrorMessage(bigErr);
            bParam = null;
            if (null == outputData.getBussinessParams()) {
                bParam = new BussinessParams();
                outputData.setBussinessParams(bParam);
            } else {
                bParam = outputData.getBussinessParams();
            }
            RowParams rParam = new RowParams();
            RowErrors rowError = new RowErrors();
            Param errorParam = new Param("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
            rowError.addParam(errorParam);
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)result));
            rParam.addRowErrors(rowError);
            bParam.addRowParams(rParam);
        }
    }

    public static void setErrorMessageInfo(Datainterface outputData, int neid, int curNEID, String objectName, int resultCode) {
        ErrorMessage bigErr = outputData.getErrorMessage();
        if (0 == resultCode) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return;
        }
        if (0 == resultCode && !bigErr.getErrorcode().equals(String.valueOf(0))) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            return;
        }
        bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
        if (0 != resultCode && curNEID != neid) {
            bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
        }
        outputData.setErrorMessage(bigErr);
        BussinessParams bParam = null;
        if (null == outputData.getBussinessParams()) {
            bParam = new BussinessParams();
            outputData.setBussinessParams(bParam);
        } else {
            bParam = outputData.getBussinessParams();
        }
        RowParams rParam = new RowParams();
        RowErrors rowError = new RowErrors();
        Param errorParam = new Param("nename", objectName);
        rowError.addParam(errorParam);
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)curNEID, (int)resultCode));
        rParam.addRowErrors(rowError);
        bParam.addRowParams(rParam);
    }

    public static void setErrorMessageInfoList(Datainterface outputData, int curNEID, ArrayList operationList) {
        ErrorMessage bigErr = outputData.getErrorMessage();
        BussinessParams bParam = null;
        if (null == outputData.getBussinessParams()) {
            bParam = new BussinessParams();
            outputData.setBussinessParams(bParam);
        } else {
            bParam = outputData.getBussinessParams();
        }
        String nename = TENEListMgr.getInstance().getNE(curNEID).getNEName();
        int failOperNum = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Output outputArr;
            Operation tmpOper = (Operation)operationList.get(i);
            Output output = outputArr = tmpOper.getOutput()[0];
            for (Fault fault : output.getFault()) {
                int code;
                if (null == fault.getCode() || 0 == (code = Integer.parseInt(fault.getCode())) || 42781 == code || 44753 == code) continue;
                ++failOperNum;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)curNEID, (int)code));
                RowParams rParam = new RowParams();
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("nename", nename);
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)curNEID, (int)code));
                rParam.addRowErrors(rowError);
                bParam.addRowParams(rParam);
            }
        }
        bigErr = null == bigErr ? (0 == failOperNum ? TEErrorResourceUtil.getErrorMessage((int)0) : (operationList.size() > failOperNum ? TEErrorResourceUtil.getErrorMessage((int)1) : TEErrorResourceUtil.getErrorMessage((int)2))) : (bigErr.getErrorcode().equals(String.valueOf(0)) ? (0 == failOperNum ? TEErrorResourceUtil.getErrorMessage((int)0) : TEErrorResourceUtil.getErrorMessage((int)1)) : (bigErr.getErrorcode().equals(String.valueOf(2)) ? (failOperNum >= operationList.size() ? TEErrorResourceUtil.getErrorMessage((int)2) : TEErrorResourceUtil.getErrorMessage((int)1)) : TEErrorResourceUtil.getErrorMessage((int)1)));
        outputData.setErrorMessage(bigErr);
    }

    public static void setRowErrorLineNotConsistant(Datainterface outputData, int neid, int logicNEID, RowParams rowParams, Param srcParam, Param sinkParam) {
        if (0 == logicNEID || neid == logicNEID) {
            return;
        }
        TENE neInfo = TEConfigurationDataMgr.getInstance().getNE(logicNEID);
        if (null == neInfo) {
            return;
        }
        if (null != srcParam && null != sinkParam) {
            return;
        }
        Param param = rowParams.getParam("lineID");
        if (null != param) {
            Param param1 = rowParams.getParam("isSame");
            if (null != param1) {
                param1.setValue("false");
            } else {
                rowParams.addParam("isSame", "false");
            }
            int tmpLineID = Integer.valueOf(param.getValue());
            TESLMLineUtil.setRowErrorMessageInfo(outputData, rowParams, neid, logicNEID, tmpLineID, 1090615103);
        }
    }

    public static void setRowErrorMessageInfo(Datainterface outputData, RowParams rowparams, int neid, int curNEID, int lineID, int resultCode) {
        if (0 == resultCode) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return;
        }
        ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
        if (0 != resultCode && curNEID != neid) {
            bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
        }
        outputData.setErrorMessage(bigErr);
        RowErrors rowError = new RowErrors();
        Param errorParam = new Param("nename", TENEListMgr.getInstance().getNE(curNEID).getNEName() + "-" + lineID);
        rowError.addParam(errorParam);
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)curNEID, (int)resultCode));
        rowparams.addRowErrors(rowError);
    }

    public static void addRowParamsData(Datainterface outputData, RowParams rowparams) {
        int lineID = Integer.valueOf(rowparams.getParam("lineID").getValue());
        ArrayList rowParamsList = outputData.getBussinessParams().getRowParamList();
        boolean haveRow = false;
        for (RowParams rowParams : rowParamsList) {
            int tmpLineID;
            Param param = rowParams.getParam("lineID");
            if (null == param || lineID != (tmpLineID = Integer.valueOf(param.getValue()).intValue())) continue;
            haveRow = true;
        }
        if (!haveRow) {
            outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    public static void handleReserveOutputData(Datainterface outputData, int neid, int handleNEID, Output output, int lineDirection, List<TESLMSinkNEStruct> sinkNEList, boolean isSource) {
        RowParams rowparams;
        if (null != output) {
            rowparams = TESLMLineUtil.getOutputRowParams(outputData, output);
            int lineID = Integer.valueOf(output.getPart("lineID").getValue());
            rowparams.addParam("lineID", String.valueOf(lineID));
        } else {
            rowparams = new RowParams();
            rowparams.addParam("lineID", String.valueOf(0));
        }
        if (handleNEID == neid) {
            rowparams.addParam("lineDirection", String.valueOf(lineDirection));
        }
        String[] lmuParamNames = new String[]{"sinkLmuSlotId", "sinkLmuneid", "sinkLmuNeName", "sinkLmuBoardName", "sinkLmuBoardType", "sinkLmuPortId", "sinkLmuPortName"};
        TESLMLineUtil.handleBaseUnit(handleNEID, rowparams, output, lmuParamNames, 1628);
        String[] loaParamNames = new String[]{"sinkLasSlotId", "sinkLasneid", "sinkLasNeName", "sinkLasBoardName", "sinkLasBoardType", "sinkLasPortId", "sinkLasPortName"};
        TESLMLineUtil.handleBaseUnit(handleNEID, rowparams, output, loaParamNames, 1629);
        String[] lmiParamNames = new String[]{"sinkLmiSlotId", "sinkLmineid", "sinkLmiNeName", "sinkLmiBoardName", "sinkLmiBoardType", "sinkLmiPortId", "sinkLmiPortName"};
        TESLMLineUtil.handleBaseUnit(handleNEID, rowparams, output, lmiParamNames, 1630);
        if (isSource) {
            String[] sinkParam = new String[]{"srcSaveSinkLmiSlotId", "srcSaveSinkLmineid", "srcSaveSinkneid"};
            TESLMLineUtil.handleOtherUnitSource(neid, handleNEID, rowparams, output, sinkParam, sinkNEList);
        } else {
            String[] sinkParam = new String[]{"srcLmiSlotId", "srcLmineid"};
            TESLMLineUtil.handleOtherUnitSink(neid, handleNEID, rowparams, output, sinkParam, sinkNEList);
        }
        TESLMLineUtil.addRowParamsData(outputData, rowparams);
    }

    public static void handlePositiveOutputData(Datainterface outputData, int neid, int handleNEID, Output output, int lineDirection, List<TESLMSinkNEStruct> sinkNEList, boolean isSource) {
        RowParams rowparams;
        if (null != output) {
            rowparams = TESLMLineUtil.getOutputRowParams(outputData, output);
            int lineID = Integer.valueOf(output.getPart("lineID").getValue());
            rowparams.addParam("lineID", String.valueOf(lineID));
        } else {
            rowparams = new RowParams();
            rowparams.addParam("lineID", String.valueOf(0));
        }
        rowparams.addParam("lineDirection", String.valueOf(lineDirection));
        String[] lmuParamNames = new String[]{"srcLmuSlotId", "srcLmuneid", "srcLmuNeName", "srcLmuBoardName", "srcLmuBoardType", "srcLmuPortId", "srcLmuPortName"};
        TESLMLineUtil.handleBaseUnit(handleNEID, rowparams, output, lmuParamNames, 1628);
        String[] loaParamNames = new String[]{"srcLasSlotId", "srcLasneid", "srcLasNeName", "srcLasBoardName", "srcLasBoardType", "srcLasPortId", "srcLasPortName"};
        TESLMLineUtil.handleBaseUnit(handleNEID, rowparams, output, loaParamNames, 1629);
        String[] lmiParamNames = new String[]{"srcLmiSlotId", "srcLmineid", "srcLmiNeName", "srcLmiBoardName", "srcLmiBoardType", "srcLmiPortId", "srcLmiPortName"};
        TESLMLineUtil.handleBaseUnit(handleNEID, rowparams, output, lmiParamNames, 1630);
        if (isSource) {
            String[] sinkParam = new String[]{"srcSaveSinkLmiSlotId", "srcSaveSinkLmineid", "srcSaveSinkneid"};
            TESLMLineUtil.handleOtherUnitSource(neid, handleNEID, rowparams, output, sinkParam, sinkNEList);
        } else {
            String[] sinkParam = new String[]{"srcSaveSinkLmiSlotId", "srcSaveSinkLmineid"};
            TESLMLineUtil.handleOtherUnitSink(neid, handleNEID, rowparams, output, sinkParam, sinkNEList);
        }
        TESLMLineUtil.addRowParamsData(outputData, rowparams);
    }

    private static void handleOtherUnitSource(int neid, int curNEID, RowParams rowparams, Output output, String[] sinkParam, List<TESLMSinkNEStruct> sinkNEList) {
        if (null == output) {
            rowparams.addParam(sinkParam[0], String.valueOf(0));
            rowparams.addParam(sinkParam[1], String.valueOf(0));
            return;
        }
        int lineID = Integer.valueOf(output.getPart("lineID").getValue());
        int srcLmineid = neid;
        int srcLmiSlotId = Integer.valueOf(output.getPart("lmiSlot").getValue());
        int sinkLmineid = Integer.valueOf(output.getPart("opNeID").getValue());
        int sinkLmiSlotId = Integer.valueOf(output.getPart("opLmiSlot").getValue());
        int lineDirection = Integer.valueOf(output.getPart("lineDirection").getValue());
        rowparams.addParam(sinkParam[0], String.valueOf(sinkLmiSlotId));
        rowparams.addParam(sinkParam[1], String.valueOf(sinkLmineid));
        if (0 == sinkLmineid) {
            rowparams.addParam(sinkParam[2], String.valueOf(sinkLmineid));
        } else {
            TENE sinkNE = TENEListMgr.getInstance().getPhyNE(sinkLmineid);
            if (null == sinkNE) {
                rowparams.addParam(sinkParam[2], "0");
            } else {
                rowparams.addParam(sinkParam[2], String.valueOf(sinkNE.getNEID()));
            }
        }
        if (curNEID != neid) {
            return;
        }
        TESLMSinkNEStruct sinkNEStruct = new TESLMSinkNEStruct(lineID, srcLmineid, srcLmiSlotId, sinkLmineid, sinkLmiSlotId, lineDirection);
        if (sinkNEList.contains(sinkNEStruct)) {
            return;
        }
        sinkNEList.add(sinkNEStruct);
    }

    private static void handleOtherUnitSink(int neid, int curNEID, RowParams rowparams, Output output, String[] sinkParam, List<TESLMSinkNEStruct> sinkNEList) {
        TENE sinkNE;
        if (null == output) {
            rowparams.addParam(sinkParam[0], String.valueOf(0));
            rowparams.addParam(sinkParam[1], String.valueOf(0));
            return;
        }
        int lineID = Integer.valueOf(output.getPart("lineID").getValue());
        int sinkLmineid = Integer.valueOf(output.getPart("opNeID").getValue());
        if (0 != sinkLmineid && null != (sinkNE = TENEListMgr.getInstance().getPhyNE(sinkLmineid))) {
            sinkLmineid = sinkNE.getNEID();
        }
        int sinkLmiSlotId = Integer.valueOf(output.getPart("opLmiSlot").getValue());
        int lineDirection = Integer.valueOf(output.getPart("lineDirection").getValue());
        rowparams.addParam(sinkParam[0], String.valueOf(sinkLmiSlotId));
        rowparams.addParam(sinkParam[1], String.valueOf(sinkLmineid));
        TESLMSinkNEStruct sinkNEStruct = new TESLMSinkNEStruct(lineID, sinkLmineid, sinkLmiSlotId, lineDirection);
        sinkNEList.add(sinkNEStruct);
    }

    public static Operation getUnderwaterOperation(Operation underwaterOperation, RowParams rowParams, boolean isPositiveDirection) {
        Operation tempOperation = underwaterOperation;
        Input input = tempOperation.getInput();
        if (isPositiveDirection) {
            input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
            input.setPartValue("eqptId", rowParams.getParam("eqptId").getValue());
            input.setPartValue("spanId", rowParams.getParam("spanId").getValue());
            input.setPartValue("eqptType", rowParams.getParam("eqptType").getValue());
            input.setPartValue("eqptDistance", rowParams.getParam("eqptDistance").getValue());
            input.setPartValue("eqptName", rowParams.getParam("eqptName").getValue());
        } else {
            input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
            input.setPartValue("eqptId", rowParams.getParam("eqptId").getValue());
            try {
                int spanNum = Integer.parseInt(rowParams.getParam("spanNum").getValue());
                int spanId = Integer.parseInt(rowParams.getParam("spanId").getValue());
                input.setPartValue("spanId", Integer.toString(spanNum + 1 - spanId));
            }
            catch (Exception e) {
                input.setPartValue("spanId", rowParams.getParam("spanId").getValue());
            }
            input.setPartValue("eqptType", rowParams.getParam("eqptType").getValue());
            try {
                int eqptDistanceLength = Integer.parseInt(rowParams.getParam("eqptDistanceLength").getValue());
                int eqptDistance = Integer.parseInt(rowParams.getParam("eqptDistance").getValue());
                input.setPartValue("eqptDistance", Integer.toString(eqptDistanceLength - eqptDistance));
            }
            catch (Exception e) {
                input.setPartValue("eqptDistance", rowParams.getParam("eqptDistance").getValue());
            }
            input.setPartValue("eqptName", rowParams.getParam("eqptName").getValue());
        }
        return tempOperation;
    }

    public static List<Object> getSLMLinePOData(int neID) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int[])new int[]{neID}, TESLMLinePO.class);
            List data = dbResult.getData();
            return data;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error(e.toString());
            return null;
        }
    }
}

