/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clockptp.db.observer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.marine.clockptp.db.TEBeanObserverIF;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockConverterOTN;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockDeviceDBMgr;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceFromNE;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EBMCData;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryInnerClockSource;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQuerySyncAttribute;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class TEQuerySyncAttriBeanObserver
implements TEBeanObserverIF {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    @Override
    public void operSaveDB(int neID, int cmdID, List<Operation> operationList) {
    }

    public void perfomWNEMgrBussinessProcess(int neID, Datainterface inputData, Datainterface outputData) {
        if (null == outputData) {
            return;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            this.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
        }
        if (null == outputData.getBussinessParams()) {
            this.logNullBussinessParamsError();
            return;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            this.logNullRowParamsError();
            return;
        }
        RowParams rowParams = outputData.getBussinessParams().getRowParams(0);
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEPTPClockPropertyMOPO moDevice = TEE2EClockDeviceDBMgr.getClockDeviceFromDB(neID, errRet);
        TEE2EClockDevice dataDevice = null;
        if (null == moDevice) {
            dataDevice = TEQuerySyncAttriBeanObserver.buildClockDevice(neID);
            TEE2EQuerySyncAttribute.parseAttributeFromRowParams(neID, dataDevice, rowParams);
            errRet = new TEErrInfoReturn();
            TEE2EClockDeviceDBMgr.createClockDeviceToDB(neID, dataDevice, errRet);
        } else {
            dataDevice = TEE2EClockConverterOTN.mo2Data(neID, moDevice);
            TEE2EBMCData data = TEQuerySyncAttriBeanObserver.getBMCFromMO(moDevice);
            this.clearInnerAndPortClock(dataDevice);
            TEE2EQuerySyncAttribute.parseAttributeFromRowParams(neID, dataDevice, rowParams);
            TEE2EGetClockDeviceFromNE.updateBMC(dataDevice, data);
            errRet = new TEErrInfoReturn();
            TEE2EClockDeviceDBMgr.updateClockDeviceToDB(neID, dataDevice, errRet);
        }
    }

    public static TEE2EBMCData getBMCFromMO(TEPTPClockPropertyMOPO moDevice) {
        TEE2EBMCData bmcData = new TEE2EBMCData();
        bmcData.setTimelevel(moDevice.getPTPQuality());
        bmcData.setTimeprecision(moDevice.getPTPPrecision());
        bmcData.setClocktype(moDevice.getPTPLocalSrcType());
        bmcData.setClockpri1(moDevice.getPTPSrcPriority1());
        bmcData.setClockpri2(moDevice.getPTPSrcPriority2());
        return bmcData;
    }

    private void clearInnerAndPortClock(TEE2EClockDevice dataDevice) {
        List clockSourceList = dataDevice.getClockSourceList();
        Iterator iter = clockSourceList.iterator();
        while (iter.hasNext()) {
            TEE2EClockSource source = (TEE2EClockSource)iter.next();
            if (1 != source.getType()) continue;
            iter.remove();
        }
    }

    @Override
    public void addWnemgrBusClassMapping(SubFunc subFunc) {
        subFunc.setWnemgrBussinessMapping(this.getClass().getName());
    }

    public static TEE2EClockDevice buildClockDevice(int neID) {
        TEE2EClockDevice device = new TEE2EClockDevice();
        device.setNeID(neID);
        TEE2EQueryInnerClockSource.queryInnerClockSource(neID, device);
        device.setClockSyncState(-1);
        device.setTimeSyncState(-1);
        device.setPoOperMask(-1);
        device.setPoSearchMode(1);
        device.setClockDevType(1);
        return device;
    }

    private void logBeanOperError(int neID, int retCode) {
        String tipStr = String.format("bean oper error! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private void logNullBussinessParamsError() {
        e2eLogger.error("bussinessparams is null!");
    }

    private void logNullRowParamsError() {
        e2eLogger.error("rowparams is null!");
    }
}

