/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clockptp.db.observer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.marine.clockptp.db.TEBeanObserverIF;
import com.huawei.nglct.nemgr.marine.clockptp.db.observer.TEQuerySyncAttriBeanObserver;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockConverterOTN;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockDeviceDBMgr;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQuerySubnet;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.List;
import org.slf4j.Logger;

public class TEQuerySubnetBeanObserver
implements TEBeanObserverIF {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    @Override
    public void operSaveDB(int neID, int cmdID, List<Operation> operationList) {
    }

    @Override
    public void addWnemgrBusClassMapping(SubFunc subFunc) {
        subFunc.setWnemgrBussinessMapping(this.getClass().getName());
    }

    public void perfomWNEMgrBussinessProcess(int neID, Datainterface inputData, Datainterface outputData) {
        if (null == outputData) {
            return;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            this.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
        }
        if (null == outputData.getBussinessParams()) {
            this.logNullBussinessParamsError();
            return;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            this.logNullRowParamsError();
            return;
        }
        RowParams rowParams = outputData.getBussinessParams().getRowParams(0);
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEPTPClockPropertyMOPO moDevice = TEE2EClockDeviceDBMgr.getClockDeviceFromDB(neID, errRet);
        TEE2EClockDevice dataDevice = null;
        if (null == moDevice) {
            dataDevice = TEQuerySyncAttriBeanObserver.buildClockDevice(neID);
            TEE2EQuerySubnet.parseAttributeFromRowParams(neID, dataDevice, rowParams);
            errRet = new TEErrInfoReturn();
            TEE2EClockDeviceDBMgr.createClockDeviceToDB(neID, dataDevice, errRet);
        } else {
            dataDevice = TEE2EClockConverterOTN.mo2Data(neID, moDevice);
            TEE2EQuerySubnet.parseAttributeFromRowParams(neID, dataDevice, rowParams);
            errRet = new TEErrInfoReturn();
            TEE2EClockDeviceDBMgr.updateClockDeviceToDB(neID, dataDevice, errRet);
        }
    }

    private void logBeanOperError(int neID, int retCode) {
        String tipStr = String.format("bean oper error! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private void logNullBussinessParamsError() {
        e2eLogger.error("bussinessparams is null!");
    }

    private void logNullRowParamsError() {
        e2eLogger.error("rowparams is null!");
    }
}

