/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clockptp.db.observer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EUniResID;
import com.huawei.nglct.nemgr.marine.clockptp.db.TEBeanObserverIF;
import com.huawei.nglct.nemgr.marine.clockptp.db.observer.TEQuerySyncAttriBeanObserver;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockConverterOTN;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockDeviceDBMgr;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.fdn.FDNUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryReceivesourceBeanObserver
implements TEBeanObserverIF {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    @Override
    public void operSaveDB(int neID, int cmdID, List<Operation> operationList) {
    }

    public void perfomWNEMgrBussinessProcess(int neID, Datainterface inputData, Datainterface outputData) {
        if (null == outputData) {
            return;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            this.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
        }
        if (null == outputData.getBussinessParams()) {
            this.logNullBussinessParamsError();
            return;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            this.logNullRowParamsError();
            return;
        }
        RowParams rowParams = outputData.getBussinessParams().getRowParams(0);
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEPTPClockPropertyMOPO moDevice = TEE2EClockDeviceDBMgr.getClockDeviceFromDB(neID, errRet);
        TEE2EClockDevice dataDevice = null;
        if (null == moDevice) {
            dataDevice = TEQuerySyncAttriBeanObserver.buildClockDevice(neID);
            this.parseAttributeFromRowParams(neID, dataDevice, rowParams);
            errRet = new TEErrInfoReturn();
            TEE2EClockDeviceDBMgr.createClockDeviceToDB(neID, dataDevice, errRet);
        } else {
            dataDevice = TEE2EClockConverterOTN.mo2Data(neID, moDevice);
            this.parseAttributeFromRowParams(neID, dataDevice, rowParams);
            errRet = new TEErrInfoReturn();
            TEE2EClockDeviceDBMgr.updateClockDeviceToDB(neID, dataDevice, errRet);
        }
    }

    @Override
    public void addWnemgrBusClassMapping(SubFunc subFunc) {
        subFunc.setWnemgrBussinessMapping(this.getClass().getName());
    }

    private void parseAttributeFromRowParams(int neID, TEE2EClockDevice dataDevice, RowParams rowParams) {
        if (0 != rowParams.getRowErrorsCount()) {
            return;
        }
        List clockPortList = dataDevice.getClockPortList();
        for (TEE2EClockPort clockPort : clockPortList) {
            TEE2EUniResID portIndex = clockPort.getPortIndex();
            int slotID = FDNUtil.getSlotID((String)portIndex.getStrFDN());
            int portID = FDNUtil.getPortID((String)portIndex.getStrFDN());
            int rowSlotID = TEE2EGetClockDeviceUtil.getIntParam(rowParams, "slotid", -1);
            int rowPortID = TEE2EGetClockDeviceUtil.getIntParam(rowParams, "portid", -1);
            if (slotID != rowSlotID || portID != rowPortID) continue;
            clockPort.setState(TEE2EGetClockDeviceUtil.getIntParam(rowParams, "linkstatus", -1));
        }
    }

    private void logBeanOperError(int neID, int retCode) {
        String tipStr = String.format("bean oper error! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private void logNullBussinessParamsError() {
        e2eLogger.error("bussinessparams is null!");
    }

    private void logNullRowParamsError() {
        e2eLogger.error("rowparams is null!");
    }
}

