/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clockptp.db.observer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.marine.clockptp.db.TEBeanObserverIF;
import com.huawei.nglct.nemgr.marine.clockptp.db.observer.TEQuerySyncAttriBeanObserver;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockConverterOTN;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockDeviceDBMgr;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceFromNE;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EBMCData;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryClockPortList;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryPortClockSource;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryPortStatusBeanObserver
implements TEBeanObserverIF {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    @Override
    public void operSaveDB(int neID, int cmdID, List<Operation> operationList) {
    }

    public void perfomWNEMgrBussinessProcess(int neID, Datainterface inputData, Datainterface outputData) {
        if (null == outputData) {
            return;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            this.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            return;
        }
        boolean isNullPort = false;
        RowParams[] rowParamsArr = new RowParams[]{};
        if (null == outputData.getBussinessParams()) {
            this.logNullBussinessParamsError();
            isNullPort = true;
        }
        if (null != outputData.getBussinessParams() && 0 == outputData.getBussinessParams().getRowParamsCount()) {
            this.logNullRowParamsError();
            isNullPort = true;
        }
        if (!isNullPort) {
            rowParamsArr = outputData.getBussinessParams().getRowParams();
        }
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEPTPClockPropertyMOPO moDevice = TEE2EClockDeviceDBMgr.getClockDeviceFromDB(neID, errRet);
        TEE2EClockDevice dataDevice = null;
        if (null == moDevice) {
            dataDevice = TEQuerySyncAttriBeanObserver.buildClockDevice(neID);
            TEE2EQueryPortClockSource.parseAttributeFromRowParams(neID, dataDevice, rowParamsArr);
            TEE2EQueryClockPortList.parseAttributeFromRowParams(neID, dataDevice, rowParamsArr);
            errRet = new TEErrInfoReturn();
            TEE2EClockDeviceDBMgr.createClockDeviceToDB(neID, dataDevice, errRet);
        } else {
            dataDevice = TEE2EClockConverterOTN.mo2Data(neID, moDevice);
            TEE2EBMCData data = TEQuerySyncAttriBeanObserver.getBMCFromMO(moDevice);
            this.clearPtpPort(dataDevice);
            TEE2EQueryPortClockSource.parseAttributeFromRowParams(neID, dataDevice, rowParamsArr);
            TEE2EQueryClockPortList.parseAttributeFromRowParams(neID, dataDevice, rowParamsArr);
            TEE2EGetClockDeviceFromNE.updateBMC(dataDevice, data);
            errRet = new TEErrInfoReturn();
            TEE2EClockDeviceDBMgr.updateClockDeviceToDB(neID, dataDevice, errRet);
        }
    }

    private void clearPtpPort(TEE2EClockDevice dataDevice) {
        List clockSourceList = dataDevice.getClockSourceList();
        Iterator iter = clockSourceList.iterator();
        while (iter.hasNext()) {
            TEE2EClockSource source = (TEE2EClockSource)iter.next();
            if (2 != source.getType()) continue;
            iter.remove();
        }
        List clockPortList = dataDevice.getClockPortList();
        clockPortList.clear();
    }

    @Override
    public void addWnemgrBusClassMapping(SubFunc subFunc) {
        subFunc.setWnemgrBussinessMapping(this.getClass().getName());
    }

    private void logBeanOperError(int neID, int retCode) {
        String tipStr = String.format("bean oper error! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private void logNullBussinessParamsError() {
        e2eLogger.error("bussinessparams is null!");
    }

    private void logNullRowParamsError() {
        e2eLogger.error("rowparams is null!");
    }
}

