/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clockptp;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.clockptp.PTPClockUtil;
import com.huawei.nglct.nemgr.marine.clockptp.Port;
import com.huawei.nglct.nemgr.marine.clockptp.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.marine.clockptp.TEPTPClockConstant;
import com.huawei.nglct.nemgr.marine.clockptp.TEUsableBoardPortResource;
import com.huawei.nglct.nemgr.marine.clockptp.db.TENEOperWrapper;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEQueryPortStatusBean
extends TENEClockWriteLogBean {
    private ArrayList usableResourceList = new ArrayList();
    private static final int ERROR_NOTSUPPORTBMC = 44503;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TENEOperWrapper.addWnemgrBusClassMapping(subFunc);
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.operationList = new ArrayList();
        if (0 != TEUsableBoardPortResource.getPTPEnableResList(neid, this.usableResourceList)) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        this.operationList = this.constructOperationList(subFunc);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid, subFunc);
        if (result == 0) {
            ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
            this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private ArrayList constructOperationList(SubFunc subFunc) {
        ArrayList<Object> operList = new ArrayList<Object>();
        ArrayList portList = PTPClockUtil.getPTPEnablePorts(this.neid, this.getTimeOut(), subFunc, this.usableResourceList);
        if (null == portList || portList.size() == 0) {
            return null;
        }
        for (int i = portList.size() - 1; i >= 0; --i) {
            Port portRes = (Port)portList.get(i);
            String slotid = portRes.soltid;
            String subslotid = portRes.subboradid;
            String portid = portRes.portid;
            Operation operation = null;
            Input input = null;
            if (TEPTPClockConstant.DataBoardsForPTPClock.contains(portRes.getBoardType())) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPPORTVLAN");
                input = operation.getInput();
                input.setPartValue("slotid", slotid);
                input.setPartValue("subslotid", subslotid);
                input.setPartValue("port", portid);
                operList.add(operation.clone());
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPMSGFORMAT");
                input = operation.getInput();
                input.setPartValue("slotid", slotid);
                input.setPartValue("subslotid", subslotid);
                input.setPartValue("port", portid);
                operList.add(operation.clone());
            }
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPPORTSTATE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPPORTREALSTATE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_GETBKSID");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"BDCMD_CFG_GET_PTPMODE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPPORTSTEP");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation.clone());
        }
        return operList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        RowParams row = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            row = rows[i];
            if (row.getRowErrorsCount() > 0) continue;
            int slotid = Integer.parseInt(row.getParam("slotid").getValue());
            int boardType = cfgDataMgr.getBoard(neid, slotid).getBoardType();
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
            if (subrack != null) {
                row.addParam("subrack", subrack);
            }
            row.addParam("boardtype", "" + boardType);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        res.addAll(super.getFilterErrorCodeList());
        res.add(38737);
        res.add(38671);
        res.add(43219);
        res.add(38751);
        res.add(44503);
        res.add(39170);
        return res;
    }
}

