/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clockptp;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.marine.clockptp.PTPClockUtil;
import com.huawei.nglct.nemgr.marine.clockptp.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.marine.clockptp.db.TENEOperWrapper;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEQueryOuterBaseAttrBean
extends TENEClockWriteLogBean {
    @Override
    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TENEOperWrapper.addWnemgrBusClassMapping(subFunc);
        this.neid = neID;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList<String> portList = new ArrayList<String>();
        portList.add("2");
        portList.add("4");
        this.operationList = PTPClockUtil.getQueryOutTimePortLinkOperation(this.neid, portList);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
            return this.outputData;
        }
        int result = this.sendMessage(this.neid, this.operationList);
        ArrayList<String> board_port_list = null;
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return this.outputData;
        }
        board_port_list = PTPClockUtil.getOuterTimeResList(this.neid, this.operationList, this.subfunc);
        this.operationList = this.getOperation(this.neid, board_port_list);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
            return this.outputData;
        }
        result = this.sendMessage(this.neid, this.operationList);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return this.outputData;
        }
        this.handleMessage(this.neid, this.operationList, this.subfunc, this.getFilterErrorCodeList());
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        RowParams row = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            int slotid;
            String subrack;
            row = rows[i];
            if (row.getRowErrorsCount() > 0 || (subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)(slotid = Integer.parseInt(row.getParam("slotid").getValue())))).equals("")) continue;
            row.addParam("subrack", subrack);
        }
    }

    public ArrayList getOperation(int neid, ArrayList<String> board_port_list) {
        String opertionStr = "NSCMD_CFG_GET_PTPEXTTIMEINTERFACEPARA";
        return PTPClockUtil.getOuterTimeOperation(neid, opertionStr, board_port_list);
    }
}

