/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock.jni;

import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nemgr.marine.clock.TEClockSource;
import com.huawei.nglct.nemgr.marine.clock.jni.TEFiberEnd;
import com.huawei.nglct.nemgr.marine.clock.jni.TEGetOtherFiberEnd;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class TEGetOtherFiberEndAdapter {
    private TEGetOtherFiberEndAdapter() {
    }

    public static TEErrInfoReturn getOtherEnd(List<TEClockSource> clockSourceList) {
        TEClockSource clocksource = null;
        TEClockSource[] clocksourceArr = new TEClockSource[clockSourceList.size()];
        int len = clockSourceList.size();
        for (int index = 0; index < len; ++index) {
            clocksourceArr[index] = clocksource = clockSourceList.get(index);
        }
        return TEGetOtherFiberEndAdapter.getOtherEnd(clocksourceArr);
    }

    public static TEErrInfoReturn getOtherEnd(TEClockSource[] clocksourceArr) {
        TEErrInfoReturn errInfoRet = null;
        List<TEFiberEnd> currEndList = TEGetOtherFiberEndAdapter.consturctCurrEndList(clocksourceArr);
        HashMap<TEFiberEnd, TEFiberEnd> endMap = new HashMap<TEFiberEnd, TEFiberEnd>();
        errInfoRet = TEGetOtherFiberEnd.getOtherEnd(currEndList, endMap);
        if (endMap.isEmpty()) {
            return errInfoRet;
        }
        TEFiberEnd otherEnd = null;
        int len = currEndList.size();
        for (int i = 0; i < len; ++i) {
            otherEnd = (TEFiberEnd)endMap.get(currEndList.get(i));
            if (null != otherEnd) {
                clocksourceArr[i].setOtherFiberEnd(otherEnd.toClientString());
                continue;
            }
            clocksourceArr[i].setOtherFiberEnd("/");
        }
        return errInfoRet;
    }

    private static List<TEFiberEnd> consturctCurrEndList(TEClockSource[] clocksourceArr) {
        ArrayList<TEFiberEnd> currEndList = new ArrayList<TEFiberEnd>();
        for (TEClockSource clock : clocksourceArr) {
            currEndList.add(TEGetOtherFiberEndAdapter.constructFiberEnd(clock));
        }
        return currEndList;
    }

    private static TEFiberEnd constructFiberEnd(TEClockSource clock) {
        TEFiberEnd fiberEnd = new TEFiberEnd();
        int neID = clock.getNeID();
        int slotID = clock.getSlotID();
        int portID = TEQueryPortForDataMgr.getAbstractPortID((int)clock.getNeID(), (int)clock.getPortID());
        int subrackID = TEBoardUtil.getSubrackIDFromSlot((int)neID, (int)slotID);
        fiberEnd.setBoardName("");
        fiberEnd.setNeid(neID);
        fiberEnd.setNeName("");
        fiberEnd.setPortID(portID);
        fiberEnd.setPortName("");
        fiberEnd.setSlotID(slotID);
        fiberEnd.setSubrackID(subrackID);
        fiberEnd.setSubrackName("");
        return fiberEnd;
    }

    public static List<RowErrors> contructErrorMessage(int neid, TEErrInfoReturn errInfoRet) {
        ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
        for (TEErrInfo errInfo : errInfoRet.getErrList()) {
            ErrorMessage newErrMsg = TEErrorResourceUtil.getErrorMessage((int)errInfo.getErrorCode());
            Param param = new Param();
            param.setName("neid");
            param.setValue(String.valueOf(neid));
            RowErrors rowError = new RowErrors();
            rowError.addParam(param);
            rowError.setErrorMessage(newErrMsg);
            rowErrorList.add(rowError);
        }
        return rowErrorList;
    }
}

