/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock.jni;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnErrInfo;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnErrInfoList;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnPortIndex;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnPortIndexList;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIBasicNameInfo;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIBasicNameInfoList;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIFiberInfo;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIFiberInfoList;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIGetBasicNameInfoReq;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIGetBasicNameInfoRsp;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIGetFiberOppositeReq;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIGetFiberOppositeRsp;
import com.huawei.nglct.nemgr.marine.clock.jni.TEFiberEnd;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEGetOtherFiberEnd {
    private static final int NE_SHELF_SLOT_PORT_NAME = 15;
    private static final int IS_FIBER_SRC = 1;
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEGetOtherFiberEnd() {
    }

    public static TEErrInfoReturn getOtherEnd(List<TEFiberEnd> currEndList, Map<TEFiberEnd, TEFiberEnd> endMap) {
        TEErrInfoReturn errInfoRet = new TEErrInfoReturn();
        if (currEndList.isEmpty()) {
            return errInfoRet;
        }
        AsnJNIGetFiberOppositeReq req = new AsnJNIGetFiberOppositeReq();
        AsnJNIGetFiberOppositeRsp rsp = new AsnJNIGetFiberOppositeRsp();
        req.curFiberEndList = TEGetOtherFiberEnd.data2Asn(currEndList);
        req.isSrc = 1;
        int retCode = 0;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            retCode = (int)TEJNIFacadeUtil.sendJNIMessage((int)202, (FStruct)req, (FStruct)rsp);
        }
        if (0 != retCode) {
            e2eLogger.error("get other fiber end fail! retCode->" + retCode);
            TEGetOtherFiberEnd.constructInvalidFiberInfo(currEndList, endMap);
            errInfoRet.setResult(2);
            errInfoRet.addErrInfo(TEGetOtherFiberEnd.consturctErrInfo(retCode));
            errInfoRet.addErrInfo(TEGetOtherFiberEnd.consturctErrInfo(rsp.result.errList));
            return errInfoRet;
        }
        TEGetOtherFiberEnd.constructValidFiberInfo(currEndList, endMap, rsp.fiberInfoList, errInfoRet);
        return errInfoRet;
    }

    private static void constructValidFiberInfo(List<TEFiberEnd> currEndList, Map<TEFiberEnd, TEFiberEnd> endMap, AsnJNIFiberInfoList rspFiberInfoList, TEErrInfoReturn errInfoRet) {
        TEFiberEnd otherFiberEnd;
        AsnJNIFiberInfo asnFiberInfo = null;
        HashSet<TEFiberEnd> nameInfoSet = new HashSet<TEFiberEnd>();
        TEGetOtherFiberEnd.getOtherFiberEndNameInfo(rspFiberInfoList, nameInfoSet, errInfoRet);
        int len = rspFiberInfoList.size();
        for (int i = 0; i < len; ++i) {
            asnFiberInfo = (AsnJNIFiberInfo)rspFiberInfoList.get(i);
            TEFiberEnd currFiberEnd = TEGetOtherFiberEnd.asn2Data(asnFiberInfo.curFiberEnd, null);
            otherFiberEnd = TEGetOtherFiberEnd.asn2Data(asnFiberInfo.otherFiberEnd, nameInfoSet);
            endMap.put(currFiberEnd, otherFiberEnd);
        }
        for (TEFiberEnd fiberEnd : currEndList) {
            otherFiberEnd = endMap.get(fiberEnd);
            if (null != otherFiberEnd) continue;
            endMap.put(fiberEnd, TEGetOtherFiberEnd.constructNullEnd());
        }
    }

    private static void getOtherFiberEndNameInfo(AsnJNIFiberInfoList rspFiberInfoList, Set<TEFiberEnd> fiberEndSet, TEErrInfoReturn errInfoRet) {
        AsnJNIGetBasicNameInfoReq aReq = new AsnJNIGetBasicNameInfoReq();
        AsnJNIGetBasicNameInfoRsp aRsp = new AsnJNIGetBasicNameInfoRsp();
        if (rspFiberInfoList.isEmpty()) {
            return;
        }
        aReq.flag = 15;
        AsnJNIFiberInfo asnFiberInfo = null;
        int len = rspFiberInfoList.size();
        for (int i = 0; i < len; ++i) {
            asnFiberInfo = (AsnJNIFiberInfo)rspFiberInfoList.get(i);
            aReq.portIndexList.add((Object)asnFiberInfo.otherFiberEnd);
        }
        int retCode = (int)TEJNIFacadeUtil.sendJNIMessage((int)201, (FStruct)aReq, (FStruct)aRsp);
        if (0 != retCode) {
            e2eLogger.error("get basic name info fail! retCode->" + retCode);
            errInfoRet.addErrInfo(TEGetOtherFiberEnd.consturctErrInfo(retCode));
            errInfoRet.addErrInfo(TEGetOtherFiberEnd.consturctErrInfo(aRsp.result.errList));
            errInfoRet.setResult(1);
        }
        TEGetOtherFiberEnd.constructFiberEndSet(aRsp.nameInfoList, fiberEndSet);
    }

    private static void constructFiberEndSet(AsnJNIBasicNameInfoList fiberInfoList, Set<TEFiberEnd> fiberEndSet) {
        int len = fiberInfoList.size();
        for (int i = 0; i < len; ++i) {
            fiberEndSet.add(TEGetOtherFiberEnd.constructFiberEnd((AsnJNIBasicNameInfo)fiberInfoList.get(i)));
        }
    }

    private static TEFiberEnd constructFiberEnd(AsnJNIBasicNameInfo asnNameInfo) {
        TEFiberEnd fiberEnd = new TEFiberEnd();
        if (0 == asnNameInfo.portIndex.neID) {
            fiberEnd.setNeid(0);
            fiberEnd.setSubrackID(0);
            fiberEnd.setSlotID(0);
            fiberEnd.setPortID(0);
            return fiberEnd;
        }
        fiberEnd.setNeid(asnNameInfo.portIndex.neID);
        fiberEnd.setSubrackID(TEBoardUtil.getSubrackIDFromSlot((int)asnNameInfo.portIndex.neID, (int)asnNameInfo.portIndex.slotID));
        fiberEnd.setSlotID(TEBoardUtil.bigSlotToSmall((int)asnNameInfo.portIndex.slotID));
        fiberEnd.setPortID(asnNameInfo.portIndex.portID);
        fiberEnd.setNeName(new String(asnNameInfo.neName));
        fiberEnd.setSubrackName(new String(asnNameInfo.shelfName));
        fiberEnd.setBoardName(new String(asnNameInfo.boardName));
        fiberEnd.setPortName(new String(asnNameInfo.portName));
        return fiberEnd;
    }

    private static void constructInvalidFiberInfo(List<TEFiberEnd> currEndList, Map<TEFiberEnd, TEFiberEnd> endMap) {
        for (TEFiberEnd fiberEnd : currEndList) {
            TEFiberEnd otherFiberEnd = endMap.get(fiberEnd);
            if (null != otherFiberEnd) continue;
            endMap.put(fiberEnd, TEGetOtherFiberEnd.constructInvalidEnd());
        }
    }

    private static TEFiberEnd asn2Data(AsnPortIndex asnFiberEnd, Set<TEFiberEnd> nameInfoSet) {
        TEFiberEnd fiberEnd = new TEFiberEnd();
        if (0 == asnFiberEnd.neID) {
            fiberEnd.setNeid(0);
            fiberEnd.setSubrackID(0);
            fiberEnd.setSlotID(0);
            fiberEnd.setPortID(0);
            return fiberEnd;
        }
        fiberEnd.setNeid(asnFiberEnd.neID);
        fiberEnd.setPortID(asnFiberEnd.portID);
        fiberEnd.setSubrackID(TEBoardUtil.getSubrackIDFromSlot((int)asnFiberEnd.neID, (int)asnFiberEnd.slotID));
        fiberEnd.setSlotID(TEBoardUtil.bigSlotToSmall((int)asnFiberEnd.slotID));
        if (null != nameInfoSet) {
            TEFiberEnd tempFiberEnd2 = null;
            for (TEFiberEnd tempFiberEnd2 : nameInfoSet) {
                if (!tempFiberEnd2.equals(fiberEnd)) continue;
                fiberEnd.setNeName(tempFiberEnd2.getNeName());
                fiberEnd.setSubrackName(tempFiberEnd2.getSubrackName());
                fiberEnd.setBoardName(tempFiberEnd2.getBoardName());
                fiberEnd.setPortName(tempFiberEnd2.getPortName());
                break;
            }
        }
        return fiberEnd;
    }

    private static TEFiberEnd constructNullEnd() {
        TEFiberEnd fiberEnd = new TEFiberEnd();
        fiberEnd.setBoardName("");
        fiberEnd.setNeid(0);
        fiberEnd.setNeName("");
        fiberEnd.setPortID(0);
        fiberEnd.setPortName("");
        fiberEnd.setSlotID(0);
        fiberEnd.setSubrackID(0);
        fiberEnd.setSubrackName("");
        return fiberEnd;
    }

    private static TEFiberEnd constructInvalidEnd() {
        TEFiberEnd fiberEnd = new TEFiberEnd();
        fiberEnd.setBoardName("");
        fiberEnd.setNeid(-1);
        fiberEnd.setNeName("");
        fiberEnd.setPortID(-1);
        fiberEnd.setPortName("");
        fiberEnd.setSlotID(-1);
        fiberEnd.setSubrackID(-1);
        fiberEnd.setSubrackName("");
        return fiberEnd;
    }

    private static List<TEErrInfo> consturctErrInfo(AsnErrInfoList errList) {
        ArrayList<TEErrInfo> errInfoList = new ArrayList<TEErrInfo>();
        int len = errList.size();
        for (int i = 0; i < len; ++i) {
            errInfoList.add(TEGetOtherFiberEnd.constructErrInfo((AsnErrInfo)errList.get(i)));
        }
        return errInfoList;
    }

    private static TEErrInfo constructErrInfo(AsnErrInfo asnErrInfo) {
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setErrorCode(asnErrInfo.errCode);
        return errInfo;
    }

    private static TEErrInfo consturctErrInfo(int retCode) {
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(new int[0]);
        errInfo.setErrorCode(retCode);
        return errInfo;
    }

    private static AsnPortIndexList data2Asn(List<TEFiberEnd> currEndList) {
        AsnPortIndexList asnList = new AsnPortIndexList();
        for (TEFiberEnd fiberEnd : currEndList) {
            asnList.add((Object)TEGetOtherFiberEnd.data2Asn(fiberEnd));
        }
        return asnList;
    }

    private static AsnPortIndex data2Asn(TEFiberEnd fiberEnd) {
        AsnPortIndex asnEnd = new AsnPortIndex();
        asnEnd.neID = fiberEnd.getNeid();
        asnEnd.portID = fiberEnd.getPortID();
        asnEnd.slotID = TEBoardUtil.neToSlotIDNM((int)fiberEnd.getSubrackID(), (int)fiberEnd.getSlotID());
        return asnEnd;
    }
}

