/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.marine.clock.ClockUtil;
import com.huawei.nglct.nemgr.marine.clock.TEClockSource;
import com.huawei.nglct.nemgr.marine.clock.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.marine.clock.TEUsableBoardPortResource;
import com.huawei.nglct.nemgr.marine.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQuerySSMCtrlBean
extends TENEClockWriteLogBean {
    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neID;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList clockSourceList = this.getClockSourceList();
        if (clockSourceList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        this.handleClockIdData(clockSourceList);
        ArrayList newOperationList = this.get2ndOperationList();
        if (null == newOperationList || newOperationList.size() == 0) {
            return this.outputData;
        }
        int result = this.sendMessage(this.neid, newOperationList);
        if (result == 0) {
            this.handleMessage(newOperationList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private ArrayList getClockSourceList() {
        ArrayList<TEClockSource> clockSourceList = new ArrayList<TEClockSource>();
        ArrayList operationList = ClockUtil.getOutClockSourceOperation(this.neid);
        int result = this.sendMessage(this.neid, operationList);
        if (result == 0) {
            String outerSource = null;
            ArrayList outerClockSourceList = ClockUtil.getOuterClockSourceList(this.neid, operationList);
            for (int i = outerClockSourceList.size() - 1; i >= 0; --i) {
                outerSource = (String)outerClockSourceList.get(i);
                clockSourceList.add(ClockUtil.hexclockID2TEClockSource(this.neid, outerSource));
            }
        }
        clockSourceList.addAll(TEUsableBoardPortResource.getClockSourceResList(this.neid));
        return clockSourceList;
    }

    private void handleClockIdData(ArrayList clockSourceList) {
        BussinessParams businessParam = this.outputData.getBussinessParams();
        TEErrInfoReturn errInfoRet = TEGetOtherFiberEndAdapter.getOtherEnd(clockSourceList);
        int len = clockSourceList.size();
        for (int i = 0; i < len; ++i) {
            RowParams rtnRowParams = new RowParams();
            TEClockSource res = (TEClockSource)clockSourceList.get(i);
            rtnRowParams.addParam("clockid", res.getSourceIDHexStr());
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)res.getSlotID());
            if (res.getSlotID() > 0 && !subrackname.equals("") && res.getOuterSourceNo().equals("-1")) {
                rtnRowParams.addParam("clockname", subrackname + "-" + ClockUtil.getClockName(res, this.neid));
            } else {
                rtnRowParams.addParam("clockname", ClockUtil.getClockName(res, this.neid));
            }
            rtnRowParams.addParam("otherfiberend", res.getOtherFiberEnd());
            rtnRowParams.addParam("ssmoutstate", "1");
            rtnRowParams.addParam("subrackname", subrackname);
            businessParam.addRowParams(rtnRowParams);
        }
        this.outputData.setBussinessParams(businessParam);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        ErrorMessage errMsg = this.outputData.getErrorMessage();
        if (0 != errInfoRet.getResult()) {
            errMsg.setErrorcode(String.valueOf(1));
            RowParams rowparams = new RowParams();
            ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
            rowErrorList.addAll(TEGetOtherFiberEndAdapter.contructErrorMessage(this.neid, errInfoRet));
            for (RowErrors rowError : rowErrorList) {
                rowparams.addRowErrors(rowError);
            }
            this.outputData.getBussinessParams().addRowParams(0, rowparams);
        }
    }

    private ArrayList get2ndOperationList() {
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_S1EXPORT_MODE");
            Input input = oper.getInput();
            input.setPartValue("clockslotno", "65535");
            operationList.add(oper);
            return operationList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void handleMessage(ArrayList operList) {
        ArrayList<String> clockidArr = this.getUnenableClockidArr(operList);
        if (clockidArr.size() <= 0) {
            return;
        }
        BussinessParams businessParams = this.outputData.getBussinessParams();
        int len = businessParams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = businessParams.getRowParams(i);
            String clockIdHex = row.getParam("clockid").getValue();
            if (!clockidArr.contains(clockIdHex.toLowerCase())) continue;
            row.getParam("ssmoutstate").setValue("0");
        }
    }

    private ArrayList<String> getUnenableClockidArr(ArrayList operationList) {
        ArrayList<String> clockidArr = new ArrayList<String>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation opr = (Operation)operationList.get(i);
            Output[] outputs = opr.getOutput();
            Output output2 = null;
            for (Output output2 : outputs) {
                if (!output2.getFault(0).getCode().equals("0")) continue;
                String clockid = output2.getPartValue("clockid");
                clockidArr.add(clockid.toLowerCase());
            }
        }
        return clockidArr;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(38662);
        return filterErrorCodeList;
    }
}

