/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nemgr.marine.clock.ClockUtil;
import com.huawei.nglct.nemgr.marine.clock.TEClockSource;
import com.huawei.nglct.nemgr.marine.clock.TENEClockWriteLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryClockSwitchInfoTab
extends TENEClockWriteLogBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 0) {
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_SYN_CLASS_EX");
            Input input = oper.getInput();
            input.setPartValue("clockslotno", operation.getInput().getPartValue("clockslotno"));
            ArrayList<Operation> operList = new ArrayList<Operation>();
            operList.add(oper);
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operList, 10, subfunc);
            ArrayList<String> clockidArr = new ArrayList<String>();
            if (0 == result.retCode) {
                oper = (Operation)operList.get(0);
                operList.clear();
                output = oper.getOutput()[0];
                int clocknum = Integer.parseInt(output.getPartValue("clocknum"));
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    int clockidlength = 8;
                    String clockIdHexStr = output.getPartValue("clockdata").substring(index, index + clockidlength);
                    clockidArr.add(clockIdHexStr);
                    index += clockidlength;
                }
            }
            if (this.outputData.getBussinessParams().getRowParamsCount() > 0) {
                this.handleOutput(clockidArr);
            }
        }
    }

    private void handleOutput(ArrayList clockidArr) {
        RowParams[] rowdatas = this.outputData.getBussinessParams().getRowParams();
        for (int len = rowdatas.length - 1; len >= 0; --len) {
            if (rowdatas[len].getRowErrorsCount() > 0) continue;
            Param para = rowdatas[len].getParam("clockid");
            String clockidStr = para.getValue();
            boolean isExist = this.isExist(clockidArr, clockidStr);
            if (!isExist) {
                this.outputData.getBussinessParams().removeRowParams(rowdatas[len]);
                continue;
            }
            TEClockSource res = ClockUtil.hexclockID2TEClockSource(this.neid, clockidStr);
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)res.getSlotID());
            if (res.getSlotID() > 0 && !subrackname.equals("") && res.getOuterSourceNo().equals("-1")) {
                rowdatas[len].addParam("clockname", subrackname + "-" + ClockUtil.getClockName(res, this.neid));
            } else {
                rowdatas[len].addParam("clockname", ClockUtil.getClockName(res, this.neid));
            }
            rowdatas[len].addParam("subrackname", subrackname);
            para = rowdatas[len].getParam("clockstate");
            if (!para.getValue().equals("0") && !para.getValue().equals("1")) {
                para.setValue("0");
            }
            if ((para = rowdatas[len].getParam("lockstate")).getValue().equals("0") || para.getValue().equals("1")) continue;
            para.setValue("1");
        }
    }

    private boolean isExist(ArrayList clockidArr, String clockidStr) {
        boolean isExist = false;
        int lenArr = clockidArr.size();
        for (int i = 0; i < lenArr; ++i) {
            if (!clockidStr.equals((String)clockidArr.get(i))) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeLis = new ArrayList<Integer>();
        filterErrorCodeLis.add(38662);
        return filterErrorCodeLis;
    }
}

