/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.marine.clock.ClockUtil;
import com.huawei.nglct.nemgr.marine.clock.TEClockSource;
import com.huawei.nglct.nemgr.marine.clock.TENEClockWriteLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;

public class TEQueryClockQuality
extends TENEClockWriteLogBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams row = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            row = this.outputData.getBussinessParams().getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            String clockIdHex = row.getParam("clockid").getValue();
            String clockQuality = row.getParam("clockquality").getValue();
            if (clockQuality.equals("") || clockQuality.equals("-1")) {
                row.getParam("clockquality").setValue("16");
            } else {
                int quality = Integer.parseInt(clockQuality);
                row.getParam("clockquality").setValue(String.valueOf(quality &= 0xF));
                if (quality != 0 && quality != 2 && quality != 4 && quality != 8 && quality != 11 && quality != 15) {
                    row.getParam("clockquality").setValue("16");
                }
            }
            TEClockSource res = ClockUtil.hexclockID2TEClockSource(neid, clockIdHex);
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)res.getSlotID());
            if (!subrack.equals("") && res.getOuterSourceNo().equals("-1")) {
                row.addParam("clockname", subrack + "-" + ClockUtil.getClockName(res, neid));
            } else {
                row.addParam("clockname", ClockUtil.getClockName(res));
            }
            row.addParam("clockSourceType", "" + res.getClockSourceType());
            row.addParam("subrackname", subrack);
        }
    }
}

