/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.marine.clock.ClockUtil;
import com.huawei.nglct.nemgr.marine.clock.TEClockSource;
import com.huawei.nglct.nemgr.marine.clock.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.marine.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;

public class TEQueryClockPriority
extends TENEClockWriteLogBean {
    int clocknum = 0;
    String[] clockidstr = null;
    ArrayList operList2nd = null;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            return TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.operList2nd = new ArrayList();
                result = this.handleFirstQueryBack(neid, this.operationList, subFunc);
            }
            if (result != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                return this.outputData;
            }
            HashMap<String, String[]> returnData2nd = new HashMap<String, String[]>();
            if (null != this.operList2nd && this.operList2nd.size() > 0) {
                result = this.sendMessage(neid, this.operList2nd);
                result = this.handle2ndQueryBack(this.operList2nd, returnData2nd, result);
            }
            this.outputData = this.constructOutputData(neid, returnData2nd, result);
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private int handleFirstQueryBack(int neid, ArrayList operationList, SubFunc subfunc) {
        int result = 0;
        Operation operation = null;
        int len = operationList.size();
        for (int index = 0; index < len; ++index) {
            operation = (Operation)operationList.get(index);
            Output[] outputs = operation.getOutput();
            Output output = null;
            int listlen = operation.getOutputCount();
            for (int i = 0; i < listlen; ++i) {
                output = outputs[i];
                result = Integer.parseInt(output.getFault(0).getCode());
                if (result != 0) {
                    return result;
                }
                for (Part part : output.getPart()) {
                    String name = part.getName();
                    String value = part.getValue();
                    this.getClockidArr(name, value, this.operList2nd);
                }
            }
        }
        return result;
    }

    private void getClockidArr(String name, String value, ArrayList operList) {
        if (name.equalsIgnoreCase("clocknum") && value != null) {
            this.clocknum = Integer.valueOf(value);
        } else if (name.equalsIgnoreCase("clockdata") && value != null) {
            this.clockidstr = new String[this.clocknum];
            int from = 0;
            for (int j = 0; j < this.clocknum; ++j) {
                int clockidlength = 8;
                this.clockidstr[j] = value.substring(from, from + clockidlength);
                from += clockidlength;
                this.get2ndOperation(this.clockidstr[j], operList);
            }
        }
    }

    private void get2ndOperation(String clockIDStr, ArrayList operList) {
        String subStr = clockIDStr.substring(2, clockIDStr.length());
        if (subStr.equalsIgnoreCase("f00001") || subStr.equalsIgnoreCase("f00002")) {
            Operation oper = null;
            Input input = null;
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_EXTIN_MODE");
            input = oper.getInput();
            input.setPartValue("clockslotno", "65535");
            input.setPartValue("clockid", clockIDStr);
            operList.add(oper.clone());
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_EXTIN_S1ASLOT");
            input = oper.getInput();
            input.setPartValue("clockslotno", "65535");
            input.setPartValue("clockid", clockIDStr);
            operList.add(oper.clone());
        }
    }

    private Datainterface constructOutputData(int neID, HashMap<String, String[]> returnData2nd, int result) {
        Datainterface outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        String hexclockIDStr = null;
        TEClockSource clocksource = null;
        TEClockSource[] clocksourceArr = new TEClockSource[this.clocknum];
        for (int index = 0; index < this.clocknum; ++index) {
            hexclockIDStr = this.clockidstr[index];
            clocksourceArr[index] = clocksource = ClockUtil.hexclockID2TEClockSource(neID, hexclockIDStr);
        }
        TEErrInfoReturn errInfoRet = TEGetOtherFiberEndAdapter.getOtherEnd(clocksourceArr);
        for (int index = 0; index < this.clocknum; ++index) {
            String s1byte = "5";
            String outclockmode = "2";
            hexclockIDStr = this.clockidstr[index];
            clocksource = clocksourceArr[index];
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("slotid", "" + clocksource.getSlotID());
            rtnRowParams.addParam("clockSourceType", "" + clocksource.getClockSourceType());
            rtnRowParams.addParam("branchboard", "-");
            rtnRowParams.addParam("clockidhex", hexclockIDStr.toLowerCase());
            rtnRowParams.addParam("clockid", "" + Integer.parseInt(hexclockIDStr, 16));
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neID, (int)clocksource.getSlotID());
            if (!subrack.equals("") && clocksource.getOuterSourceNo().equals("-1")) {
                rtnRowParams.addParam("clockname", subrack + "-" + ClockUtil.getClockName(clocksource, neID));
            } else {
                rtnRowParams.addParam("clockname", ClockUtil.getClockName(clocksource, neID));
            }
            rtnRowParams.addParam("subrackname", subrack);
            rtnRowParams.addParam("otherfiberend", clocksource.getOtherFiberEnd());
            if (clocksource.getClockSourceType() == 2 && null != returnData2nd && returnData2nd.size() > 0 && returnData2nd.containsKey(hexclockIDStr.toLowerCase())) {
                String[] arr = returnData2nd.get(hexclockIDStr.toLowerCase());
                outclockmode = arr[0];
                s1byte = arr[1];
            }
            s1byte = null == s1byte ? "5" : s1byte;
            rtnRowParams.addParam("s1byte", s1byte);
            outclockmode = null == outclockmode ? "2" : outclockmode;
            rtnRowParams.addParam("outclockmode", outclockmode);
            bussinessParams.addRowParams(rtnRowParams);
        }
        Datainterface outputDataTemp = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operList2nd, (ArrayList)this.getFilterErrorCodeList());
        if (null != outputDataTemp && (result = Integer.valueOf(outputDataTemp.getErrorMessage().getErrorcode()).intValue()) != 0) {
            int index = outputDataTemp.getBussinessParams().getRowParamsCount() - 1;
            bussinessParams.addRowParams(outputDataTemp.getBussinessParams().getRowParams(index));
        }
        outputData.setBussinessParams(bussinessParams);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)result));
        ErrorMessage errMsg = outputData.getErrorMessage();
        if (0 != errInfoRet.getResult()) {
            if ("!0".equals(errMsg.getErrorcode())) {
                errMsg.setErrorcode(String.valueOf(1));
            }
            RowParams rowparams = outputData.getBussinessParams().getRowParams(0);
            ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
            rowErrorList.addAll(TEGetOtherFiberEndAdapter.contructErrorMessage(this.neid, errInfoRet));
            for (RowErrors rowError : rowErrorList) {
                rowparams.addRowErrors(rowError);
            }
        }
        return outputData;
    }

    private int handle2ndQueryBack(ArrayList operList2nd, HashMap<String, String[]> returnMap, int retCode) {
        if (retCode != 0) {
            return retCode;
        }
        int len = operList2nd.size();
        for (int i = 0; i < len; ++i) {
            Operation opr = (Operation)operList2nd.get(i);
            Output[] outputArr = opr.getOutput();
            String partName = "outclockmode";
            int index = 0;
            if (opr.getName().equalsIgnoreCase("NSCMD_CFG_GET_EXTIN_S1ASLOT")) {
                partName = "s1byte";
                index = 1;
            }
            for (Output output : outputArr) {
                retCode = Integer.valueOf(output.getFault()[0].getCode());
                if (retCode != 0) {
                    return retCode;
                }
                this.handleBack(returnMap, output, partName, index);
            }
        }
        return retCode;
    }

    private void handleBack(HashMap<String, String[]> returnMap, Output output, String partName, int index) {
        String clockIDStr = "";
        clockIDStr = output.getPartValue("clockid").toLowerCase();
        if (returnMap.containsKey(clockIDStr)) {
            returnMap.get((Object)clockIDStr)[index] = output.getPartValue(partName);
        } else {
            String[] strArray = new String[2];
            strArray[index] = output.getPartValue(partName);
            returnMap.put(clockIDStr, strArray);
        }
    }
}

