/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.marine.clock.ClockUtil;
import com.huawei.nglct.nemgr.marine.clock.TEClockSource;
import com.huawei.nglct.nemgr.marine.clock.TEUsableBoardPortResource;
import com.huawei.nglct.nemgr.marine.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryClockIDEnable
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neID;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        int result = -100;
        ArrayList clockSourceList = TEUsableBoardPortResource.getClockSourceResList(neID);
        if (null == clockSourceList || clockSourceList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
            return this.outputData;
        }
        ArrayList newOperationList = this.get2ndOperationList();
        if (null == newOperationList || newOperationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
            return this.outputData;
        }
        result = this.sendMessage(this.neid, newOperationList);
        if (result == 0) {
            this.handleMessage(this.neid, newOperationList, clockSourceList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private ArrayList get2ndOperationList() {
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_CLKID_OUT");
            Input input = oper.getInput();
            input.setPartValue("clockslotno", "65535");
            operationList.add(oper);
            return operationList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void handleMessage(int neid, ArrayList operList, ArrayList clockSourceList) {
        String clockidhex;
        RowParams row;
        TEClockSource res;
        int i;
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)this.subfunc, (ArrayList)operList, (ArrayList)this.getFilterErrorCodeList());
        ArrayList<String> clockidArr = new ArrayList<String>();
        this.getUnenableClockidArr(operList, clockidArr);
        TEErrInfoReturn errInfoRet1 = TEGetOtherFiberEndAdapter.getOtherEnd(clockSourceList);
        RowParams errorRowParams = null;
        int num = this.outputData.getBussinessParams().getRowParamsCount();
        if (num > 0 && !this.outputData.getErrorMessage().getErrorcode().equalsIgnoreCase("0")) {
            errorRowParams = this.outputData.getBussinessParams().getRowParams(num - 1);
            this.outputData.getBussinessParams().clearRowParams();
        }
        TEErrInfoReturn errInfoRet2 = TEGetOtherFiberEndAdapter.getOtherEnd(clockSourceList);
        for (i = 0; i < clockSourceList.size(); ++i) {
            res = (TEClockSource)clockSourceList.get(i);
            row = new RowParams();
            clockidhex = res.getSourceIDHexStr();
            row.addParam("clockidhex", clockidhex);
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)res.getSlotID());
            if (res.getSlotID() > 0 && !subrackname.equals("") && res.getOuterSourceNo().equals("-1")) {
                row.addParam("clockname", subrackname + "-" + ClockUtil.getClockName(res, neid));
            } else {
                row.addParam("clockname", ClockUtil.getClockName(res, neid));
            }
            row.addParam("subrackname", subrackname);
            row.addParam("otherfiberend", res.getOtherFiberEnd());
            boolean flag = true;
            for (int j = clockidArr.size() - 1; j >= 0; --j) {
                if (!clockidArr.get(j).equalsIgnoreCase(clockidhex)) continue;
                row.addParam("clockidenable", "0");
                clockidArr.remove(j);
                flag = false;
                break;
            }
            if (flag) {
                row.addParam("clockidenable", "1");
            }
            this.outputData.getBussinessParams().addRowParams(row);
        }
        for (i = clockidArr.size() - 1; i >= 0; --i) {
            res = ClockUtil.hexclockID2TEClockSource(neid, clockidArr.get(i));
            row = new RowParams();
            clockidhex = res.getSourceIDHexStr();
            row.addParam("clockidhex", clockidhex);
            row.addParam("clockname", ClockUtil.getClockName(res));
            row.addParam("otherfiberend", res.getOtherFiberEnd());
            row.addParam("clockidenable", "0");
            this.outputData.getBussinessParams().addRowParams(row);
        }
        if (null != errorRowParams) {
            this.outputData.getBussinessParams().addRowParams(errorRowParams);
        }
        ErrorMessage errMsg = this.outputData.getErrorMessage();
        if (0 != errInfoRet1.getResult() || 0 != errInfoRet2.getResult()) {
            errMsg.setErrorcode(String.valueOf(1));
            ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
            rowErrorList.addAll(TEGetOtherFiberEndAdapter.contructErrorMessage(neid, errInfoRet1));
            rowErrorList.addAll(TEGetOtherFiberEndAdapter.contructErrorMessage(neid, errInfoRet2));
            RowParams rowparams = new RowParams();
            for (RowErrors rowError : rowErrorList) {
                rowparams.addRowErrors(rowError);
            }
            this.outputData.getBussinessParams().addRowParams(0, rowparams);
        }
    }

    private void getUnenableClockidArr(ArrayList operationList, ArrayList<String> clockidArr) {
        int clocknum = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation opr = (Operation)operationList.get(i);
            Output[] outputs = opr.getOutput();
            Output output2 = null;
            for (Output output2 : outputs) {
                if (!output2.getFault(0).getCode().equals("0")) continue;
                String clockdata = output2.getPartValue("clockdata");
                clocknum = Integer.parseInt(output2.getPartValue("clocknum"));
                int from = 0;
                for (int j = 0; j < clocknum; ++j) {
                    int clockidlength = 8;
                    clockidArr.add(clockdata.substring(from, from + clockidlength));
                    from += clockidlength;
                }
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(38662);
        return filterErrorCodeList;
    }
}

