/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.clock.TENEClockWriteLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class TEQueryBadDetectBean
extends TENEClockWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        RowParams row = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            int slotid;
            String subrack;
            row = rows[i];
            if (row.getRowErrorsCount() > 0 || (subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)(slotid = Integer.parseInt(row.getParam("slotid").getValue())))).equals("")) continue;
            row.addParam("subrack", subrack);
        }
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_BAD_DETECT");
            Input input = oper.getInput();
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            Vector boardList = ne.getBoardList();
            if (null == boardList || boardList.size() == 0) {
                return null;
            }
            Collections.sort(boardList);
            ArrayList<Object> templist = new ArrayList<Object>();
            int size = boardList.size();
            for (int i = 0; i < size; ++i) {
                TEBoard board = (TEBoard)boardList.get(i);
                int boardType = board.getBoardType();
                if (boardType != 1544 && boardType != 1571 && boardType != 2058) continue;
                input.setPartValue("slotid", "" + board.getSlotID());
                templist.add(oper.clone());
            }
            return templist;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }
}

