/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.marine.clock.ClockUtil;
import com.huawei.nglct.nemgr.marine.clock.TEClockSource;
import com.huawei.nglct.nemgr.marine.clock.TENEClockWriteLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQuery2mClockPriority
extends TENEClockWriteLogBean {
    int clockSlotID = 0;
    int clock2mID = 0;
    String clock2mIDHexStr = "";
    String clock2mFlag = "1";
    int clocknum = 0;
    String[] clockidstr = null;
    ArrayList operList2nd = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.clock2mFlag = inputData.getBussinessParams().getRowParams(0).getParam("clock2mFlag").getValue();
        this.outputData = new Datainterface();
        this.operationList = this.getQuery2MPriorityOperationList();
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return this.outputData;
        }
        this.query2nd();
        return this.outputData;
    }

    private void query2nd() {
        this.operList2nd = this.getOperList2nd();
        if (null != this.operList2nd && this.operList2nd.size() > 0) {
            this.sendMessage(this.neid, this.operList2nd);
            this.outputData = this.constructOutputData(this.neid);
        } else {
            this.handleMessage(this.neid, this.operationList, this.subfunc);
        }
    }

    private ArrayList<Operation> getQuery2MPriorityOperationList() {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_2MPLL_CLASS_EX");
            Input input = oper.getInput();
            input.setPartValue("clockslotno", "65535");
            input.setPartValue("clock2mindex", this.clock2mFlag);
            operList.add(oper);
            return operList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return operList;
        }
    }

    private ArrayList getOperList2nd() {
        ArrayList<Object> operList = new ArrayList<Object>();
        try {
            Operation operation = null;
            Operation oper = null;
            Input input = null;
            int len = this.operationList.size();
            for (int index = 0; index < len; ++index) {
                operation = (Operation)this.operationList.get(index);
                Output[] outputs = operation.getOutput();
                Output output = null;
                int listlen = operation.getOutputCount();
                for (int i = 0; i < listlen; ++i) {
                    output = outputs[i];
                    if (!output.getFault(0).getCode().equals("0")) continue;
                    this.clocknum = Integer.parseInt(output.getPartValue("clocknum"));
                    String clockdata = output.getPartValue("clockdata");
                    this.clockidstr = new String[this.clocknum];
                    int from = 0;
                    for (int j = 0; j < this.clocknum; ++j) {
                        int clockidlength = 8;
                        this.clockidstr[j] = clockdata.substring(from, from + clockidlength);
                        from += clockidlength;
                    }
                }
            }
            if (this.clocknum > 0) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SYN_LOCK");
                input = oper.getInput();
                input.setPartValue("clockslotno", "65535");
                operList.add(oper.clone());
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PLLSYN_EXIST");
                input = oper.getInput();
                input.setPartValue("clockslotno", "65535");
                operList.add(oper.clone());
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_ALL_2MS1_EX2");
                input = oper.getInput();
                input.setPartValue("clockslotno", "65535");
                input.setPartValue("clock2mindex", this.clock2mFlag);
                operList.add(oper.clone());
            }
            return operList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return operList;
        }
    }

    private Datainterface constructOutputData(int neID) {
        Datainterface outputDataTemp;
        Datainterface outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        for (int index = 0; index < this.clocknum; ++index) {
            String hexclockIDStr = this.clockidstr[index];
            TEClockSource clocksource = ClockUtil.hexclockID2TEClockSource(neID, hexclockIDStr);
            RowParams row = new RowParams();
            row.addParam("slotid", "" + clocksource.getSlotID());
            row.addParam("clockSourceType", "" + clocksource.getClockSourceType());
            row.addParam("clockidhex", hexclockIDStr.toLowerCase());
            row.addParam("clockid", "" + Integer.parseInt(hexclockIDStr, 16));
            row.addParam("clockname", ClockUtil.getClockName(clocksource));
            row.addParam("lockstate", "2");
            row.addParam("clockstate", "2");
            row.addParam("s1byte", "16");
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)clocksource.getSlotID());
            row.addParam("subrackname", subrack);
            bussinessParams.addRowParams(row);
        }
        outputData.setBussinessParams(bussinessParams);
        int retcode = 0;
        if (this.clocknum > 0 && null != (outputDataTemp = this.handleOutput(outputData)) && (retcode = Integer.valueOf(outputDataTemp.getErrorMessage().getErrorcode()).intValue()) != 0) {
            int index = outputDataTemp.getBussinessParams().getRowParamsCount() - 1;
            bussinessParams.addRowParams(outputDataTemp.getBussinessParams().getRowParams(index));
            retcode = 1;
        }
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)retcode));
        return outputData;
    }

    private Datainterface handleOutput(Datainterface outputData) {
        int len = this.operList2nd.size();
        block5: for (int i = 0; i < len; ++i) {
            Operation operation = (Operation)this.operList2nd.get(i);
            switch (operation.getCmdid()) {
                case 34500: {
                    this.handleQueryLockStatusBack(operation, outputData);
                    continue block5;
                }
                case 34477: {
                    this.handleQueryS1Back(operation, outputData);
                    continue block5;
                }
                case 34478: {
                    this.handleQueryExistStatusBack(operation, outputData);
                    continue block5;
                }
                default: {
                    TELogFactory.getNormalLogger().info("TEQuery2mClockPriority.handleOutput() operation getCmdid:" + operation.getCmdid() + " not in case!");
                }
            }
        }
        Datainterface outputDataTemp = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operList2nd, (ArrayList)this.getFilterErrorCodeList());
        return outputDataTemp;
    }

    private int handleQueryS1Back(Operation opr, Datainterface outputData) {
        Output[] outputs = opr.getOutput();
        Output output2 = null;
        for (Output output2 : outputs) {
            int retCode = Integer.parseInt(output2.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String clockid = output2.getPartValue("clockid");
            String s1byte = output2.getPartValue("s1byte");
            this.jointS1(clockid, s1byte, outputData);
        }
        return 0;
    }

    private void jointS1(String clockid, String s1byte, Datainterface outputData) {
        RowParams[] rows = outputData.getBussinessParams().getRowParams();
        int len1 = rows.length;
        for (int j = 0; j < len1; ++j) {
            if (!clockid.equalsIgnoreCase(rows[j].getParam("clockidhex").getValue())) continue;
            int quality = 0;
            if (s1byte.equals("") || s1byte.equals("-1")) {
                quality = 16;
            } else {
                quality = Integer.parseInt(s1byte);
                if ((quality &= 0xF) != 0 && quality != 2 && quality != 4 && quality != 8 && quality != 11 && quality != 15) {
                    quality = 16;
                }
            }
            rows[j].getParam("s1byte").setValue("" + quality);
            return;
        }
    }

    private int handleQueryExistStatusBack(Operation opr, Datainterface outputData) {
        Output[] outputs = opr.getOutput();
        Output output2 = null;
        for (Output output2 : outputs) {
            int retCode = Integer.parseInt(output2.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            int clocknum = Integer.parseInt(output2.getPartValue("clocknum"));
            String clockdata = output2.getPartValue("clockdata");
            String[] clockidstr = new String[clocknum];
            int clockidlength = 8;
            int from = 0;
            for (int j = 0; j < clocknum; ++j) {
                clockidstr[j] = clockdata.substring(from, from + clockidlength);
                from += clockidlength;
                this.jointExistStatus(clockidstr[j], outputData);
            }
        }
        return 0;
    }

    private void jointExistStatus(String clockid, Datainterface outputData) {
        RowParams[] rows = outputData.getBussinessParams().getRowParams();
        int len1 = rows.length;
        for (int j = 0; j < len1; ++j) {
            if (!clockid.equalsIgnoreCase(rows[j].getParam("clockidhex").getValue())) continue;
            rows[j].getParam("clockstate").setValue("1");
            return;
        }
    }

    private int handleQueryLockStatusBack(Operation opr, Datainterface outputData) {
        Output[] outputs = opr.getOutput();
        Output output2 = null;
        for (Output output2 : outputs) {
            int retCode = Integer.parseInt(output2.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String clockid = output2.getPartValue("clockid");
            String lockstate = output2.getPartValue("lockstate");
            this.jointLockStatus(clockid, lockstate, outputData);
        }
        return 0;
    }

    private void jointLockStatus(String clockid, String lockstate, Datainterface outputData) {
        RowParams[] rows = outputData.getBussinessParams().getRowParams();
        int len1 = rows.length;
        for (int j = 0; j < len1; ++j) {
            if (!clockid.equalsIgnoreCase(rows[j].getParam("clockidhex").getValue())) continue;
            rows[j].getParam("lockstate").setValue(lockstate);
            return;
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeLis = new ArrayList<Integer>();
        filterErrorCodeLis.add(38662);
        filterErrorCodeLis.add(38751);
        return filterErrorCodeLis;
    }
}

