/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.channel;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEAlarm;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nelist.model.TELCTFunBlockComparator;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nemgr.marine.TENE_MARINE;
import com.huawei.nglct.nemgr.marine.channel.TEChannelDataMgr;
import com.huawei.nglct.nemgr.marine.common.TENEExplorerCommonForLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEChannelPathGraph
extends TENEExplorerCommonForLogBean {
    private int boardtype = -1;
    private int slotID = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.user = user;
        this.outputData = new Datainterface();
        String slotinfo = inputData.getBussinessParams().getRowParams(0).getParam("slotID").getValue();
        this.slotID = Integer.parseInt(slotinfo);
        this.boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        this.getChannelData(neid, this.slotID);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void getChannelData(int neID, int slotID) {
        List funblockList = TEChannelDataMgr.getInstance().getLctFunBlockList(neID, slotID);
        TELCTFunBlockComparator comparator = new TELCTFunBlockComparator();
        Collections.sort(funblockList, comparator);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        for (int i = 0; i < funblockList.size(); ++i) {
            TELCTFunBlock fb = (TELCTFunBlock)funblockList.get(i);
            RowParams rowParam = new RowParams();
            rowParam.addParam("id", fb.id);
            rowParam.addParam("pid", fb.pid);
            rowParam.addParam("name", fb.name);
            rowParam.addParam("portID", String.valueOf(fb.portid));
            rowParam.addParam("pathID", String.valueOf(fb.pathid));
            rowParam.addParam("canDelPort", String.valueOf(fb.canDelPort));
            rowParam.addParam("canModifyPort", String.valueOf(fb.canModifyPort));
            rowParam.addParam("functionType", String.valueOf(fb.functionType));
            rowParam.addParam("loopback", String.valueOf(fb.loopback));
            rowParam.addParam("payload", String.valueOf(fb.payload));
            rowParam.addParam("portName", fb.portName);
            rowParam.addParam("portStatus", String.valueOf(fb.portStatus));
            rowParam.addParam("usageState", String.valueOf(fb.usageState));
            fb.topAlarmLevel = 0;
            if (fb.pathid >= 0) {
                this.geAlarmStatus(neID, slotID, fb);
            }
            rowParam.addParam("topAlarmLevel", String.valueOf(fb.topAlarmLevel));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
    }

    private void geAlarmStatus(int neID, int slotID, TELCTFunBlock funblock) {
        TENE_MARINE neobj = (TENE_MARINE)TENEListMgr.getInstance().getNE(neID);
        Vector alarams = neobj.getAlarmList();
        ArrayList SupportAlmList = TEAlarmDataMgr.getInstance().getAlarmFbList(this.boardtype);
        funblock.topAlarmLevel = 0;
        int size = alarams.size();
        for (int i = 0; i < size; ++i) {
            TEAlarm alarm = (TEAlarm)alarams.get(i);
            int slot = alarm.getSlotID();
            int port = alarm.getPort();
            int path = alarm.getPath();
            int fbType = alarm.getFuncBlock();
            if (funblock.pathid > 0) {
                if (fbType != funblock.functionType || port != funblock.portid || slot != slotID || path != funblock.pathid) continue;
                int AlarmLevel = alarm.getAlarmLevel();
                if (funblock.topAlarmLevel > 0) {
                    if (AlarmLevel >= funblock.topAlarmLevel) continue;
                    funblock.topAlarmLevel = AlarmLevel;
                    break;
                }
                funblock.topAlarmLevel = AlarmLevel;
                continue;
            }
            if (fbType != funblock.functionType || port != funblock.portid || slot != slotID) continue;
            int size2 = SupportAlmList.size();
            for (int k = 0; k < size2; ++k) {
                TEAlmFBObj alarmFb = (TEAlmFBObj)SupportAlmList.get(k);
                if (alarmFb.m_usFBType != fbType || alarmFb.m_usPortID != port || alarmFb.m_usPathID != path) continue;
                int AlarmLevel = alarm.getAlarmLevel();
                if (funblock.topAlarmLevel > 0) {
                    if (AlarmLevel >= funblock.topAlarmLevel) continue;
                    funblock.topAlarmLevel = AlarmLevel;
                    continue;
                }
                funblock.topAlarmLevel = AlarmLevel;
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    @Override
    protected String descToString(Datainterface inputData) {
        StringBuffer strBuf = new StringBuffer("");
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, this.boardtype);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
        if (!subrackName.equals("")) {
            subrackName = subrackName + "-";
        }
        if (null == neObj) {
            strBuf.append(this.neid).append("-").append(subrackName).append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID)).append("-").append(boardName);
        } else {
            strBuf.append(neObj.getNEName()).append("-").append(subrackName).append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID)).append("-").append(boardName);
        }
        return strBuf.toString();
    }
}

