/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUVoltage;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUVoltageList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUVoltageReturn;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUVoltageReturnList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineCalcBUsVoltageReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineCalcBUsVoltageRsp;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnPFEPolarityStr;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnPFEPolarityStrList;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataFileOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineCalcBUVoltageData;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEBUPFEOperations;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TECableBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineRepeaterPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationNEPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEMarineBUVoltageUtil {
    private static final int NODE_TYPE_STATION = 0;
    public static final int BUPORT_EARTH = 1;
    private int faultType = 0;
    private int controlUnit = -1;
    private int faultLength = 0;
    private int lineID = 0;
    private TEMarineBUPO marineBUPO = null;
    private TEMarineCalcBUVoltageData buVoltageData = null;
    private AsnMarineCalcBUsVoltageReq request = null;
    private AsnMarineCalcBUsVoltageRsp response = null;
    private List<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
    private List<TEMarineCablePO> cableList = new ArrayList<TEMarineCablePO>();
    private List<TEMarineCTBPO> ctbList = new ArrayList<TEMarineCTBPO>();
    private List<TEMarineStationPO> stationList = new ArrayList<TEMarineStationPO>();
    private static final int NSERR_MARINE_QUERY_PFEVOLT_FAIL = 1090615171;
    private static final int NSERR_MARINE_MISS_CABLEINFO = 1090615170;
    private int buVoltage = 0;
    private List<List<TEMarineCablePO>> marineCableInfoList = new ArrayList<List<TEMarineCablePO>>();
    private HashMap<String, HashMap> pfeListMap = new HashMap();
    Map<String, TEMarinePowerSupplyUnitPO> psuMap = TEMarineBUUtil.doQueryPSUs();

    public TEMarineBUVoltageUtil(TEMarineCalcBUVoltageData buVoltageData) {
        if (null == buVoltageData) {
            return;
        }
        this.faultType = buVoltageData.getFaultType().intValue();
        this.controlUnit = buVoltageData.getControlUnit().intValue();
        this.faultLength = buVoltageData.getFaultLength().intValue();
        this.lineID = buVoltageData.getLineID().intValue();
        this.marineBUPO = buVoltageData.getMarineBUPO();
        this.buVoltageData = buVoltageData;
        this.psuMap = TEMarineBUUtil.doQueryPSUs();
    }

    public TEMarineBUVoltageUtil(AsnMarineCalcBUsVoltageReq request, AsnMarineCalcBUsVoltageRsp response) {
        this.request = request;
        this.response = response;
        this.psuMap = TEMarineBUUtil.doQueryPSUs();
    }

    private void dealValueReturnAll(int errorCode) {
        AsnMarineBUVoltageList buVoltageList = this.request.buVoltageList;
        AsnMarineBUVoltageReturnList buVoltageResultList = this.response.buVoltageResultList;
        if (null == buVoltageResultList) {
            buVoltageResultList = new AsnMarineBUVoltageReturnList();
        }
        AsnMarineBUVoltage buVoltage = null;
        AsnMarineBUVoltageReturn buVoltageRtn = null;
        AsnMarineBUVoltageReturn buVoltageRtnTmp = null;
        int len = buVoltageList.size();
        for (int i = 0; i < len; ++i) {
            buVoltage = (AsnMarineBUVoltage)buVoltageList.get(i);
            buVoltageRtn = new AsnMarineBUVoltageReturn();
            buVoltageRtn.buname = buVoltage.marineBU.buname;
            buVoltageRtn.voltage = BigInteger.valueOf(0L);
            buVoltageRtn.result.setRetCode(errorCode);
            buVoltageRtn.result.isSuccess = false;
            boolean isAdd = true;
            int rLen = buVoltageResultList.size();
            for (int l = 0; l < rLen; ++l) {
                buVoltageRtnTmp = (AsnMarineBUVoltageReturn)buVoltageResultList.get(l);
                if (buVoltageRtnTmp.buname != buVoltageRtn.buname) continue;
                isAdd = false;
                break;
            }
            if (!isAdd) continue;
            buVoltageResultList.add((Object)buVoltageRtn);
        }
        this.response.buVoltageResultList = buVoltageResultList;
        this.response.result.isSuccess = false;
        this.response.result.setRetCode(errorCode);
    }

    private void dealValueReturn(int errorCode, AsnMarineBUVoltageReturn buVoltageRtn) {
        buVoltageRtn.voltage = BigInteger.valueOf(0L);
        buVoltageRtn.result.setRetCode(errorCode);
        buVoltageRtn.result.isSuccess = 0 == errorCode;
    }

    private void dealValueReturn(int errorCode, AsnMarineBUVoltageReturn buVoltageRtn, int voltage) {
        buVoltageRtn.voltage = BigInteger.valueOf(voltage);
        buVoltageRtn.result.setRetCode(errorCode);
        buVoltageRtn.result.isSuccess = 0 == errorCode;
    }

    public int doCalcBUVoltages() {
        int i;
        int ret = this.doQueryBUInfo();
        if (0 != ret) {
            this.dealValueReturnAll(ret);
            return ret;
        }
        ret = this.doQueryCableInfo();
        if (0 != ret) {
            this.dealValueReturnAll(ret);
            return ret;
        }
        ret = this.doQueryStationInfo();
        if (0 != ret) {
            this.dealValueReturnAll(ret);
            return ret;
        }
        AsnMarineBUVoltageList buVoltageList = this.request.buVoltageList;
        AsnMarineBUVoltageReturnList buVoltageResultList = new AsnMarineBUVoltageReturnList();
        AsnMarineBUVoltage buVoltage = null;
        AsnMarineBUVoltageReturn buVoltageRtn = null;
        int len = buVoltageList.size();
        for (i = 0; i < len; ++i) {
            buVoltage = (AsnMarineBUVoltage)buVoltageList.get(i);
            if (3 == buVoltage.faultType.intValue()) {
                buVoltageRtn = new AsnMarineBUVoltageReturn();
                buVoltageRtn.buname = buVoltage.marineBU.buname;
                buVoltageRtn.voltage = BigInteger.valueOf(0L);
                buVoltageRtn.result.setRetCode(0);
                buVoltageRtn.result.isSuccess = true;
                buVoltageResultList.add((Object)buVoltageRtn);
            }
            if (1 != buVoltage.faultType.intValue() && 2 != buVoltage.faultType.intValue() || buVoltage.controlUnit.intValue() > 0 && buVoltage.faultLength.intValue() >= 0 && buVoltage.lineID.intValue() > 0) continue;
            buVoltageRtn = new AsnMarineBUVoltageReturn();
            buVoltageRtn.buname = buVoltage.marineBU.buname;
            buVoltageRtn.voltage = BigInteger.valueOf(0L);
            buVoltageRtn.result.setRetCode(2);
            buVoltageRtn.result.isSuccess = false;
            buVoltageResultList.add((Object)buVoltageRtn);
        }
        this.response.buVoltageResultList = buVoltageResultList;
        if (!this.doCalcMainRoute()) {
            this.dealValueReturnAll(1090615170);
            return ret;
        }
        len = buVoltageList.size();
        for (i = 0; i < len; ++i) {
            boolean isCalc = false;
            buVoltage = (AsnMarineBUVoltage)buVoltageList.get(i);
            int jlen = buVoltageResultList.size();
            for (int j = 0; j < jlen; ++j) {
                buVoltageRtn = (AsnMarineBUVoltageReturn)buVoltageResultList.get(j);
                if (!new String(buVoltageRtn.buname).equals(new String(buVoltage.marineBU.buname))) continue;
                isCalc = true;
                break;
            }
            if (isCalc) continue;
            TEMarineBUPO marineBUPO = TEMarineBUE2EUtil.convertAsn1ToBUPO(buVoltage.marineBU);
            buVoltageRtn = new AsnMarineBUVoltageReturn();
            buVoltageRtn.buname = buVoltage.marineBU.buname;
            if (1 == buVoltage.faultType.intValue() || 2 == buVoltage.faultType.intValue()) {
                char bPort = (char)buVoltage.controlUnit.intValue();
                String buPort = String.valueOf(bPort);
                TEMarineCablePO cablePO = this.getCablePOByBUPort(marineBUPO.getBuName(), buPort);
                if (null != cablePO) {
                    List<TEMarineCablePO> cableInfoList = this.getCableListByBUInfo(marineBUPO.getBuName(), buPort);
                    List<TEMarineCablePO> calcCableInfoList = this.getCalcCableListForFault(marineBUPO, cablePO, cableInfoList);
                    this.doCalcBUVoltageByCableListForFault(calcCableInfoList, marineBUPO, buVoltageRtn);
                } else {
                    List<List<TEMarineCablePO>> calcCableInfoList = this.getCalcCableListByBUPO(marineBUPO);
                    if (null == calcCableInfoList || calcCableInfoList.isEmpty() || calcCableInfoList.get(0).isEmpty() && calcCableInfoList.get(1).isEmpty()) {
                        this.dealValueReturn(0, buVoltageRtn);
                    }
                    this.doCalcBUVoltageByCableList(calcCableInfoList, marineBUPO, buVoltageRtn);
                }
            } else {
                List<List<TEMarineCablePO>> calcCableInfoList = this.getCalcCableListByBUPO(marineBUPO);
                if (null == calcCableInfoList || calcCableInfoList.isEmpty() || calcCableInfoList.get(0).isEmpty() && calcCableInfoList.get(1).isEmpty()) {
                    this.dealValueReturn(0, buVoltageRtn);
                }
                this.doCalcBUVoltageByCableList(calcCableInfoList, marineBUPO, buVoltageRtn);
            }
            buVoltageResultList.add((Object)buVoltageRtn);
        }
        AsnPFEPolarityStrList pfePolarityList = new AsnPFEPolarityStrList();
        AsnPFEPolarityStr pfePolarity = null;
        for (HashMap value : this.pfeListMap.values()) {
            if (null == value || null == value.get("pfeNEID")) continue;
            pfePolarity = new AsnPFEPolarityStr();
            pfePolarity.neID = (BigInteger)value.get("pfeNEID");
            pfePolarity.polarity = null != value.get("polarity") ? ((String)value.get("polarity")).getBytes() : "I".getBytes();
            pfePolarity.pfeVoltage = null != value.get("pfeVoltage") ? (BigInteger)value.get("pfeVoltage") : BigInteger.valueOf(0L);
            pfePolarity.pfeCurrent = null != value.get("pfeCurrent") ? (BigInteger)value.get("pfeCurrent") : BigInteger.valueOf(0L);
            pfePolarityList.add((Object)pfePolarity);
        }
        this.response.pfePolarityList = pfePolarityList;
        this.response.result.isSuccess = true;
        this.response.result.setRetCode(0);
        return 0;
    }

    public TEMarineCalcBUVoltageData doCalcBUVoltage() {
        if (3 == this.faultType) {
            this.buVoltageData.setResultCode(BigInteger.valueOf(0L));
            this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
            return this.buVoltageData;
        }
        int ret = this.doQueryBUInfo();
        if (0 != ret) {
            this.buVoltageData.setResultCode(BigInteger.valueOf(ret));
            this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
            return this.buVoltageData;
        }
        ret = this.doQueryCableInfo();
        if (0 != ret) {
            this.buVoltageData.setResultCode(BigInteger.valueOf(ret));
            this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
            return this.buVoltageData;
        }
        ret = this.doQueryStationInfo();
        if (0 != ret) {
            this.buVoltageData.setResultCode(BigInteger.valueOf(ret));
            this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
            return this.buVoltageData;
        }
        if (!this.doCalcMainRoute()) {
            this.buVoltageData.setResultCode(BigInteger.valueOf(1090615170L));
            this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
            return this.buVoltageData;
        }
        if (1 == this.faultType || 2 == this.faultType) {
            if (this.controlUnit <= 0 || this.faultLength < 0 || this.lineID <= 0) {
                this.buVoltageData.setResultCode(BigInteger.valueOf(2L));
                this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
                return this.buVoltageData;
            }
            char bPort = (char)this.controlUnit;
            String buPort = String.valueOf(bPort);
            TEMarineCablePO cablePO = this.getCablePOByBUPort(this.marineBUPO.getBuName(), buPort);
            if (null != cablePO) {
                List<TEMarineCablePO> cableInfoList = this.getCableListByBUInfo(this.marineBUPO.getBuName(), buPort);
                List<TEMarineCablePO> calcCableInfoList = this.getCalcCableListForFault(this.marineBUPO, cablePO, cableInfoList);
                this.doCalcBUVoltageByCableListForFault(calcCableInfoList, this.marineBUPO, null);
            } else {
                List<List<TEMarineCablePO>> calcCableInfoList = this.getCalcCableListByBUPO(this.marineBUPO);
                if (null == calcCableInfoList || calcCableInfoList.isEmpty() || calcCableInfoList.get(0).isEmpty() && calcCableInfoList.get(1).isEmpty()) {
                    this.buVoltageData.setResultCode(BigInteger.valueOf(0L));
                    this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
                    return this.buVoltageData;
                }
                this.doCalcBUVoltageByCableList(calcCableInfoList, this.marineBUPO, null);
            }
        } else {
            List<List<TEMarineCablePO>> calcCableInfoList = this.getCalcCableListByBUPO(this.marineBUPO);
            if (null == calcCableInfoList || calcCableInfoList.isEmpty() || calcCableInfoList.get(0).isEmpty() && calcCableInfoList.get(1).isEmpty()) {
                this.buVoltageData.setResultCode(BigInteger.valueOf(0L));
                this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
                return this.buVoltageData;
            }
            this.doCalcBUVoltageByCableList(calcCableInfoList, this.marineBUPO, null);
        }
        return this.buVoltageData;
    }

    private int doCalcBUVoltageByCableListForFault(List<TEMarineCablePO> cableInfoList, TEMarineBUPO marineBUPO, AsnMarineBUVoltageReturn buVoltageRtn) {
        HashMap pfeMap1 = new HashMap();
        if (0 != this.doQueryPFEVoltage(cableInfoList, pfeMap1, marineBUPO)) {
            if (buVoltageRtn != null) {
                this.dealValueReturn(2, buVoltageRtn);
            }
            return 2;
        }
        int pfeVoltage1 = 0;
        int pfeCurrent1 = 0;
        if (null != pfeMap1.get("pfeName") && null != pfeMap1.get("pfeVoltage") && null != pfeMap1.get("pfeCurrent")) {
            pfeVoltage1 = ((BigInteger)pfeMap1.get("pfeVoltage")).intValue();
            pfeCurrent1 = ((BigInteger)pfeMap1.get("pfeCurrent")).intValue();
        }
        double ecableVolt = this.doCalcECableVoltage(pfeMap1.get("pfeName").toString(), pfeCurrent1);
        double cableVolt = this.doCalcCableVoltage(cableInfoList, pfeCurrent1);
        int rptVolt = this.doCalcRptVoltage(cableInfoList);
        int buVolt = this.doCalcBUVoltage(cableInfoList, marineBUPO);
        double allVolt = ecableVolt + cableVolt + (double)rptVolt + (double)buVolt;
        if (0 == pfeVoltage1) {
            if (buVoltageRtn != null) {
                this.dealValueReturn(0, buVoltageRtn);
            } else {
                this.buVoltageData.setResultCode(BigInteger.valueOf(0L));
                this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
            }
            return 0;
        }
        double buVoltage = 0.0;
        buVoltage = pfeVoltage1 > 0 ? (double)pfeVoltage1 - allVolt : (double)pfeVoltage1 + allVolt;
        if (buVoltageRtn != null) {
            this.dealValueReturn(0, buVoltageRtn, (int)buVoltage);
        } else {
            this.buVoltageData.setResultCode(BigInteger.valueOf(0L));
            this.buVoltageData.setBuVoltage(BigInteger.valueOf((int)buVoltage));
        }
        return 0;
    }

    private List<TEMarineCablePO> getCalcCableListForFault(TEMarineBUPO marineBUPO, TEMarineCablePO cablePO, List<TEMarineCablePO> cableInfoList) {
        ArrayList<TEMarineCablePO> tmpCableList = new ArrayList<TEMarineCablePO>();
        boolean isClear = false;
        for (TEMarineCablePO tmpCablePO : cableInfoList) {
            tmpCableList.add(tmpCablePO);
            if (cablePO.equals(tmpCablePO)) {
                isClear = true;
                break;
            }
            if (!tmpCablePO.getSrcNodeName().equals(marineBUPO.getBuName()) && !tmpCablePO.getSinkNodeName().equals(marineBUPO.getBuName())) continue;
            break;
        }
        if (!isClear) {
            return tmpCableList;
        }
        tmpCableList.clear();
        for (int j = cableInfoList.size() - 1; j >= 0; --j) {
            TEMarineCablePO tmpCablePO;
            tmpCablePO = cableInfoList.get(j);
            tmpCableList.add(tmpCablePO);
            if (tmpCablePO.getSrcNodeName().equals(marineBUPO.getBuName()) || tmpCablePO.getSinkNodeName().equals(marineBUPO.getBuName())) break;
        }
        return tmpCableList;
    }

    private List<List<TEMarineCablePO>> getCalcCableListByBUPO(TEMarineBUPO marineBUPO) {
        ArrayList<TEMarineCablePO> calcCableList1 = new ArrayList<TEMarineCablePO>();
        ArrayList<TEMarineCablePO> calcCableList2 = new ArrayList<TEMarineCablePO>();
        List<Object> tmpCableList1 = new ArrayList();
        List<Object> tmpCableList2 = new ArrayList();
        ArrayList<List<TEMarineCablePO>> tmpCableBothList = new ArrayList<List<TEMarineCablePO>>();
        boolean isFinded = false;
        int n = this.marineCableInfoList.size();
        for (int i = 0; i < n; ++i) {
            tmpCableList1 = this.marineCableInfoList.get(i);
            for (TEMarineCablePO tEMarineCablePO : tmpCableList1) {
                if (!tEMarineCablePO.getSrcNodeName().equals(marineBUPO.getBuName()) && !tEMarineCablePO.getSinkNodeName().equals(marineBUPO.getBuName())) continue;
                isFinded = true;
                break;
            }
            if (isFinded) break;
        }
        for (TEMarineCablePO tEMarineCablePO : tmpCableList1) {
            if (0 != tEMarineCablePO.getFaultType()) {
                calcCableList1.clear();
                break;
            }
            calcCableList1.add(tEMarineCablePO);
            if (!tEMarineCablePO.getSrcNodeName().equals(marineBUPO.getBuName()) && !tEMarineCablePO.getSinkNodeName().equals(marineBUPO.getBuName())) continue;
            break;
        }
        tmpCableBothList.add(calcCableList1);
        isFinded = false;
        int n2 = this.marineCableInfoList.size();
        for (int i = 0; i < n2; ++i) {
            tmpCableList2 = this.marineCableInfoList.get(i);
            for (int j = tmpCableList2.size() - 1; j >= 0; --j) {
                TEMarineCablePO tEMarineCablePO = (TEMarineCablePO)tmpCableList2.get(j);
                if (!tEMarineCablePO.getSrcNodeName().equals(marineBUPO.getBuName()) && !tEMarineCablePO.getSinkNodeName().equals(marineBUPO.getBuName())) continue;
                isFinded = true;
                break;
            }
            if (isFinded) break;
        }
        for (int j = tmpCableList2.size() - 1; j >= 0; --j) {
            TEMarineCablePO tEMarineCablePO = (TEMarineCablePO)tmpCableList2.get(j);
            if (0 != tEMarineCablePO.getFaultType()) {
                calcCableList2.clear();
                break;
            }
            calcCableList2.add(tEMarineCablePO);
            if (tEMarineCablePO.getSrcNodeName().equals(marineBUPO.getBuName()) || tEMarineCablePO.getSinkNodeName().equals(marineBUPO.getBuName())) break;
        }
        tmpCableBothList.add(calcCableList2);
        return tmpCableBothList;
    }

    private int doCalcBUVoltageByCableList(List<List<TEMarineCablePO>> calcCableList, TEMarineBUPO marineBUPO, AsnMarineBUVoltageReturn buVoltageRtn) {
        HashMap pfeMap1 = new HashMap();
        HashMap pfeMap2 = new HashMap();
        int queryPFE1 = this.doQueryPFEVoltage(calcCableList.get(0), pfeMap1, marineBUPO);
        int queryPFE2 = this.doQueryPFEVoltage(calcCableList.get(1), pfeMap2, marineBUPO);
        if (0 != queryPFE1 && 0 != queryPFE2) {
            if (buVoltageRtn != null) {
                this.dealValueReturn(2, buVoltageRtn);
            }
            return 2;
        }
        int pfeVoltage1 = 0;
        int pfeVoltage2 = 0;
        int pfeCurrent1 = 0;
        int pfeCurrent2 = 0;
        if (0 == queryPFE1 && null != pfeMap1.get("pfeName") && null != pfeMap1.get("pfeVoltage") && null != pfeMap1.get("pfeCurrent")) {
            pfeVoltage1 = ((BigInteger)pfeMap1.get("pfeVoltage")).intValue();
            pfeCurrent1 = ((BigInteger)pfeMap1.get("pfeCurrent")).intValue();
        }
        if (0 == queryPFE2 && null != pfeMap2.get("pfeName") && null != pfeMap2.get("pfeVoltage") && null != pfeMap2.get("pfeCurrent")) {
            pfeVoltage2 = ((BigInteger)pfeMap2.get("pfeVoltage")).intValue();
            pfeCurrent2 = ((BigInteger)pfeMap2.get("pfeCurrent")).intValue();
        }
        int pfeVoltage = 0;
        int pfeCurrent = 0;
        List<TEMarineCablePO> calcCablePOList = null;
        String pfeName = "";
        if (0 == pfeVoltage1) {
            pfeVoltage = pfeVoltage2;
            pfeCurrent = pfeCurrent2;
            calcCablePOList = calcCableList.get(1);
            pfeName = pfeMap2.get("pfeName").toString();
        } else {
            pfeVoltage = pfeVoltage1;
            pfeCurrent = pfeCurrent1;
            calcCablePOList = calcCableList.get(0);
            pfeName = pfeMap1.get("pfeName").toString();
        }
        double ecableVolt = this.doCalcECableVoltage(pfeName, pfeCurrent);
        double cableVolt = this.doCalcCableVoltage(calcCablePOList, pfeCurrent);
        int rptVolt = this.doCalcRptVoltage(calcCablePOList);
        int buVolt = this.doCalcBUVoltage(calcCablePOList, marineBUPO);
        double allVolt = ecableVolt + cableVolt + (double)rptVolt + (double)buVolt;
        if (pfeVoltage1 == pfeVoltage2 && 0 == pfeVoltage1) {
            if (buVoltageRtn != null) {
                this.dealValueReturn(0, buVoltageRtn);
            } else {
                this.buVoltageData.setResultCode(BigInteger.valueOf(0L));
                this.buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
            }
            return 0;
        }
        double buVoltage = 0.0;
        if (0 != pfeVoltage1 && 0 != pfeVoltage2) {
            String pfeName2;
            String pfeName1 = (String)pfeMap1.get("pfeName");
            if (pfeName1.equals(pfeName2 = (String)pfeMap2.get("pfeName"))) {
                buVoltage = pfeVoltage1 >= 0 ? (double)pfeVoltage1 - allVolt : (double)pfeVoltage1 + allVolt;
            } else if (pfeVoltage1 >= pfeVoltage2) {
                double buVoltage1 = (double)pfeVoltage1 - allVolt;
                double buVoltage2 = (double)pfeVoltage1 - allVolt - (double)marineBUPO.getPressure();
                if (buVoltage2 >= 0.0) {
                    buVoltage = buVoltage1;
                }
                if (buVoltage1 <= 0.0) {
                    buVoltage = buVoltage2;
                }
                if (buVoltage1 > 0.0 && buVoltage2 < 0.0) {
                    buVoltage = buVoltage1 + buVoltage2 >= 0.0 ? buVoltage1 : buVoltage2;
                }
            } else {
                double buVoltage1 = (double)pfeVoltage1 + allVolt;
                double buVoltage2 = (double)pfeVoltage1 + allVolt + (double)marineBUPO.getPressure();
                if (buVoltage1 >= 0.0) {
                    buVoltage = buVoltage2;
                }
                if (buVoltage2 <= 0.0) {
                    buVoltage = buVoltage1;
                }
                if (buVoltage2 > 0.0 && buVoltage1 < 0.0) {
                    buVoltage = buVoltage2 + buVoltage1 >= 0.0 ? buVoltage2 : buVoltage1;
                }
            }
        } else {
            buVoltage = pfeVoltage >= 0 ? (double)pfeVoltage - allVolt : (double)pfeVoltage + allVolt;
        }
        if (buVoltageRtn != null) {
            this.dealValueReturn(0, buVoltageRtn, (int)buVoltage);
        } else {
            this.buVoltageData.setResultCode(BigInteger.valueOf(0L));
            this.buVoltageData.setBuVoltage(BigInteger.valueOf((int)buVoltage));
        }
        return 0;
    }

    private int doCalcBUVoltage(List<TEMarineCablePO> calcCableList, TEMarineBUPO marineBUPO) {
        if (null == calcCableList || calcCableList.isEmpty()) {
            return 0;
        }
        int buVolt = 0;
        for (TEMarineCablePO marineCable : calcCableList) {
            TEMarineBUPO marineBU;
            if (0 == marineCable.getSinkType() || null == (marineBU = this.getMarineBUByName(marineCable.getSinkNodeName())) || marineBUPO.getBuName().equals(marineBU.getBuName())) continue;
            buVolt += marineBU.getPressure();
        }
        return buVolt;
    }

    private int doCalcRptVoltage(List<TEMarineCablePO> calcCableList) {
        if (null == calcCableList || calcCableList.isEmpty()) {
            return 0;
        }
        int volt = 0;
        for (TEMarineCablePO marineCable : calcCableList) {
            Set rptList = marineCable.getRPTList();
            for (TEMarineRepeaterPO repeater : rptList) {
                volt += repeater.VDrop;
            }
        }
        return volt;
    }

    private double doCalcECableVoltage(String pfeName, int current) {
        TEMarineStnEleCblDBOper eCableDBOper = TEMarineStnEleCblDBOper.getInstance();
        TEMarineStnEleCablePO eCable = eCableDBOper.getStnECableByNodeName(pfeName);
        if (null == eCable) {
            return 0.0;
        }
        return Double.parseDouble(eCable.getResistance()) * Double.parseDouble(eCable.getLength()) * (double)current / 1000.0;
    }

    private double doCalcCableVoltage(List<TEMarineCablePO> calcCableList, int pfeCurrent) {
        if (null == calcCableList || calcCableList.isEmpty()) {
            return 0.0;
        }
        double volt = 0.0;
        for (TEMarineCablePO marineCable : calcCableList) {
            TELogFactory.getNormalLogger().info("The cable is " + marineCable.CableName);
            volt += (double)(marineCable.getCableLen() * marineCable.getCableResistance() * pfeCurrent) / 10000.0;
        }
        return volt;
    }

    private int doQueryPFEVoltage(List<TEMarineCablePO> calcCableList, HashMap pfeMap, TEMarineBUPO marineBUPO) {
        String pfeName;
        int pfeVoltage = 0;
        String tmpBUPortName = null;
        for (TEMarineCablePO cablePO : calcCableList) {
            if (0 != cablePO.getSrcType() && marineBUPO.getBuName().equals(cablePO.getSrcNodeName())) {
                tmpBUPortName = cablePO.getSrcBuPortName();
                break;
            }
            if (0 == cablePO.getSinkType() || !marineBUPO.getBuName().equals(cablePO.getSinkNodeName())) continue;
            tmpBUPortName = cablePO.getSinkBuPortName();
            break;
        }
        if (null == (pfeName = this.getPFEName(tmpBUPortName, marineBUPO)) || pfeName.isEmpty() || this.psuMap.containsKey(pfeName)) {
            return pfeVoltage;
        }
        if (this.pfeListMap.containsKey(pfeName)) {
            HashMap pfeMapTemp = this.pfeListMap.get(pfeName);
            if (null != pfeMapTemp.get("pfeNEID")) {
                pfeMap.put("pfeNEID", (BigInteger)pfeMapTemp.get("pfeNEID"));
            }
            if (null != pfeMapTemp.get("pfeName")) {
                pfeMap.put("pfeName", (String)pfeMapTemp.get("pfeName"));
            }
            if (null != pfeMapTemp.get("pfeVoltage")) {
                pfeMap.put("pfeVoltage", (BigInteger)pfeMapTemp.get("pfeVoltage"));
            }
            if (null != pfeMapTemp.get("pfeCurrent")) {
                pfeMap.put("pfeCurrent", (BigInteger)pfeMapTemp.get("pfeCurrent"));
            }
            if (null != pfeMapTemp.get("nePolarity")) {
                pfeMap.put("nePolarity", (String)pfeMapTemp.get("nePolarity"));
            }
            if (null != pfeMapTemp.get("errorCode")) {
                pfeMap.put("errorCode", (BigInteger)pfeMapTemp.get("errorCode"));
            }
            if (null == pfeMap.get("pfeVoltage") || null == pfeMap.get("pfeCurrent")) {
                if (null != pfeMap.get("errorCode") && null != this.buVoltageData) {
                    this.buVoltageData.setResultCode((BigInteger)pfeMap.get("errorCode"));
                }
                return 2;
            }
        } else {
            pfeMap.put("pfeName", pfeName);
            this.pfeListMap.put(pfeName, pfeMap);
        }
        String stationName = null;
        for (TEMarineCablePO cablePO : calcCableList) {
            if (0 == cablePO.getSrcType()) {
                stationName = cablePO.getSrcStationName();
                break;
            }
            if (0 != cablePO.getSinkType()) continue;
            stationName = cablePO.getSinkStationName();
            break;
        }
        if (null == stationName) {
            pfeMap.put("errorCode", BigInteger.valueOf(1090615170L));
            if (null != this.buVoltageData) {
                this.buVoltageData.setResultCode(BigInteger.valueOf(1090615170L));
            }
            return 2;
        }
        int pfeNEID = TETL1NECommMgr.getInstance().getLogicNEID(pfeName);
        boolean isExist = false;
        block2: for (TEMarineStationPO stationPO : this.stationList) {
            if (!stationPO.getName().equals(stationName)) continue;
            for (TEMarineStationNEPO stationNEPO : stationPO.getShelfList()) {
                if (stationNEPO.neID != (long)pfeNEID) continue;
                isExist = true;
                continue block2;
            }
        }
        if (!isExist) {
            pfeMap.put("errorCode", BigInteger.valueOf(1090615170L));
            if (null != this.buVoltageData) {
                this.buVoltageData.setResultCode(BigInteger.valueOf(1090615170L));
            }
            return 2;
        }
        int getPFEVoltage = 0;
        if (null == pfeMap.get("pfeVoltage") || null == pfeMap.get("pfeCurrent")) {
            getPFEVoltage = TEBUPFEOperations.getPFEVoltageHandler(pfeName, pfeMap);
        }
        if (0 != getPFEVoltage) {
            pfeMap.put("errorCode", BigInteger.valueOf(1090615171L));
            if (null != this.buVoltageData) {
                this.buVoltageData.setResultCode(BigInteger.valueOf(1090615171L));
            }
            return 2;
        }
        return getPFEVoltage;
    }

    private String getPFEName(String buPortName, TEMarineBUPO marineBUPO) {
        if (null == buPortName) {
            return null;
        }
        for (TEBUPortPO buPort : marineBUPO.getPortList()) {
            if (!buPortName.equals(buPort.getPortName())) continue;
            return buPort.getBondPFE();
        }
        return null;
    }

    private List<TEMarineCablePO> getCalcCableList(TEMarineBUPO marineBUPO) {
        ArrayList<TEMarineCablePO> calcCableList = new ArrayList<TEMarineCablePO>();
        TEMarineCablePO faultCable = this.getFaultPointCable();
        if (null == faultCable) {
            return calcCableList;
        }
        List<TEMarineCablePO> faultMainCableList = this.getCablePOListByCable(faultCable);
        if (null == faultMainCableList) {
            return calcCableList;
        }
        this.getCalcCablePOList(calcCableList, faultMainCableList, faultCable, marineBUPO);
        return calcCableList;
    }

    private void getCalcCablePOList(List<TEMarineCablePO> calcCableList, List<TEMarineCablePO> faultMainCableList, TEMarineCablePO faultCable, TEMarineBUPO marineBUPO) {
        boolean isFaultMate = false;
        int len = faultMainCableList.size();
        for (int index = 0; index < len; ++index) {
            TEMarineCablePO tmpCablePO = faultMainCableList.get(index);
            if (faultCable.equals(tmpCablePO)) {
                isFaultMate = true;
            }
            if (!isFaultMate && this.isSinkBUMate(tmpCablePO, marineBUPO)) {
                this.getCalcCableListByIndex(calcCableList, faultMainCableList, 0, index);
                return;
            }
            if (!isFaultMate || !this.isSinkBUMate(tmpCablePO, marineBUPO)) continue;
            this.getCalcCableListByIndex(calcCableList, faultMainCableList, index + 1, len);
            return;
        }
    }

    private void getCalcCableListByIndex(List<TEMarineCablePO> calcCableList, List<TEMarineCablePO> faultMainCableList, int startIndex, int endIndex) {
        int len = faultMainCableList.size();
        for (int index = 0; index < len; ++index) {
            if (index < startIndex || index > endIndex) continue;
            calcCableList.add(faultMainCableList.get(index));
        }
    }

    private boolean isSinkBUMate(TEMarineCablePO tmpCablePO, TEMarineBUPO marineBUPO) {
        if (null == tmpCablePO) {
            return false;
        }
        return 0 != tmpCablePO.getSinkType() && marineBUPO.getBuName().equals(tmpCablePO.getSinkNodeName());
    }

    private TEMarineCablePO getFaultPointCable() {
        if (-1 == this.controlUnit) {
            return null;
        }
        TEMarineCablePO controlUnitCable = this.getControlUnitCable();
        if (null == controlUnitCable) {
            return null;
        }
        return this.getFaultPointCableDetail(controlUnitCable);
    }

    private TEMarineCablePO getFaultPointCableDetail(TEMarineCablePO controlUnitCable) {
        int len = controlUnitCable.getCableLen();
        String buName = 0 == controlUnitCable.getSrcType() ? controlUnitCable.getSrcNodeName() : controlUnitCable.getSinkNodeName();
        String buPortName = 0 == controlUnitCable.getSrcType() ? controlUnitCable.getSrcStationName() : controlUnitCable.getSinkStationName();
        TEMarineBUPO marineBU = this.getMarineBUByName(buName);
        return this.getFaultPointCableInfoDetail(len, buPortName, marineBU);
    }

    private TEMarineCablePO getFaultPointCableInfoDetail(int len, String usedPortName, TEMarineBUPO marineBU) {
        TEMarineCablePO cableInfo = null;
        String tmpBUName = null;
        String tmpBUPortName = null;
        int pos = len;
        for (TEBUPortPO buPortInfo : marineBU.getPortList()) {
            if (usedPortName.equals(buPortInfo.getPortName()) || !this.isControlUnitCable(cableInfo = this.getFaulteCablePOByBUInfo(buPortInfo.getPortName(), marineBU.getBuName()))) continue;
            if ((pos += cableInfo.getCableLen()) >= this.faultLength) {
                return cableInfo;
            }
            tmpBUName = this.getOtherSideBUName(cableInfo, usedPortName);
            tmpBUPortName = this.getOtherSideBUPortName(cableInfo, usedPortName);
            this.getFaultPointCableInfoDetail(pos, tmpBUPortName, this.getMarineBUByName(tmpBUName));
        }
        return cableInfo;
    }

    private String getOtherSideBUName(TEMarineCablePO cableInfo, String usedPortName) {
        String buName = null;
        if (0 != cableInfo.getSrcType() && usedPortName.equals(cableInfo.getSrcStationName())) {
            buName = cableInfo.getSinkNodeName();
        } else if (0 != cableInfo.getSinkType() && usedPortName.equals(cableInfo.getSinkStationName())) {
            buName = cableInfo.getSrcNodeName();
        }
        return buName;
    }

    private String getOtherSideBUPortName(TEMarineCablePO cableInfo, String usedPortName) {
        String buPortName = null;
        if (0 != cableInfo.getSrcType() && usedPortName.equals(cableInfo.getSrcStationName())) {
            buPortName = cableInfo.getSinkStationName();
        } else if (0 != cableInfo.getSinkType() && usedPortName.equals(cableInfo.getSinkStationName())) {
            buPortName = cableInfo.getSrcStationName();
        }
        return buPortName;
    }

    private TEMarineCablePO getFaulteCablePOByBUInfo(String portName, String buName) {
        for (TEMarineCablePO cablePO : this.cableList) {
            if (!this.isCableContainBUInfo(cablePO, buName, portName)) continue;
            return cablePO;
        }
        return null;
    }

    private boolean doCalcMainRoute() {
        this.marineCableInfoList.clear();
        if (this.cableList.isEmpty()) {
            return false;
        }
        this.ctbList.clear();
        this.doQueryCTBInfo();
        ArrayList<TEMarineCTBPO> queryCTBPOList = new ArrayList<TEMarineCTBPO>();
        for (TEMarineCTBPO ctbPO : this.ctbList) {
            if (queryCTBPOList.contains(ctbPO)) continue;
            queryCTBPOList.add(ctbPO);
            TEMarineCablePO cablePO = this.geCablePObyCTB(ctbPO);
            if (null == cablePO || 0 == cablePO.getSrcType() && 0 == cablePO.getSinkType()) continue;
            ArrayList<TEMarineCablePO> tmpCableList = new ArrayList<TEMarineCablePO>();
            tmpCableList.add(cablePO);
            if (!this.isEarthOtherBUPortbyCable(cablePO, null)) {
                TEMarineBUPO buPO = this.getOtherBUPObyCable(cablePO, null);
                TEBUPortPO buPortPO = this.getOtherBUPortPObyCable(cablePO, null);
                this.calcMarineRouteCable(queryCTBPOList, tmpCableList, buPO, buPortPO);
            }
            this.marineCableInfoList.add(tmpCableList);
        }
        return !this.marineCableInfoList.isEmpty();
    }

    private void calcMarineRouteCable(ArrayList<TEMarineCTBPO> queryCTBPOList, List<TEMarineCablePO> tmpCableList, TEMarineBUPO buPO, TEBUPortPO buPortPO) {
        TEBUPortPO buPortOther = this.getOtherBUPortPO(buPO, buPortPO);
        if (null == buPortOther) {
            return;
        }
        TEMarineCablePO cablePO = this.getCablePOByBUPort(buPO.getBuName(), buPortOther.getPortName());
        if (null == cablePO) {
            return;
        }
        if (this.isCTBOtherbyCable(cablePO, buPO.getBuName())) {
            tmpCableList.add(cablePO);
            queryCTBPOList.add(this.getMarineCTBByName(this.getCTBOtherbyCable(cablePO, buPO.getBuName())));
        } else {
            if (this.isEarthOtherBUPortbyCable(cablePO, buPO.getBuName())) {
                return;
            }
            tmpCableList.add(cablePO);
            TEMarineBUPO buPOTemp = this.getOtherBUPObyCable(cablePO, buPO.getBuName());
            TEBUPortPO buPortPOTemp = this.getOtherBUPortPObyCable(cablePO, buPO.getBuName());
            this.calcMarineRouteCable(queryCTBPOList, tmpCableList, buPOTemp, buPortPOTemp);
        }
    }

    private TEMarineCablePO geCablePObyCTB(TEMarineCTBPO ctbPO) {
        for (TEMarineCablePO tmpCablePO : this.cableList) {
            if (!tmpCablePO.getSrcNodeName().equals(ctbPO.getName()) && !tmpCablePO.getSinkNodeName().equals(ctbPO.getName())) continue;
            return tmpCablePO;
        }
        return null;
    }

    private boolean isCTBOtherbyCable(TEMarineCablePO cablePO, String buName) {
        int nodeType = 0;
        if (buName.equals(cablePO.getSrcNodeName())) {
            nodeType = cablePO.getSinkType();
        }
        if (buName.equals(cablePO.getSinkNodeName())) {
            nodeType = cablePO.getSrcType();
        }
        return 0 == nodeType;
    }

    private String getCTBOtherbyCable(TEMarineCablePO cablePO, String buName) {
        int nodeType = 0;
        String ctbName = "";
        if (buName.equals(cablePO.getSrcNodeName())) {
            nodeType = cablePO.getSinkType();
            ctbName = cablePO.getSinkNodeName();
        }
        if (buName.equals(cablePO.getSinkNodeName())) {
            nodeType = cablePO.getSrcType();
            ctbName = cablePO.getSrcNodeName();
        }
        if (0 == nodeType) {
            return ctbName;
        }
        return "";
    }

    private TEBUPortPO getOtherBUPortPObyCable(TEMarineCablePO cablePO, String buName) {
        String buNameOther = null;
        String buPortNameOther = null;
        if (null == buName) {
            if (0 != cablePO.getSrcType()) {
                buNameOther = cablePO.getSrcNodeName();
                buPortNameOther = cablePO.getSrcBuPortName();
            }
            if (0 != cablePO.getSinkType()) {
                buNameOther = cablePO.getSinkNodeName();
                buPortNameOther = cablePO.getSinkBuPortName();
            }
        } else {
            if (0 != cablePO.getSrcType() && !buName.equals(cablePO.getSrcNodeName())) {
                buNameOther = cablePO.getSrcNodeName();
                buPortNameOther = cablePO.getSrcBuPortName();
            }
            if (0 != cablePO.getSinkType() && !buName.equals(cablePO.getSinkNodeName())) {
                buNameOther = cablePO.getSinkNodeName();
                buPortNameOther = cablePO.getSinkBuPortName();
            }
        }
        if (null == buNameOther || null == buPortNameOther) {
            return null;
        }
        TEMarineBUPO buPO = this.getMarineBUByName(buNameOther);
        if (null == buPO) {
            return null;
        }
        return this.getBUPortPO(buPO, buPortNameOther);
    }

    private TEMarineBUPO getOtherBUPObyCable(TEMarineCablePO cablePO, String buName) {
        String buNameOther = null;
        if (null == buName) {
            if (0 != cablePO.getSrcType()) {
                buNameOther = cablePO.getSrcNodeName();
            }
            if (0 != cablePO.getSinkType()) {
                buNameOther = cablePO.getSinkNodeName();
            }
        } else {
            if (0 != cablePO.getSrcType() && !buName.equals(cablePO.getSrcNodeName())) {
                buNameOther = cablePO.getSrcNodeName();
            }
            if (0 != cablePO.getSinkType() && !buName.equals(cablePO.getSinkNodeName())) {
                buNameOther = cablePO.getSinkNodeName();
            }
        }
        if (null == buNameOther) {
            return null;
        }
        return this.getMarineBUByName(buNameOther);
    }

    private boolean isEarthOtherBUPortbyCable(TEMarineCablePO cablePO, String buName) {
        TEBUPortPO buPortPO = this.getOtherBUPortPObyCable(cablePO, buName);
        if (null == buPortPO) {
            return true;
        }
        return 1 == buPortPO.getIsEarth();
    }

    private TEBUPortPO getOtherBUPortPO(TEMarineBUPO marineBUPO, TEBUPortPO buPortPO) {
        if (null == buPortPO) {
            return null;
        }
        for (TEBUPortPO buPort : marineBUPO.getPortList()) {
            if (buPortPO.getPortName().equals(buPort.getPortName()) || 1 == buPort.getIsEarth()) continue;
            return buPort;
        }
        return null;
    }

    private TEBUPortPO getBUPortPO(TEMarineBUPO marineBUPO, String buPortName) {
        if (null == buPortName) {
            return null;
        }
        for (TEBUPortPO buPort : marineBUPO.getPortList()) {
            if (!buPortName.equals(buPort.getPortName())) continue;
            return buPort;
        }
        return null;
    }

    private void calcMarineRouteDetal(TEMarineCablePO startCable) {
        int sinkType = startCable.getSinkType();
        if (0 == sinkType) {
            return;
        }
        List<TEMarineCablePO> tmpCableList = this.getStartCableList(startCable);
        tmpCableList.add(startCable);
        String buName = startCable.getSinkNodeName();
        String buPortName = startCable.getSinkBuPortName();
        TEMarineBUPO marineBU = this.getMarineBUByName(buName);
        if (null == marineBU) {
            return;
        }
        for (TEBUPortPO buPortPO : marineBU.getPortList()) {
            if (buPortName.equals(buPortPO.getPortName())) continue;
            this.calcMarineRouteDetal(this.getCablePOByBUInfo(buName, buPortPO.getPortName()));
        }
    }

    private List<TEMarineCablePO> getStartCableList(TEMarineCablePO startCable) {
        ArrayList<TEMarineCablePO> tmpCableList = null;
        if (0 == startCable.getSrcType()) {
            tmpCableList = new ArrayList<TEMarineCablePO>();
            return tmpCableList;
        }
        return this.getStartCableListDetail(startCable);
    }

    private List<TEMarineCablePO> getStartCableListDetail(TEMarineCablePO startCable) {
        String buName = startCable.getSrcNodeName();
        String buPortName = startCable.getSrcStationName();
        TEMarineBUPO marineBU = this.getMarineBUByName(buName);
        TEBUPortPO marineBUPort = this.getMarineBUPortByName(buPortName, marineBU);
        ArrayList<TEMarineCablePO> tmpCableList = null;
        if (1 == marineBUPort.getIsEarth()) {
            tmpCableList = new ArrayList<TEMarineCablePO>();
            return tmpCableList;
        }
        String mainRouteBUPortName = this.getBUMarineRoutePort(marineBU, buPortName);
        return this.getCablePOListByBUInfo(buName, mainRouteBUPortName);
    }

    private String getBUMarineRoutePort(TEMarineBUPO marineBU, String sidePortName) {
        String tmpPortName = null;
        for (TEBUPortPO buPort : marineBU.getPortList()) {
            tmpPortName = buPort.getPortName();
            if (sidePortName.equals(tmpPortName) || 1 == buPort.getIsEarth()) continue;
            return tmpPortName;
        }
        return tmpPortName;
    }

    private List<TEMarineCablePO> getCablePOListByCable(TEMarineCablePO cableInfo) {
        if (null == cableInfo) {
            return null;
        }
        for (List<TEMarineCablePO> tmpList : this.marineCableInfoList) {
            for (TEMarineCablePO tmpCablePO : tmpList) {
                if (!cableInfo.equals(tmpCablePO)) continue;
                return tmpList;
            }
        }
        return null;
    }

    private List<TEMarineCablePO> getCablePOListByBUInfo(String buName, String buPortName) {
        for (List<TEMarineCablePO> tmpList : this.marineCableInfoList) {
            for (TEMarineCablePO tmpCablePO : tmpList) {
                if (!this.isCableContainBUInfo(tmpCablePO, buName, buPortName)) continue;
                return tmpList;
            }
        }
        return null;
    }

    private TEMarineCablePO getCablePOByBUInfo(String buName, String buPortName) {
        for (List<TEMarineCablePO> tmpList : this.marineCableInfoList) {
            for (TEMarineCablePO tmpCablePO : tmpList) {
                if (!this.isCableContainBUInfo(tmpCablePO, buName, buPortName)) continue;
                return tmpCablePO;
            }
        }
        return null;
    }

    private List<TEMarineCablePO> getCableListByBUInfo(String buName, String buPortName) {
        for (List<TEMarineCablePO> tmpList : this.marineCableInfoList) {
            for (TEMarineCablePO tmpCablePO : tmpList) {
                if (!this.isCableContainBUInfo(tmpCablePO, buName, buPortName)) continue;
                return tmpList;
            }
        }
        return null;
    }

    private TEMarineCablePO getCablePOByBUPort(String buName, String buPortName) {
        for (TEMarineCablePO tmpCablePO : this.cableList) {
            if (!this.isCableContainBUInfo(tmpCablePO, buName, buPortName)) continue;
            return tmpCablePO;
        }
        return null;
    }

    private boolean isCableContainBUInfo(TEMarineCablePO tmpCablePO, String buName, String buPortName) {
        boolean ret = false;
        if (0 != tmpCablePO.SrcType) {
            boolean bl = ret = buName.equals(tmpCablePO.getSrcNodeName()) && buPortName.equals(tmpCablePO.getSrcBuPortName());
        }
        if (0 != tmpCablePO.SinkType) {
            ret = ret || buName.equals(tmpCablePO.getSinkNodeName()) && buPortName.equals(tmpCablePO.getSinkBuPortName());
        }
        return ret;
    }

    private TEBUPortPO getMarineBUPortByName(String portName, TEMarineBUPO marineBU) {
        if (null == portName || portName.isEmpty()) {
            return null;
        }
        for (TEBUPortPO buPort : marineBU.getPortList()) {
            if (!portName.equals(buPort.getPortName())) continue;
            return buPort;
        }
        return null;
    }

    private TEMarineBUPO getMarineBUByName(String buName) {
        if (null == buName || buName.isEmpty()) {
            return null;
        }
        for (TEMarineBUPO marineBU : this.buList) {
            if (!buName.equals(marineBU.getBuName())) continue;
            return marineBU;
        }
        return null;
    }

    private TEMarineCTBPO getMarineCTBByName(String ctbName) {
        if (null == ctbName || ctbName.isEmpty()) {
            return null;
        }
        for (TEMarineCTBPO marineCTB : this.ctbList) {
            if (!ctbName.equals(marineCTB.getName())) continue;
            return marineCTB;
        }
        return null;
    }

    private TEMarineCablePO getStartCable() {
        for (TEMarineCablePO cableInfo : this.cableList) {
            if (0 != cableInfo.getSrcType()) continue;
            return cableInfo;
        }
        return null;
    }

    private TEMarineCablePO getControlUnitCable() {
        for (TEMarineCablePO cableInfo : this.cableList) {
            if (0 == cableInfo.getSrcType() && this.isControlUnitCable(cableInfo)) {
                return cableInfo;
            }
            if (0 != cableInfo.getSinkType() || !this.isControlUnitCable(cableInfo)) continue;
            return cableInfo;
        }
        return null;
    }

    private boolean isControlUnitCable(TEMarineCablePO cableInfo) {
        if (null == cableInfo) {
            return false;
        }
        for (TECableBondLinePO linePO : cableInfo.getBONDLineList()) {
            if (this.lineID != linePO.getLineId() || (long)this.controlUnit != linePO.getSrcNeID() && (long)this.controlUnit != linePO.getSnkNeID()) continue;
            return true;
        }
        return false;
    }

    private int doQueryBUInfo() {
        this.buList.clear();
        TEBUDataOperationInterface dataBaseService = TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts() ? new TEBUDataBaseOperService() : new TEBUDataFileOperService();
        return dataBaseService.queryAllBUInfo(this.buList);
    }

    private int doQueryCableInfo() {
        this.cableList.clear();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            TEMarineCablePO cablePO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                cablePO = (TEMarineCablePO)obj;
                this.cableList.add(cablePO);
            }
        }
        return retCode;
    }

    private int doQueryCTBInfo() {
        this.ctbList.clear();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            TEMarineStationPO stationPO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                stationPO = (TEMarineStationPO)obj;
                this.ctbList.addAll(stationPO.getCTBList());
            }
        }
        return retCode;
    }

    private int doQueryStationInfo() {
        this.stationList.clear();
        TEDaoOperationResult dbResult1 = null;
        try {
            dbResult1 = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
            return 2;
        }
        int retCode = dbResult1.getResult();
        if (0 == retCode) {
            TEMarineStationPO stationPO = null;
            List data = dbResult1.getData();
            for (Object obj : data) {
                stationPO = (TEMarineStationPO)obj;
                this.stationList.add(stationPO);
            }
        }
        return retCode;
    }
}

