/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnStrList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUForTOPO;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineCalcBUsVoltageReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineCalcBUsVoltageRsp;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataFileOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.bue2e.TEBUOperForMarineTopo;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineBUAndTypePair;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineCalcBUVoltageData;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEBUASN1Commond;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUVoltageUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEMarineBUUtil {
    private TEMarineBUUtil() {
    }

    public static void calcBUE2EPos(TEMarineBUPO buPo) {
        if (TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_INTEGRATION_STATUS) {
            int[] buPos = new int[]{0, 0};
            buPos = TEBUOperForMarineTopo.calcNewBUDefaultPosition();
            buPo.setPosX(buPos[0]);
            buPo.setPosY(buPos[1]);
            TELogFactory.getNormalLogger().info("Calculate BU default position is " + Arrays.toString(buPos));
        }
    }

    public static void sendMessageToTopo(TEMarineBUPO buPo) {
        if (TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_INTEGRATION_STATUS) {
            AsnMarineBUForTOPO buForTopo = new AsnMarineBUForTOPO();
            buForTopo.buname = buPo.getBuName().getBytes();
            buForTopo.posX = BigInteger.valueOf(buPo.getPosX());
            buForTopo.posY = BigInteger.valueOf(buPo.getPosY());
            TEBUASN1Commond.sendCreateBUMessageToClient(buForTopo);
        }
    }

    public static void sendDelMessageToTopo(List<String> buNameList) {
        if (null == buNameList || buNameList.isEmpty()) {
            return;
        }
        if (TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_INTEGRATION_STATUS) {
            AsnStrList asnBUNameList = new AsnStrList();
            for (String buName : buNameList) {
                asnBUNameList.add((Object)buName.getBytes());
            }
            TEBUASN1Commond.sendDeleteBUMessageToClient(asnBUNameList);
        }
    }

    public static TEBUDataOperationInterface getBUDataOperationHandler() {
        TEBUDataOperationInterface buDataOperService = TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_INTEGRATION_STATUS ? new TEBUDataBaseOperService() : new TEBUDataFileOperService();
        return buDataOperService;
    }

    public static Map<String, String> getPFEPolarityMap(Set<String> pfeNameSet) {
        if (null == pfeNameSet || pfeNameSet.isEmpty()) {
            return null;
        }
        HashMap<String, String> pfePolarityMap = new HashMap<String, String>();
        Iterator<String> pfeNameSetIT = pfeNameSet.iterator();
        while (pfeNameSetIT.hasNext()) {
            TEMarineBUUtil.queryPFEPolarity(pfeNameSetIT.next(), pfePolarityMap);
        }
        return pfePolarityMap;
    }

    private static int queryPFEPolarity(String pfeName, Map<String, String> pfePolarityMap) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        int errCode = 0;
        try {
            TENE pfeNE = TENEListMgr.getInstance().getTL1NEByNEName(pfeName);
            if (null == pfeNE) {
                return 2;
            }
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)pfeNE.getNEID());
            TL1Operation oper = null;
            oper = definitions.getTL1Operation("RTRV-SYS");
            operationList.add(oper);
            int pfeNEID = pfeNE.getNEID();
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(pfeNEID, operationList, 30);
            errCode = result.retCode;
            if (0 == result.retCode) {
                HashMap hm;
                String nePolarity;
                oper = (TL1Operation)operationList.get(0);
                OutMsg outMsg = oper.getOutMsg(0);
                errCode = outMsg.getFault().getCompletionCode();
                if (0 == outMsg.getFault().getCompletionCode() && (nePolarity = ((Part)(hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsg)).get("POLARITY")).getValue()) != null) {
                    pfePolarityMap.put(pfeName, nePolarity);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse parse fail", (Throwable)e);
        }
        return errCode;
    }

    public static boolean isBUbondFullPort(String buName) {
        if (null == buName || buName.isEmpty()) {
            return false;
        }
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        TEBUDataOperationInterface dataBaseService = TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts() ? new TEBUDataBaseOperService() : new TEBUDataFileOperService();
        dataBaseService.queryAllBUInfo(buList);
        TEMarineBUPO marineBUPO = null;
        for (TEMarineBUPO marineBU : buList) {
            if (!buName.equals(marineBU.getBuName())) continue;
            marineBUPO = marineBU;
            break;
        }
        if (null == marineBUPO) {
            return false;
        }
        for (TEBUPortPO buPort : marineBUPO.getPortList()) {
            if (!buPort.getBondPFE().equals("0")) continue;
            return false;
        }
        return true;
    }

    public static TEMarineCalcBUVoltageData getBUVoltage(TEMarineCalcBUVoltageData buVoltageData) {
        TEMarineBUVoltageUtil marineBUVoltageUtil = new TEMarineBUVoltageUtil(buVoltageData);
        return marineBUVoltageUtil.doCalcBUVoltage();
    }

    public static int getBUVoltages(AsnMarineCalcBUsVoltageReq request, AsnMarineCalcBUsVoltageRsp response) {
        TEMarineBUVoltageUtil marineBUVoltageUtil = new TEMarineBUVoltageUtil(request, response);
        return marineBUVoltageUtil.doCalcBUVoltages();
    }

    public static String getBUTypeString(int buType) {
        switch (buType) {
            case 1: {
                return "OADM BU";
            }
            case 2: {
                return "FP BU";
            }
        }
        return "-";
    }

    public static Set<TEMarineBUAndTypePair> getBUAndTypeList() {
        ArrayList<TEMarineBUPO> buSet;
        HashSet<TEMarineBUAndTypePair> buAndTypeSet = new HashSet<TEMarineBUAndTypePair>();
        TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
        int ret = buDataOperService.queryAllBUInfo(buSet = new ArrayList<TEMarineBUPO>());
        if (0 == ret) {
            for (TEMarineBUPO bu : buSet) {
                TEMarineBUAndTypePair buAndTypePair = new TEMarineBUAndTypePair();
                buAndTypePair.setBuName(bu.getBuName());
                buAndTypePair.setBuType(bu.getType());
                buAndTypeSet.add(buAndTypePair);
            }
        }
        return buAndTypeSet;
    }

    public static String[] getAvailBUAndTypeInfo() {
        Set<TEMarineBUAndTypePair> buTypeSet = TEMarineBUUtil.getBUAndTypeList();
        StringBuilder buType1SB = new StringBuilder();
        StringBuilder buType2SB = new StringBuilder();
        for (TEMarineBUAndTypePair buTypePair : buTypeSet) {
            if (buTypePair.getBuType() == 1) {
                buType1SB.append(buTypePair.getBuName()).append(",");
                continue;
            }
            buType2SB.append(buTypePair.getBuName()).append(",");
        }
        String buType1 = buType1SB.toString();
        String buType2 = buType2SB.toString();
        buType1 = buType1.endsWith(",") ? buType1.substring(0, buType1.length() - 1) : buType1;
        buType2 = buType2.endsWith(",") ? buType2.substring(0, buType2.length() - 1) : buType2;
        String[] buAndTypeStrs = new String[]{buType1, buType2};
        return buAndTypeStrs;
    }

    public static Map<String, TEMarinePowerSupplyUnitPO> doQueryPSUs() {
        HashMap<String, TEMarinePowerSupplyUnitPO> result = new HashMap<String, TEMarinePowerSupplyUnitPO>();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            int retCode = dbResult.getResult();
            if (0 == retCode) {
                List data = dbResult.getData();
                for (Object obj : data) {
                    TEMarineStationPO stationPO = (TEMarineStationPO)obj;
                    for (TEMarinePowerSupplyUnitPO psu : stationPO.getPSUList()) {
                        result.put(psu.getName(), psu);
                    }
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
        return result;
    }

    public static boolean isSpurTrackPort(TEMarineBUPO bu, String portName) {
        boolean isSpurTrackPoint;
        if (null == bu || null == portName || portName.isEmpty()) {
            isSpurTrackPoint = false;
        } else {
            switch (bu.getPrimaryLine()) {
                case 1: {
                    isSpurTrackPoint = "C".equals(portName);
                    break;
                }
                case 2: {
                    isSpurTrackPoint = "B".equals(portName);
                    break;
                }
                case 3: {
                    isSpurTrackPoint = "A".equals(portName);
                    break;
                }
                default: {
                    isSpurTrackPoint = false;
                }
            }
        }
        return isSpurTrackPoint;
    }
}

