/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.util;

import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineBUPSLocker;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import java.util.ArrayList;
import java.util.List;

public class TEMarineBUPSLockerMgr {
    List<TEMarineBUPSLocker> locker = new ArrayList<TEMarineBUPSLocker>();
    private static TEMarineBUPSLockerMgr instance;
    private static final int SWITCH_MAX_INTERVAL = 1800000;
    private static final int NSERR_MARINE_BU_SWITCH_CONFLICT = 1090615202;

    private TEMarineBUPSLockerMgr() {
    }

    public static synchronized TEMarineBUPSLockerMgr getInstance() {
        if (instance == null) {
            instance = new TEMarineBUPSLockerMgr();
        }
        return instance;
    }

    private synchronized void clearBUPS() {
        this.locker.clear();
    }

    public synchronized boolean isBUPSCanOperation(TEMarineBUPSLocker newLocker, TEMarineBUPO bu) {
        TEMarineBUPSLocker curLocker;
        if (null == bu || null == newLocker) {
            return false;
        }
        boolean isBUPSCanOperation = true;
        if (this.isLongOperInterval(bu)) {
            this.clearBUPS();
        }
        isBUPSCanOperation = this.locker.isEmpty() ? true : (this.locker.size() > 1 ? false : (!(curLocker = this.locker.get(0)).getBuName().equals(bu.getBuName()) ? false : this.locker.contains(newLocker)));
        return isBUPSCanOperation;
    }

    public boolean isLongOperInterval(TEMarineBUPO bu) {
        long lastOperTime = Long.parseLong(bu.getLastOperTime());
        long currTime = System.currentTimeMillis();
        return currTime - lastOperTime > 1800000L;
    }

    public int lockBUPS(TEMarineBUPSLocker newLocker) {
        int errCode = 0;
        if (null == newLocker || "".equals(newLocker.getBuName())) {
            return 1090605056;
        }
        String buName = newLocker.getBuName();
        TEBUDataOperationInterface dataOperService = TEMarineBUUtil.getBUDataOperationHandler();
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        errCode = dataOperService.queryBUInfoByName(buName, buList);
        if (!this.isBUPSCanOperation(newLocker, (TEMarineBUPO)buList.get(0))) {
            errCode = 1090615202;
        } else {
            this.clearBUPS();
            if (!this.locker.contains(newLocker)) {
                this.locker.add(newLocker);
            }
        }
        return errCode;
    }

    public int unlockBUPS(TEMarineBUPSLocker newLocker) {
        int errCode = 0;
        if (!this.locker.contains(newLocker)) {
            errCode = 0;
        }
        this.locker.remove(newLocker);
        return errCode;
    }

    public int doBUPSLockOperation(int operType, TEMarineBUPSLocker newLocker) {
        int errCode = 0;
        errCode = 0 == operType ? TEMarineBUPSLockerMgr.getInstance().lockBUPS(newLocker) : TEMarineBUPSLockerMgr.getInstance().unlockBUPS(newLocker);
        return errCode;
    }
}

