/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBU;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUAndType;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUAndTypeList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUBondLine;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUBondLineList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUPort;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUPortList;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineBUAndTypePair;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TEMarineBUE2EUtil {
    private static TEMarineBUE2EUtil instance = new TEMarineBUE2EUtil();

    private TEMarineBUE2EUtil() {
    }

    public static TEMarineBUE2EUtil getBUE2EUtilInstance() {
        return instance;
    }

    private Set<String> getUsedBUNamesByCable() {
        HashSet<String> usedBUNames = new HashSet<String>();
        ArrayList<TEMarineCablePO> cableList = new ArrayList<TEMarineCablePO>();
        int ret = this.getAllCables(cableList);
        if (0 != ret || null == cableList || cableList.isEmpty()) {
            return usedBUNames;
        }
        for (TEMarineCablePO cablepo : cableList) {
            String buName = cablepo.getSrcNodeName();
            if (!"".equals(buName)) {
                usedBUNames.add(buName);
            }
            if ("".equals(buName = cablepo.getSinkNodeName())) continue;
            usedBUNames.add(buName);
        }
        return usedBUNames;
    }

    public int getAllCables(List<TEMarineCablePO> cableList) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error(e.toString());
            return 1090650120;
        }
        if (null == dbResult) {
            TELogFactory.getNormalLogger().error("When quey all cable data, the dbResult is null!");
            return 1092743443;
        }
        if (0 != dbResult.getResult()) {
            TELogFactory.getNormalLogger().error("Query cable fail, the error code is " + dbResult.getResult());
            return dbResult.getResult();
        }
        if (null != cableList) {
            List data = dbResult.getData();
            for (Object obj : data) {
                cableList.add((TEMarineCablePO)obj);
            }
        }
        return 0;
    }

    public List<String> filtrateUnUsedBUNameList(List<String> buNameList) {
        Set<String> usedBuNameList = this.getUsedBUNamesByCable();
        ArrayList<String> buNamesFiltrated = new ArrayList<String>();
        if (null == usedBuNameList || usedBuNameList.isEmpty() || null == buNameList || buNameList.isEmpty()) {
            return buNamesFiltrated;
        }
        for (int i = buNameList.size() - 1; i >= 0; --i) {
            String buName = buNameList.get(i);
            if (!usedBuNameList.contains(buName)) continue;
            buNamesFiltrated.add(buName);
            buNameList.remove(i);
        }
        return buNamesFiltrated;
    }

    public TEMarineCablePO getUsedCableByBUName(String buName, String buPortName, List<TEMarineCablePO> cableList) {
        TEMarineCablePO cable = null;
        if (null != cableList && !cableList.isEmpty()) {
            for (TEMarineCablePO tmpCable : cableList) {
                if ((1 != tmpCable.SrcType || !tmpCable.SrcNodeName.equals(buName) || !tmpCable.SrcBuPortName.equals(buPortName)) && (1 != tmpCable.SinkType || !tmpCable.SinkNodeName.equals(buName) || !tmpCable.SinkBuPortName.equals(buPortName))) continue;
                cable = tmpCable;
                break;
            }
        }
        return cable;
    }

    public Set<TEBUPortPO> getPortSet(AsnMarineBUPortList asnPortList) {
        HashSet<TEBUPortPO> portSet = new HashSet<TEBUPortPO>();
        if (null != asnPortList && !asnPortList.isEmpty()) {
            int num = asnPortList.size();
            for (int i = 0; i < num; ++i) {
                AsnMarineBUPort asnPort = (AsnMarineBUPort)asnPortList.get(i);
                TEBUPortPO port = new TEBUPortPO();
                port.setPortName(new String(asnPort.portName));
                port.setBondSLM(this.getSLMNEPhyID(new String(asnPort.bondSLM)));
                port.setBondPFE(this.getPFENEName(new String(asnPort.bondPFE)));
                port.setIsEarth(asnPort.isEarth.intValue());
                port.setElecDirection(asnPort.elecDirection.intValue());
                portSet.add(port);
            }
        }
        return portSet;
    }

    public static TEMarineBUPO convertAsn1ToBUPO(AsnMarineBU asnBU) {
        TEMarineBUPO bu = new TEMarineBUPO();
        bu.setBuName(new String(asnBU.buname));
        bu.setType(asnBU.type.intValue());
        bu.setMacAddr(new String(asnBU.macAddr));
        bu.setPressure(asnBU.pressure.intValue());
        bu.setPrimaryLine(asnBU.primaryLine.intValue());
        bu.setLastOperTime(String.valueOf(asnBU.lastOperTime.intValue()));
        bu.setBondLineList(TEMarineBUE2EUtil.getBondLineSet(asnBU.bondLineList));
        bu.setPortList(TEMarineBUE2EUtil.getBUE2EUtilInstance().getPortSet(asnBU.portList));
        TEMarineBUUtil.calcBUE2EPos(bu);
        return bu;
    }

    public static Set<TEBUBondLinePO> getBondLineSet(AsnMarineBUBondLineList asnBondLineList) {
        HashSet<TEBUBondLinePO> bondLineSet = new HashSet<TEBUBondLinePO>();
        if (null != asnBondLineList && !asnBondLineList.isEmpty()) {
            int num = asnBondLineList.size();
            for (int i = 0; i < num; ++i) {
                AsnMarineBUBondLine asnBondLine = (AsnMarineBUBondLine)asnBondLineList.get(i);
                TEBUBondLinePO bondLine = new TEBUBondLinePO();
                int srcPhyid = asnBondLine.srcLineStr.neID.intValue();
                srcPhyid = 0 == srcPhyid ? srcPhyid : TEConfigurationDataMgr.getInstance().getNEID(srcPhyid);
                int snkPhyid = asnBondLine.snkLineStr.neID.intValue();
                snkPhyid = 0 == snkPhyid ? snkPhyid : TEConfigurationDataMgr.getInstance().getNEID(snkPhyid);
                bondLine.setSrcNeID((long)srcPhyid);
                bondLine.setSnkNeID((long)snkPhyid);
                bondLine.setLineId(asnBondLine.lineId.intValue());
                bondLine.setControlPart(asnBondLine.controlPart.intValue());
                bondLineSet.add(bondLine);
            }
        }
        return bondLineSet;
    }

    public String getSLMNEPhyID(String neidStr) {
        if ("-1".equals(neidStr)) {
            return "0";
        }
        String[] neidArr = neidStr.split(",");
        StringBuilder phyNeids = new StringBuilder();
        for (String logicNeid : neidArr) {
            TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(logicNeid));
            if (null == ne) continue;
            phyNeids.append(0 == phyNeids.length() ? "" : ",").append(ne.getRealNEID());
        }
        if (0 == phyNeids.length()) {
            phyNeids.append("0");
        }
        return phyNeids.toString();
    }

    public String getPFENEName(String bondPFEStr) {
        if ("-".equals(bondPFEStr)) {
            return "0";
        }
        return bondPFEStr;
    }

    public TEResourceUtil getLogRes() {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("bumanage").append(File.separator).append("bumgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        return res;
    }

    public AsnMarineBUAndTypeList getAsnBUAndTypeList() {
        Set<TEMarineBUAndTypePair> buAndTypeSet = TEMarineBUUtil.getBUAndTypeList();
        AsnMarineBUAndTypeList asnBUAndTypeList = new AsnMarineBUAndTypeList();
        if (null != buAndTypeSet && !buAndTypeSet.isEmpty()) {
            for (TEMarineBUAndTypePair buAndTypePair : buAndTypeSet) {
                AsnMarineBUAndType asnBUAndType = new AsnMarineBUAndType();
                asnBUAndType.buName = buAndTypePair.getBuName().getBytes();
                asnBUAndType.buType = BigInteger.valueOf(buAndTypePair.getBuType());
                asnBUAndTypeList.add((Object)asnBUAndType);
            }
        }
        return asnBUAndTypeList;
    }
}

