/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TEBUPFEOperations {
    private TEBUPFEOperations() {
    }

    public static int reBindPFE(TEMarineBUPO bu) {
        int ret = 0;
        if (null == bu || bu.getBindPFEMap().isEmpty()) {
            return ret;
        }
        Map bindPFEMap = bu.getBindPFEMap();
        Iterator pfeMapIt = bindPFEMap.entrySet().iterator();
        ArrayList<TEMarineCablePO> cableList = new ArrayList<TEMarineCablePO>();
        ret = TEMarineBUE2EUtil.getBUE2EUtilInstance().getAllCables(cableList);
        if (0 == ret && !cableList.isEmpty()) {
            String buName = bu.getBuName();
            String bindPFEName = "";
            String linkPortName = "";
            while (pfeMapIt.hasNext()) {
                Map.Entry entry = pfeMapIt.next();
                linkPortName = TEBUPFEOperations.getLinkedBUPortName(bu, (String)entry.getKey());
                bindPFEName = 1 == bu.getPortByName(linkPortName).getIsEarth() ? "SE" : (String)entry.getValue();
                ret = TEBUPFEOperations.resetBindingPFE(buName, linkPortName, bindPFEName, cableList);
            }
        }
        return ret;
    }

    private static String getLinkedBUPortName(TEMarineBUPO bu, String curPortName) {
        int primaryLine = bu.getPrimaryLine();
        String linkedPortName = curPortName;
        switch (primaryLine) {
            case 1: {
                String primaryPort0 = "A";
                String primaryPort1 = "B";
                if (!curPortName.equals(primaryPort0) && !curPortName.equals(primaryPort1)) break;
                linkedPortName = curPortName.equals(primaryPort0) ? primaryPort1 : primaryPort0;
                break;
            }
            case 2: {
                String primaryPort0 = "A";
                String primaryPort1 = "C";
                if (!curPortName.equals(primaryPort0) && !curPortName.equals(primaryPort1)) break;
                linkedPortName = curPortName.equals(primaryPort0) ? primaryPort1 : primaryPort0;
                break;
            }
            case 3: {
                String primaryPort0 = "B";
                String primaryPort1 = "C";
                if (!curPortName.equals(primaryPort0) && !curPortName.equals(primaryPort1)) break;
                linkedPortName = curPortName.equals(primaryPort0) ? primaryPort1 : primaryPort0;
                break;
            }
            case 0: {
                break;
            }
            default: {
                linkedPortName = "";
            }
        }
        return linkedPortName;
    }

    private static int resetBindingPFE(String buName, String linkedPortName, String pfeName, List<TEMarineCablePO> cableList) {
        int queryRst = 0;
        TEMarineCablePO cable = TEMarineBUE2EUtil.getBUE2EUtilInstance().getUsedCableByBUName(buName, linkedPortName, cableList);
        if (null != cable && 1 == cable.SrcType && 1 == cable.SinkType) {
            TEMarineBUPO oppBU;
            TEBUPortPO oppPort;
            ArrayList<TEMarineBUPO> buSet;
            String oppBuName = cable.SrcNodeName.equals(buName) && cable.SrcBuPortName.equals(linkedPortName) ? cable.SinkNodeName : cable.SrcNodeName;
            String oppPortName = cable.SrcNodeName.equals(buName) && cable.SrcBuPortName.equals(linkedPortName) ? cable.SinkBuPortName : cable.SrcBuPortName;
            TEBUDataOperationInterface buOperSrv = TEMarineBUUtil.getBUDataOperationHandler();
            queryRst = buOperSrv.queryBUInfoByName(oppBuName, buSet = new ArrayList<TEMarineBUPO>());
            if (0 == queryRst && !buSet.isEmpty() && null != (oppPort = (oppBU = (TEMarineBUPO)buSet.get(0)).getPortByName(oppPortName))) {
                String linkPortName;
                oppPort.setBondPFE(pfeName);
                queryRst = buOperSrv.updateBUInfo(oppBU);
                if (0 == queryRst && !(linkPortName = TEBUPFEOperations.getLinkedBUPortName(oppBU, oppPortName)).equals(oppPortName)) {
                    TEBUPFEOperations.resetBindingPFE(oppBuName, linkPortName, pfeName, cableList);
                }
            }
        }
        return queryRst;
    }

    public static int getPFEVoltageHandler(String pfeName, Map pfeMap) {
        int uncommunite = 0;
        int pfeVoltage = 0;
        int pfeCurrent = 0;
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        int pfeNEID = TETL1NECommMgr.getInstance().getLogicNEID(pfeName);
        TENE phyPFENE = TENEListMgr.getInstance().getNE(pfeNEID);
        if (null == phyPFENE || uncommunite == phyPFENE.getComStarus()) {
            TELogFactory.getNormalLogger().info("BUSwitch:TEMarineBUVoltageUtil::getPFEVoltageHandler() isConnect false");
            TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + pfeNEID + " failed! uncommunite failed");
            return 2;
        }
        pfeMap.put("pfeNEID", BigInteger.valueOf(pfeNEID));
        pfeMap.put("pfeName", pfeName);
        boolean isConnect = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(pfeNEID);
        if (!isConnect) {
            TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + pfeNEID + " failed! SBI connect failed");
            return 2;
        }
        try {
            HashMap hm;
            OutMsg outMsg;
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)pfeNEID);
            TL1Operation oper1 = null;
            oper1 = definitions.getTL1Operation("RTRV-SYS");
            operationList.add(oper1);
            TL1Operation oper2 = null;
            oper2 = definitions.getTL1Operation("RTRV-PM-EQPT");
            InMsg inputMsg1 = oper2.getInMsg();
            MsgBlock msgblock1 = inputMsg1.getMsgBlock();
            msgblock1.getPart("tmper").setValue("15-MIN");
            StringBuffer sb1 = new StringBuffer();
            sb1.append("SLOT-5");
            inputMsg1.getPart("aid").setValue(sb1.toString());
            operationList.add(oper2);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(pfeNEID, operationList, 20);
            if (0 != result.retCode) {
                TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + pfeNEID + " failed! Result code is " + result);
                return 2;
            }
            String pfeVoltageStr = null;
            String pfeCurrentStr = null;
            oper2 = (TL1Operation)operationList.get(1);
            int len = oper2.getOutMsgCount();
            for (int index = 0; index < len; ++index) {
                outMsg = oper2.getOutMsg(index);
                if (0 != outMsg.getFault().getCompletionCode()) {
                    TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + pfeNEID + " failed! Result CompletionCode is " + outMsg.getFault().getCompletionCode());
                    continue;
                }
                hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsg);
                String tmpValue = ((Part)hm.get("montype")).getValue();
                if ("PFEVOL-CUR".equals(tmpValue)) {
                    pfeVoltageStr = ((Part)hm.get("monval")).getValue();
                    if (null == pfeVoltageStr || pfeVoltageStr.isEmpty()) continue;
                    pfeVoltage = Integer.valueOf(pfeVoltageStr);
                    continue;
                }
                if (!"PFECV-CUR".equals(tmpValue) || null == (pfeCurrentStr = ((Part)hm.get("monval")).getValue()) || pfeCurrentStr.isEmpty()) continue;
                pfeCurrent = Integer.valueOf(pfeCurrentStr);
            }
            if (null == pfeVoltageStr || null == pfeCurrentStr) {
                TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + pfeNEID + " failed! nePolarity/pfeVoltageStr/pfeCurrentStr is null");
                return 2;
            }
            oper1 = (TL1Operation)operationList.get(0);
            outMsg = oper1.getOutMsg(0);
            if (0 != outMsg.getFault().getCompletionCode()) {
                TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + pfeNEID + " failed! Result CompletionCode is " + outMsg.getFault().getCompletionCode());
                return 0;
            }
            hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsg);
            String nePolarity = ((Part)hm.get("POLARITY")).getValue();
            if (nePolarity != null && nePolarity.equals("N")) {
                pfeVoltage = 0 - pfeVoltage;
            }
            pfeMap.put("pfeVoltage", BigInteger.valueOf(pfeVoltage));
            pfeMap.put("pfeCurrent", BigInteger.valueOf(pfeCurrent));
            pfeMap.put("polarity", nePolarity);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + pfeNEID + " failed! ", (Throwable)e);
            return 2;
        }
        return 0;
    }
}

