/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.util;

import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnStrList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnCreateBUMessageNtfToC;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnDeleteBUMessageNtfToC;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUForTOPO;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnSwitchBUMessageNtfToC;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMSwitchBUStatus;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;

public final class TEBUASN1Commond {
    private TEBUASN1Commond() {
    }

    public static void sendCreateBUMessageToClient(AsnMarineBUForTOPO buForTopo) {
        if (null == buForTopo) {
            return;
        }
        AsnCreateBUMessageNtfToC createBuMessage = new AsnCreateBUMessageNtfToC();
        createBuMessage.buInfo = buForTopo;
        TEASN1CommMgr.sendEventClient((FStruct)createBuMessage, (int)2179317);
        TELogFactory.getNormalLogger().info("Send create BU message to client----" + TEAsn1Util.getAsn1String((Object)createBuMessage));
    }

    public static void sendDeleteBUMessageToClient(AsnStrList asnBUNameList) {
        if (null == asnBUNameList || asnBUNameList.isEmpty()) {
            return;
        }
        AsnDeleteBUMessageNtfToC deleteBuMessage = new AsnDeleteBUMessageNtfToC();
        deleteBuMessage.bunameList = asnBUNameList;
        TEASN1CommMgr.sendEventClient((FStruct)deleteBuMessage, (int)2179332);
        TELogFactory.getNormalLogger().info("Send delete BU message to client----" + TEAsn1Util.getAsn1String((Object)deleteBuMessage));
    }

    public static void sendSwitchBUResultMessageToClient(TESLMSwitchBUStatus buStatus) {
        if (null == buStatus) {
            TELogFactory.getNormalLogger().info("Send switch BU result message to client fail! buStatus is null!");
            return;
        }
        AsnSwitchBUMessageNtfToC switchBUMessage = new AsnSwitchBUMessageNtfToC();
        switchBUMessage.buName = buStatus.getBuName().getBytes();
        switchBUMessage.macAddr = buStatus.getBuAddr().getBytes();
        switchBUMessage.lineID = BigInteger.valueOf(buStatus.getLineID());
        switchBUMessage.switchMode = BigInteger.valueOf(buStatus.getSwitchMode());
        switchBUMessage.confStatusBefore = BigInteger.valueOf(buStatus.getConfStatusBefore());
        switchBUMessage.confStatusAfter = BigInteger.valueOf(buStatus.getConfStatusAfter());
        switchBUMessage.step = BigInteger.valueOf(buStatus.getStep());
        switchBUMessage.sendCommandTime = BigInteger.valueOf(buStatus.getSendCommandTime());
        switchBUMessage.errorCode = BigInteger.valueOf(buStatus.getErrCode());
        switchBUMessage.slotid = BigInteger.valueOf(buStatus.getErrSlotID());
        switchBUMessage.boardCommandCode = BigInteger.valueOf(buStatus.getBoardCommandCode());
        TEASN1CommMgr.sendEventClient((FStruct)switchBUMessage, (int)2179515);
        TELogFactory.getNormalLogger().info("Send switch BU message to client----" + TEAsn1Util.getAsn1String((Object)switchBUMessage));
    }
}

