/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.scriptoperation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TEMarineBUMgrHandler
implements TEScriptHandler {
    private static final String BUNAME = "buname";
    private static final String BUTYPE = "butype";
    private static final String BUADDRESS = "buaddress";
    private static final String BUPRESSURE = "pressure";
    private static final String PRIMARYLINE = "primaryline";
    private static final String LASTOPERTIME = "lastopertime";
    private static final String POSX = "posx";
    private static final String POSY = "posy";
    private static final String PORTNAME = "port";
    private static final String BONDLING = "bondline";
    private static final String SEPARATE_TAG = "&";
    private static final int NETYPE_PFE = 72;
    private static final int NETYPE_SLM1630 = 61;
    private static final int NETYPE_BWS1600S = 56;
    private static final int NETYPE_BWS1600ST16 = 96;

    public int doExport(int neID, int item) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (!TENEListMgr.getInstance().isAddedNE(neID) || null == ne) {
            return 0;
        }
        int neType = ne.getNEType();
        if (72 != neType && 61 != neType && 56 != neType && 96 != neType) {
            return 1090613252;
        }
        int result = -1;
        TEBUDataBaseOperService dataServer = new TEBUDataBaseOperService();
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        try {
            result = dataServer.queryAllBUInfo(buList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEMarineBUMgrHandler.doExport() fail!", (Throwable)e);
        }
        if (null == buList || buList.isEmpty() || 0 != result) {
            return result;
        }
        ArrayList<TEScriptCmd> cs = new ArrayList<TEScriptCmd>();
        for (TEMarineBUPO bu : buList) {
            TEScriptCmd cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            cmd.addPara(BUNAME, bu.getBuName(), true, true);
            cmd.addPara(BUTYPE, bu.getType(), false, false);
            cmd.addPara(BUADDRESS, bu.getMacAddr(), true, true);
            cmd.addPara(BUPRESSURE, bu.getPressure(), false, false);
            cmd.addPara(PRIMARYLINE, bu.getPrimaryLine(), false, false);
            cmd.addPara(LASTOPERTIME, String.valueOf(bu.getLastOperTime()), false, false);
            cmd.addPara(POSX, bu.getPosX(), false, false);
            cmd.addPara(POSY, bu.getPosY(), false, false);
            Set buportSet = bu.getPortList();
            this.addPortInfo(buportSet, cmd);
            Set bondLineSet = bu.getBondLineList();
            this.addBondLineInfo(bondLineSet, cmd);
            cs.add(cmd);
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private void addPortInfo(Set<TEBUPortPO> buportSet, TEScriptCmd cmd) {
        StringBuilder portInfo = new StringBuilder();
        for (TEBUPortPO buport : buportSet) {
            portInfo.setLength(0);
            String portname = PORTNAME + buport.getPortName();
            portInfo.append("\"").append(buport.getBondSLM()).append(SEPARATE_TAG);
            portInfo.append(buport.getBondPFE()).append(SEPARATE_TAG);
            portInfo.append(buport.getIsEarth()).append(SEPARATE_TAG);
            portInfo.append(buport.getElecDirection()).append("\"");
            cmd.addPara(portname, portInfo.toString(), false, true);
        }
    }

    private void addBondLineInfo(Set<TEBUBondLinePO> bondLineSet, TEScriptCmd cmd) {
        StringBuilder bondLineBuilder = new StringBuilder();
        String bondLineName = BONDLING;
        for (TEBUBondLinePO bondLine : bondLineSet) {
            bondLineBuilder.append(bondLine.getLineId());
            bondLineBuilder.append("-");
            bondLineBuilder.append(bondLine.getControlPart());
            bondLineBuilder.append("-");
            bondLineBuilder.append(bondLine.getSrcNeID());
            bondLineBuilder.append("-");
            bondLineBuilder.append(bondLine.getSnkNeID());
            bondLineBuilder.append("-");
            bondLineBuilder.append(SEPARATE_TAG);
        }
        cmd.addPara(bondLineName, bondLineBuilder.toString(), true, true);
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        if (null == contents || contents.isEmpty()) {
            return 0;
        }
        TEBUDataBaseOperService dataServer = new TEBUDataBaseOperService();
        ArrayList<TEMarineBUPO> existBuList = new ArrayList<TEMarineBUPO>();
        int result = 0;
        try {
            dataServer.queryAllBUInfo(existBuList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEMarineBUMgrHandler.doImport() fail!", (Throwable)e);
        }
        ArrayList tl = new ArrayList();
        HashSet<TEBUPortPO> buPortSet = new HashSet<TEBUPortPO>();
        Set<TEBUBondLinePO> buBondLineSet = null;
        for (TEScriptCmd cmd : contents) {
            tl.clear();
            TEMarineBUPO bu = new TEMarineBUPO();
            cmd.getPara(BUNAME, tl, false);
            bu.setBuName((String)tl.get(0));
            if (null != existBuList && existBuList.contains(bu)) continue;
            tl.clear();
            cmd.getPara(BUTYPE, tl, false);
            bu.setType(Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara(BUADDRESS, tl, false);
            bu.setMacAddr((String)tl.get(0));
            tl.clear();
            cmd.getPara(BUPRESSURE, tl, false);
            bu.setPressure(Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara(PRIMARYLINE, tl, false);
            bu.setPrimaryLine(Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara(LASTOPERTIME, tl, false);
            bu.setLastOperTime((String)tl.get(0));
            tl.clear();
            cmd.getPara(POSX, tl, false);
            bu.setPosX(Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara(POSY, tl, false);
            bu.setPosY(Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara("portA", tl, false);
            TEBUPortPO port = this.getPort("A", (String)tl.get(0));
            buPortSet.add(port);
            tl.clear();
            cmd.getPara("portB", tl, false);
            port = this.getPort("B", (String)tl.get(0));
            buPortSet.add(port);
            tl.clear();
            cmd.getPara("portC", tl, false);
            port = this.getPort("C", (String)tl.get(0));
            buPortSet.add(port);
            bu.setPortList(buPortSet);
            tl.clear();
            cmd.getPara(BONDLING, tl, false);
            buBondLineSet = this.getBUBondLines((String)tl.get(0));
            bu.setBondLineList(buBondLineSet);
            try {
                result = dataServer.createBUInfo(bu);
                if (0 != result) continue;
                TEMarineBUUtil.sendMessageToTopo(bu);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEMarineBUMgrHandler.doImport() fail!", (Throwable)e);
            }
        }
        return result;
    }

    private TEBUPortPO getPort(String portName, String portStr) {
        TEBUPortPO port = new TEBUPortPO();
        port.setPortName(portName);
        String[] portInfos = portStr.split(SEPARATE_TAG);
        port.setBondSLM(this.getBondSlmStr(null == portInfos[0] ? "0" : portInfos[0]));
        String bondpfe = null == portInfos[1] ? "0" : portInfos[1];
        TENE ne = TENEListMgr.getInstance().getTL1NEByNEName(bondpfe);
        if (!"0".equals(bondpfe) && !"SE".equals(bondpfe) && null != ne && 72 != ne.getNEType()) {
            bondpfe = "0";
        }
        port.setBondPFE(bondpfe);
        int isEarth = null == portInfos[2] ? 0 : Integer.valueOf(portInfos[2]);
        port.setIsEarth(isEarth);
        int elecDirection = null == portInfos[3] ? 0 : Integer.valueOf(portInfos[3]);
        port.setElecDirection(elecDirection);
        return port;
    }

    private String getBondSlmStr(String portStr) {
        String[] portStrArr = portStr.split(",");
        StringBuffer bondSlmStr = new StringBuffer();
        for (String slmStr : portStrArr) {
            int bondslm = Integer.parseInt(slmStr);
            TENE ne = TENEListMgr.getInstance().getPhyNE(bondslm);
            if (0 != bondslm && null != ne && 61 != ne.getNEType()) {
                bondslm = -1;
            }
            if (-1 == bondslm || 0 == bondslm) continue;
            if (!"".equals(bondSlmStr.toString())) {
                bondSlmStr.append(",");
            }
            bondSlmStr.append(String.valueOf(bondslm));
        }
        if ("".equals(bondSlmStr.toString())) {
            bondSlmStr.append("0");
        }
        return bondSlmStr.toString();
    }

    private Set<TEBUBondLinePO> getBUBondLines(String bondLineStr) {
        HashSet<TEBUBondLinePO> bondLineSet = new HashSet<TEBUBondLinePO>();
        if (null != bondLineStr && 0 != bondLineStr.length()) {
            String[] bondLineInfos;
            for (String abondString : bondLineInfos = bondLineStr.split(SEPARATE_TAG)) {
                if (0 == abondString.length() || !abondString.contains("-")) continue;
                String[] buattr = abondString.split("-");
                TEBUBondLinePO bondLine = new TEBUBondLinePO();
                bondLine.setLineId(Integer.valueOf(buattr[0]).intValue());
                bondLine.setControlPart(Integer.valueOf(buattr[1]).intValue());
                bondLine.setSrcNeID((long)Integer.parseInt(buattr[2]));
                bondLine.setSnkNeID((long)Integer.parseInt(buattr[3]));
                bondLineSet.add(bondLine);
            }
        }
        return bondLineSet;
    }
}

