/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEBUSwitchNoticeHandler;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMSwitchBUStatus;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public final class TESLMBUDataMgr {
    private static final String NSEVT_SLM_BU_SWITCH_CMD_SEND_FAIL = "NSEVT_SLM_BU_SWITCH_CMD_SEND_FAIL";
    private static final String NSEVT_SLM_BU_SWITCH_CMD_SEND_SUCCESS = "NSEVT_SLM_BU_SWITCH_CMD_SEND_SUCCESS";
    private static final String EVT_DES_PATH = "conf" + File.separator + "eventqxdescrib.xml";
    private static final TEBUSwitchNoticeHandler handler = new TEBUSwitchNoticeHandler();
    private static Map<String, TESLMSwitchBUStatus> switchBUMap = new HashMap<String, TESLMSwitchBUStatus>();
    private static final Logger log = TELogFactory.getNormalLogger();
    private static TESLMBUDataMgr instance = new TESLMBUDataMgr();

    private TESLMBUDataMgr() {
    }

    public static synchronized TESLMBUDataMgr getInstance() {
        return instance;
    }

    public synchronized void initBUDataMgr() {
        this.registerNoticeHandler();
    }

    private void registerNoticeHandler() {
        try {
            TENECommMgr instance = TENECommMgr.getInstance();
            if (null == instance) {
                log.info("MARINE ---- failed to initialize TENECommMgr instance. abort to register events");
                return;
            }
            Definitions definitions = TECreateObjectFactory.parseQxDesFile(null, (String)EVT_DES_PATH);
            Operation operation = definitions.getOperation(NSEVT_SLM_BU_SWITCH_CMD_SEND_FAIL);
            if (null != operation) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_BU_SWITCH_CMD_SEND_SUCCESS))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("TESLMBUDataMgr.registerNoticeHandler() MarshalException!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("TESLMBUDataMgr.registerNoticeHandler() FileNotFoundException!", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("TESLMBUDataMgr.registerNoticeHandler() ValidationException!", (Throwable)e);
        }
    }

    public synchronized void refreshSwitchState(TESLMSwitchBUStatus buStatus) {
        if (null == buStatus) {
            log.info("Marine------ refresh switch BU status fail! The buStatus is null!");
            return;
        }
        TESLMSwitchBUStatus oldBUStatus = this.getBUSwitchStatusByAddr(buStatus.getBuAddr());
        if (null == oldBUStatus) {
            log.info("Marine------ refresh switch BU cash status fail! Can not find the bu which address is " + buStatus.getBuAddr());
        } else {
            oldBUStatus.setErrCode(buStatus.getErrCode());
            oldBUStatus.setErrSlotID(buStatus.getErrSlotID());
            oldBUStatus.setSendCommandTime(buStatus.getSendCommandTime());
            oldBUStatus.setBoardCommandCode(buStatus.getBoardCommandCode());
        }
        this.resetBULastOperTime(buStatus.getBuAddr(), buStatus.getErrCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TESLMSwitchBUStatus getBUSwitchStatusByAddr(String buAddr) {
        Map<String, TESLMSwitchBUStatus> map = switchBUMap;
        synchronized (map) {
            Iterator<Map.Entry<String, TESLMSwitchBUStatus>> it = switchBUMap.entrySet().iterator();
            while (it.hasNext()) {
                TESLMSwitchBUStatus buStatus = it.next().getValue();
                if (!buStatus.getBuAddr().equalsIgnoreCase(buAddr)) continue;
                return buStatus;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TESLMSwitchBUStatus getBUSwitchStatus(String buName) {
        TESLMSwitchBUStatus buStatus;
        Map<String, TESLMSwitchBUStatus> map = switchBUMap;
        synchronized (map) {
            buStatus = switchBUMap.get(buName);
        }
        return buStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBUSwitchStatus(String buName, TESLMSwitchBUStatus buStatus) {
        if (null == buName || "".equals(buName) || null == buStatus) {
            log.info("Marine----- fail to put bu switdh status info!");
            return;
        }
        Map<String, TESLMSwitchBUStatus> map = switchBUMap;
        synchronized (map) {
            switchBUMap.put(buName, buStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TESLMSwitchBUStatus removeBUSwitchStatus(String buName) {
        TESLMSwitchBUStatus buStatus;
        Map<String, TESLMSwitchBUStatus> map = switchBUMap;
        synchronized (map) {
            buStatus = switchBUMap.remove(buName);
        }
        return buStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBUSwitchMap() {
        Map<String, TESLMSwitchBUStatus> map = switchBUMap;
        synchronized (map) {
            switchBUMap.clear();
        }
    }

    private void resetBULastOperTime(String buAddress, int errCode) {
        TEBUDataOperationInterface operService;
        TEMarineBUPO bu;
        if (0 == errCode && null != (bu = (operService = TEMarineBUUtil.getBUDataOperationHandler()).getBUInfoByAddress(buAddress))) {
            bu.setLastOperTime(String.valueOf(System.currentTimeMillis()));
            operService.updateBUInfo(bu);
        }
    }
}

