/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMBUDataMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMSwitchBUStatus;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEBUASN1Commond;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import org.slf4j.Logger;

public class TEBUSwitchNoticeHandler
implements NoticeHandler {
    public static final int NSEVT_SLM_BU_SWITCH_CMD_SEND_FAIL = 18452;
    public static final int NSEVT_SLM_BU_SWITCH_CMD_SEND_SUCCESS = 18453;
    private static final Logger log = TELogFactory.getNormalLogger();

    public void handleNotice(int cmdKey, int neID, Operation oper) {
        switch (cmdKey) {
            case 18452: 
            case 18453: {
                this.processSwitchResultNotice(neID, oper);
                break;
            }
        }
    }

    private void processSwitchResultNotice(int neID, Operation oper) {
        log.info("MARINE ------receive BU switch result notice ------ neID->" + neID);
        if (null == oper) {
            log.info("MARINE ------receive BU switch result notice------ notice is null, resurn. neID->" + neID);
            return;
        }
        Output output = null;
        TESLMSwitchBUStatus buState = null;
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            log.info("MARINE ------get a output, the number is->" + i);
            int lineID = Integer.parseInt(output.getPartValue("lineID"));
            log.info("MARINE ------indexID->" + lineID);
            int switchMode = Integer.parseInt(output.getPartValue("switchMode"));
            log.info("MARINE ------testType->" + switchMode);
            String macAddr = "0x" + output.getPartValue("macAddr").substring(2);
            log.info("MARINE ------testMode->" + macAddr);
            int confStatusBefore = Integer.parseInt(output.getPartValue("confStatusBefore"));
            log.info("MARINE ------testMode->" + confStatusBefore);
            int confStatusAfter = Integer.parseInt(output.getPartValue("confStatusAfter"));
            log.info("MARINE ------testMode->" + confStatusAfter);
            int step = Integer.parseInt(output.getPartValue("step"));
            log.info("MARINE ------testMode->" + step);
            long sendCommandTime = Long.parseLong(output.getPartValue("sendCommandTime"), 16);
            log.info("MARINE ------testMode->" + sendCommandTime);
            int slotid = null == output.getPartValue("slotid") ? 0 : Integer.parseInt(output.getPartValue("slotid"));
            log.info("MARINE ------testMode->" + slotid);
            int errorCode = null == output.getPartValue("errorCode") ? 0 : Integer.parseInt(output.getPartValue("errorCode"));
            log.info("MARINE ------testMode->" + errorCode);
            int boardCommandCode = null == output.getPartValue("boardCommandCode") ? 0 : Integer.parseInt(output.getPartValue("boardCommandCode"));
            log.info("MARINE ------testMode->" + boardCommandCode);
            buState = new TESLMSwitchBUStatus();
            TEMarineBUPO bu = TEMarineBUUtil.getBUDataOperationHandler().getBUInfoByAddress(macAddr);
            buState.setBuName(null == bu ? "" : bu.getBuName());
            buState.setBuAddr(macAddr);
            buState.setErrCode(errorCode);
            buState.setErrSlotID(slotid);
            buState.setBoardCommandCode(boardCommandCode);
            buState.setLineID(lineID);
            buState.setConfStatusBefore(confStatusBefore);
            buState.setConfStatusAfter(confStatusAfter);
            buState.setSendCommandTime(sendCommandTime);
            buState.setStep(step);
            buState.setSwitchMode(switchMode);
            TESLMBUDataMgr.getInstance().refreshSwitchState(buState);
        }
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            TEBUASN1Commond.sendSwitchBUResultMessageToClient(buState);
        }
        log.info("MARINE ------end to BU switch result notice. neID->" + neID);
    }
}

