/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.bue2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnPFEPolarityStr;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnPFEPolarityStrList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnQueryPFEPolarityReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnQueryPFEPolarityRsp;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import net.commustru.fstru.FStruct;

class TEQueryPFEPolarityHandler {
    TEQueryPFEPolarityHandler() {
    }

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm) {
        AsnQueryPFEPolarityReq cReq = (AsnQueryPFEPolarityReq)req;
        AsnQueryPFEPolarityRsp cRsp = (AsnQueryPFEPolarityRsp)rsp;
        AsnPFEPolarityStrList polarityStrList = cRsp.pfePolarityList;
        AsnPFEPolarityStr pfePolarity = null;
        int len = cReq.neIDList.size();
        for (int i = 0; i < len; ++i) {
            int neID = cReq.neIDList.get(i);
            TENE phyPFENE = TENEListMgr.getInstance().getNE(neID);
            if (null == phyPFENE || 0 == phyPFENE.getComStarus()) {
                TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + neID + " failed! uncommunite failed!");
                continue;
            }
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neID);
            ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
            try {
                TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neID);
                TL1Operation oper1 = null;
                oper1 = definitions.getTL1Operation("RTRV-SYS");
                operationList.add(oper1);
                TL1Operation oper2 = null;
                oper2 = definitions.getTL1Operation("RTRV-PM-EQPT");
                InMsg inputMsg1 = oper2.getInMsg();
                MsgBlock msgblock1 = inputMsg1.getMsgBlock();
                msgblock1.getPart("tmper").setValue("15-MIN");
                StringBuffer sb1 = new StringBuffer();
                sb1.append("SLOT-5");
                inputMsg1.getPart("aid").setValue(sb1.toString());
                operationList.add(oper2);
                OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neID, operationList, 30);
                if (0 != result.retCode) {
                    TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + neID + " failed! Result code is " + result);
                    continue;
                }
                oper1 = (TL1Operation)operationList.get(0);
                OutMsg outMsg = oper1.getOutMsg(0);
                if (0 != outMsg.getFault().getCompletionCode()) {
                    TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + neID + " failed! Result CompletionCode is " + outMsg.getFault().getCompletionCode());
                    continue;
                }
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsg);
                String nePolarity = ((Part)hm.get("POLARITY")).getValue();
                oper2 = (TL1Operation)operationList.get(1);
                String pfeVoltageStr = null;
                String pfeCurrentStr = null;
                BigInteger pfeVoltage = null;
                BigInteger pfeCurrent = null;
                int voltage = 0;
                int len1 = oper2.getOutMsgCount();
                for (int index = 0; index < len1; ++index) {
                    outMsg = oper2.getOutMsg(index);
                    if (0 != outMsg.getFault().getCompletionCode()) {
                        TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + neID + " failed! Result CompletionCode is " + outMsg.getFault().getCompletionCode());
                        continue;
                    }
                    hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsg);
                    String tmpValue = ((Part)hm.get("montype")).getValue();
                    if ("PFEVOL-CUR".equals(tmpValue)) {
                        pfeVoltageStr = ((Part)hm.get("monval")).getValue();
                        if (null == pfeVoltageStr || pfeVoltageStr.isEmpty()) continue;
                        pfeVoltage = new BigInteger(pfeVoltageStr);
                        voltage = pfeVoltage.intValue();
                        continue;
                    }
                    if (!"PFECV-CUR".equals(tmpValue) || null == (pfeCurrentStr = ((Part)hm.get("monval")).getValue()) || pfeCurrentStr.isEmpty()) continue;
                    pfeCurrent = new BigInteger(pfeCurrentStr);
                }
                if (nePolarity != null && nePolarity.equals("N")) {
                    voltage = 0 - voltage;
                    pfeVoltage = BigInteger.valueOf(voltage);
                }
                if (null != nePolarity && null != pfeVoltageStr && null != pfeCurrentStr) {
                    pfePolarity = new AsnPFEPolarityStr();
                    pfePolarity.neID = BigInteger.valueOf(neID);
                    pfePolarity.polarity = nePolarity.getBytes();
                    pfePolarity.pfeVoltage = pfeVoltage;
                    pfePolarity.pfeCurrent = pfeCurrent;
                    polarityStrList.add((Object)pfePolarity);
                    continue;
                }
                TELogFactory.getNormalLogger().info("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + neID + " failed! nePolarity/pfeVoltageStr/pfeCurrentStr is null");
                continue;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEQueryPFEPolarityHandler: Query PFE result from PFE1670:" + neID + " failed! ", (Throwable)e);
            }
        }
        cRsp.result.isSuccess = true;
        cRsp.result.retCode = BigInteger.valueOf(0L);
        return 0;
    }
}

