/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.bue2e;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.bue2e.TEBUObjectPosition;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.util.ArrayList;
import java.util.List;

public class TEBUOperForMarineTopo {
    private static final int TOPOSET_WIDTH = 20;
    private static final int TOPO_GAP = 20;
    private static final int DEFAULT_BU_POSX = 300;
    private static final int DEFAULT_BU_POSY = 300;

    private TEBUOperForMarineTopo() {
    }

    public static int[] calcNewBUDefaultPosition() {
        ArrayList<TEBUObjectPosition> posList = new ArrayList<TEBUObjectPosition>();
        posList.addAll(TEBUOperForMarineTopo.getAllStationPosList());
        posList.addAll(TEBUOperForMarineTopo.getAllBUPosList());
        TEBUObjectPosition pos = new TEBUObjectPosition();
        if (posList.size() == 1) {
            pos.setPosX(((TEBUObjectPosition)posList.get(0)).getPosX() + 20 + 20);
            pos.setPosY(((TEBUObjectPosition)posList.get(0)).getPosY());
            return new int[]{pos.getPosX(), pos.getPosY()};
        }
        int len = posList.size();
        for (int i = 0; i < len; ++i) {
            boolean findPos = false;
            pos = (TEBUObjectPosition)posList.get(i);
            for (int j = i + 1; j < len; ++j) {
                TEBUObjectPosition tmpPos = (TEBUObjectPosition)posList.get(j);
                if (tmpPos.getPosX() < pos.getPosX() && tmpPos.getPosX() > pos.getPosX() + 40 + 40 || tmpPos.getPosY() < pos.getPosY() - 20 - 20 || tmpPos.getPosY() > pos.getPosY() + 20 + 20) continue;
                findPos = true;
                break;
            }
            if (findPos) continue;
            pos.setPosX(pos.getPosX() + 20 + 20);
            return new int[]{pos.getPosX(), pos.getPosY()};
        }
        return new int[]{300, 300};
    }

    private static List<TEBUObjectPosition> getAllStationPosList() {
        ArrayList<TEBUObjectPosition> posList = new ArrayList<TEBUObjectPosition>();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Calculate BU position fail---", (Throwable)e);
            return posList;
        }
        if (0 == dbResult.getResult()) {
            TEBUObjectPosition objPos = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                TEMarineStationPO stationPO = (TEMarineStationPO)obj;
                objPos = new TEBUObjectPosition();
                objPos.setPosX(stationPO.getPosX());
                objPos.setPosY(stationPO.getPosY());
                posList.add(objPos);
            }
        }
        return posList;
    }

    private static List<TEBUObjectPosition> getAllBUPosList() {
        ArrayList<TEBUObjectPosition> posList = new ArrayList<TEBUObjectPosition>();
        TEBUDataBaseOperService buDataService = new TEBUDataBaseOperService();
        ArrayList<TEMarineBUPO> buPoList = new ArrayList<TEMarineBUPO>();
        int result = buDataService.queryAllBUInfo(buPoList);
        if (0 == result) {
            for (TEMarineBUPO bupo : buPoList) {
                TEBUObjectPosition objPos = new TEBUObjectPosition();
                objPos.setPosX(bupo.getPosX());
                objPos.setPosY(bupo.getPosY());
                posList.add(objPos);
            }
        }
        return posList;
    }
}

