/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.bue2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnStrList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBU;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUBondLine;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUBondLineList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUPort;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUPortList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineGetBUReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineGetBURsp;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineLineStr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;

class TEBUE2EQueryHandler {
    private List<TESLMLinePO> linePOList = new ArrayList<TESLMLinePO>();

    TEBUE2EQueryHandler() {
    }

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        TELogFactory.getNormalLogger().info("TEBUE2EQueryHandler begin !");
        AsnMarineGetBUReq cReq = (AsnMarineGetBUReq)req;
        AsnMarineGetBURsp cRsp = (AsnMarineGetBURsp)rsp;
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        TEBUDataBaseOperService dataBaseService = new TEBUDataBaseOperService();
        int result = dataBaseService.queryAllBUInfo(buList);
        AsnSingleReturn singleRtn = cRsp.result;
        singleRtn.isSuccess = true;
        singleRtn.retCode = BigInteger.valueOf(result);
        if (0 != result) {
            List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
            TELogFactory.getNormalLogger().info("TEBUE2EQueryHandler: Query bu result from database failed! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2EQueryHandler end !");
            this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
            return 0;
        }
        AsnMarineBUList asnBUList = new AsnMarineBUList();
        AsnStrList asnBUNameList = cReq.bunameList;
        this.getNeedBUList(buList, asnBUNameList);
        if (buList.isEmpty()) {
            List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
            TELogFactory.getNormalLogger().info("TEBUE2EQueryHandler: Query bu result is null!");
            TELogFactory.getNormalLogger().info("TEBUE2EQueryHandler end !");
            this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
            return 0;
        }
        for (TEMarineBUPO buPo : buList) {
            AsnMarineBU asnBuInfo = new AsnMarineBU();
            asnBuInfo.buname = buPo.getBuName().getBytes();
            asnBuInfo.type = BigInteger.valueOf(buPo.getType());
            asnBuInfo.macAddr = buPo.getMacAddr().getBytes();
            asnBuInfo.pressure = BigInteger.valueOf(buPo.getPressure());
            asnBuInfo.primaryLine = BigInteger.valueOf(buPo.getPrimaryLine());
            asnBuInfo.lastOperTime = BigInteger.valueOf(Long.parseLong(buPo.getLastOperTime()));
            asnBuInfo.bondLineList = this.getBondLineList(buPo.getBondLineList());
            asnBuInfo.portList = this.getPortList(buPo.getPortList());
            asnBUList.add((Object)asnBuInfo);
        }
        cRsp.buList = asnBUList;
        TELogFactory.getNormalLogger().info("TEBUE2EQueryHandler: Query bu result is successfule!");
        TELogFactory.getNormalLogger().info("TEBUE2EQueryHandler end !");
        List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
        this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
        return 0;
    }

    private void getNeedBUList(List<TEMarineBUPO> buList, AsnStrList asnBUNameList) {
        if (asnBUNameList.isEmpty()) {
            return;
        }
        String buName = new String((byte[])asnBUNameList.get(0));
        if ("0".equals(buName)) {
            return;
        }
        ArrayList<String> buNameList = new ArrayList<String>();
        int len = asnBUNameList.size();
        for (int i = 0; i < len; ++i) {
            buName = new String((byte[])asnBUNameList.get(i));
            buNameList.add(buName);
        }
        for (int i = buList.size() - 1; i >= 0; --i) {
            TEMarineBUPO bu = buList.get(i);
            if (buNameList.contains(bu.getBuName())) continue;
            buList.remove(i);
        }
    }

    private AsnMarineBUBondLineList getBondLineList(Set<TEBUBondLinePO> bondLineSet) {
        AsnMarineBUBondLineList asnBondLineList = new AsnMarineBUBondLineList();
        if (null != bondLineSet && !bondLineSet.isEmpty()) {
            TESLMLinePO srcLinePO = null;
            TESLMLinePO snkLinePO = null;
            for (TEBUBondLinePO bondLine : bondLineSet) {
                int srcNeID = TENECommMgr.getInstance().getLogicNEID(bondLine.getSrcNeID());
                int snkNeID = TENECommMgr.getInstance().getLogicNEID(bondLine.getSnkNeID());
                int lineID = bondLine.getLineId();
                srcLinePO = this.getBUBondLinePO(srcNeID, lineID);
                snkLinePO = this.getBUBondLinePO(snkNeID, lineID);
                if (null == srcLinePO && null == snkLinePO) continue;
                AsnMarineBUBondLine asnBondLine = new AsnMarineBUBondLine();
                asnBondLine.srcLineStr = snkLinePO != null ? this.getAsnLineStr(srcLinePO, snkLinePO.getOppositeNEID()) : this.getAsnLineStr(srcLinePO, 0L);
                asnBondLine.snkLineStr = srcLinePO != null ? this.getAsnLineStr(snkLinePO, srcLinePO.getOppositeNEID()) : this.getAsnLineStr(snkLinePO, 0L);
                String lineRemark = null == srcLinePO ? "" : srcLinePO.getRemark();
                asnBondLine.remark = lineRemark.getBytes();
                asnBondLine.lineId = BigInteger.valueOf(bondLine.getLineId());
                asnBondLine.controlPart = BigInteger.valueOf(bondLine.getControlPart());
                asnBondLineList.add((Object)asnBondLine);
            }
        }
        return asnBondLineList;
    }

    private TESLMLinePO getBUBondLinePO(int neid, int lineID) {
        TESLMLinePO linePO = null;
        for (TESLMLinePO lineObj : this.linePOList) {
            if ((long)neid != lineObj.getNeID() || lineID != lineObj.getLineID()) continue;
            linePO = lineObj;
            break;
        }
        if (null == linePO) {
            int[] metadata = new int[]{neid};
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.findAll((int[])metadata, TESLMLinePO.class);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Marine----Find all Line in DataBase fail!", (Throwable)e);
            }
            if (null == dbResult) {
                TELogFactory.getNormalLogger().error("The dbResult is null!");
                return linePO;
            }
            int retCode = dbResult.getResult();
            if (0 == retCode) {
                TESLMLinePO lineObj = null;
                for (Object obj : dbResult.getData()) {
                    lineObj = (TESLMLinePO)obj;
                    if (lineObj.getLineID() == lineID) {
                        linePO = lineObj;
                    }
                    this.linePOList.add(lineObj);
                }
            }
        }
        return linePO;
    }

    private AsnMarineLineStr getAsnLineStr(TESLMLinePO linePO, long oppositeNEID) {
        AsnMarineLineStr lineStr = new AsnMarineLineStr();
        if (null != linePO) {
            lineStr.neID = BigInteger.valueOf(linePO.getNeID());
            lineStr.lmuSlotID = BigInteger.valueOf(linePO.getLMUSlot());
            lineStr.lmuPortID = BigInteger.valueOf(linePO.getLMUPort());
            lineStr.lasSlotID = BigInteger.valueOf(linePO.getLASSlot());
            lineStr.lasPortID = BigInteger.valueOf(linePO.getLASPort());
            lineStr.lmiSlotID = BigInteger.valueOf(linePO.getLMISlot());
            lineStr.lmiPortID = BigInteger.valueOf(linePO.getLMIPort());
        } else if (oppositeNEID == 0L) {
            lineStr.neID = BigInteger.valueOf(0L);
            lineStr.lmuSlotID = BigInteger.valueOf(0L);
            lineStr.lmuPortID = BigInteger.valueOf(0L);
            lineStr.lasSlotID = BigInteger.valueOf(0L);
            lineStr.lasPortID = BigInteger.valueOf(0L);
            lineStr.lmiSlotID = BigInteger.valueOf(0L);
            lineStr.lmiPortID = BigInteger.valueOf(0L);
        } else {
            lineStr.neID = BigInteger.valueOf(-1L);
            lineStr.lmuSlotID = BigInteger.valueOf(-1L);
            lineStr.lmuPortID = BigInteger.valueOf(-1L);
            lineStr.lasSlotID = BigInteger.valueOf(-1L);
            lineStr.lasPortID = BigInteger.valueOf(-1L);
            lineStr.lmiSlotID = BigInteger.valueOf(-1L);
            lineStr.lmiPortID = BigInteger.valueOf(-1L);
        }
        return lineStr;
    }

    private AsnMarineBUPortList getPortList(Set<TEBUPortPO> portSet) {
        AsnMarineBUPortList asnPortList = new AsnMarineBUPortList();
        if (null != portSet && !portSet.isEmpty()) {
            for (TEBUPortPO port : portSet) {
                AsnMarineBUPort asnPort = new AsnMarineBUPort();
                asnPort.portName = port.getPortName().getBytes();
                asnPort.bondSLM = this.getSLMNeid(port.getBondSLM()).getBytes();
                asnPort.bondPFE = this.getPFENeName(port.getBondPFE()).getBytes();
                asnPort.isEarth = BigInteger.valueOf(port.getIsEarth());
                asnPort.elecDirection = BigInteger.valueOf(port.getElecDirection());
                asnPortList.add((Object)asnPort);
            }
        }
        return asnPortList;
    }

    private String getSLMNeid(String slmRealNeid) {
        if ("-1".equals(slmRealNeid)) {
            return "-1";
        }
        TENE ne = TENEListMgr.getInstance().getPhyNE(Integer.parseInt(slmRealNeid.split(",")[0]));
        String bondSlmIDStr = "";
        if (null != ne) {
            bondSlmIDStr = String.valueOf(ne.getNEID());
        }
        if (2 == slmRealNeid.split(",").length && !slmRealNeid.split(",")[0].equals(slmRealNeid.split(",")[1]) && null != (ne = TENEListMgr.getInstance().getPhyNE(Integer.parseInt(slmRealNeid.split(",")[1])))) {
            bondSlmIDStr = bondSlmIDStr + ("".equals(bondSlmIDStr) ? Integer.valueOf(ne.getNEID()) : "," + ne.getNEID());
        }
        bondSlmIDStr = "".equals(bondSlmIDStr) ? "-1" : bondSlmIDStr;
        return bondSlmIDStr;
    }

    private String getPFENeName(String pfeStr) {
        if ("0".equals(pfeStr)) {
            return "-";
        }
        return pfeStr;
    }

    private List<TEMarineLogInfo> getLogInfo(AsnMarineGetBUReq req, AsnMarineGetBURsp rsp, TETaskInfo info) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo logInfo = new TEMarineLogInfo();
        logInfo.setCmdID(info.getMsgHead().cmdCode);
        logInfo.setErrCode(rsp.result.retCode.intValue());
        logInfo.setResult(rsp.result.retCode.intValue());
        logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)rsp.result.retCode.intValue()));
        logInfo.setOperateName(res.getString("QUERY_BU"));
        logInfo.setOperateObject(res.getString("QUERY_BU"));
        logInfo.setOperateDesc(res.getString("QUERY_BU"));
        logInfoList.add(logInfo);
        return logInfoList;
    }

    private void writeLog(int userID, String ipAddress, List<TEMarineLogInfo> logInfoList) {
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, logInfoList);
    }
}

