/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.bue2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBU;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUBondLine;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUBondLineList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUPort;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUPortList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineModifyBUReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineModifyBURsp;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class TEBUE2EModifyHandler {
    private static final int ISSWITCH_TYPE = 1;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler begin !");
        AsnMarineModifyBUReq cReq = (AsnMarineModifyBUReq)req;
        AsnMarineModifyBURsp cRsp = (AsnMarineModifyBURsp)rsp;
        AsnMarineBU asnBu = cReq.bu;
        TEBUDataBaseOperService dataBaseService = new TEBUDataBaseOperService();
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        int result = dataBaseService.queryBUInfoByName(new String(asnBu.buname), buList);
        AsnSingleReturn singleRtn = cRsp.result;
        singleRtn.isSuccess = true;
        if (0 != result) {
            singleRtn.retCode = BigInteger.valueOf(result);
            cRsp.result = singleRtn;
            List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
            this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler: Query bu by name from database failed! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler end !");
            return 0;
        }
        if (null == buList || buList.isEmpty()) {
            singleRtn.retCode = BigInteger.valueOf(1090615228L);
            cRsp.result = singleRtn;
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler: The result of query bu by name from database is empty! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler end !");
            List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
            this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
            return 0;
        }
        TEMarineBUPO bu = (TEMarineBUPO)buList.get(0);
        bu.setType(asnBu.type.intValue());
        bu.setMacAddr(new String(asnBu.macAddr));
        bu.setPrimaryLine(asnBu.primaryLine.intValue());
        bu.setPressure(asnBu.pressure.intValue());
        if (1 == cReq.isSwitch.intValue()) {
            bu.setLastOperTime(String.valueOf(System.currentTimeMillis()));
        }
        this.refreshPortBondNE(bu.getPortList(), asnBu.portList);
        this.refreshBondLines(bu.getBondLineList(), asnBu.bondLineList);
        result = dataBaseService.updateBUInfo(bu);
        singleRtn.retCode = BigInteger.valueOf(result);
        cRsp.result = singleRtn;
        List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
        this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
        if (0 != result) {
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler: Update bu in database failed! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler end !");
            return 0;
        }
        TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler: Modify bu result is successfule!");
        TELogFactory.getNormalLogger().info("TEBUE2EDeleteHandler end !");
        return 0;
    }

    private void refreshPortBondNE(Set<TEBUPortPO> portList, AsnMarineBUPortList asnPortList) {
        if (null == portList || portList.isEmpty()) {
            return;
        }
        Set<TEBUPortPO> updatePortList = TEMarineBUE2EUtil.getBUE2EUtilInstance().getPortSet(asnPortList);
        if (null == updatePortList || updatePortList.isEmpty()) {
            return;
        }
        for (TEBUPortPO port : portList) {
            for (TEBUPortPO newPort : updatePortList) {
                if (!port.getPortName().equals(newPort.getPortName())) continue;
                port.setBondPFE(newPort.getBondPFE());
                port.setBondSLM(newPort.getBondSLM());
                port.setElecDirection(newPort.getElecDirection());
                port.setIsEarth(newPort.getIsEarth());
            }
        }
    }

    private void refreshBondLines(Set<TEBUBondLinePO> bondList, AsnMarineBUBondLineList asnBondList) {
        if (null == bondList) {
            return;
        }
        bondList.clear();
        if (!asnBondList.isEmpty()) {
            TEBUBondLinePO buBondLine = null;
            AsnMarineBUBondLine asnBondLine = null;
            int len = asnBondList.size();
            for (int i = 0; i < len; ++i) {
                asnBondLine = (AsnMarineBUBondLine)asnBondList.get(i);
                buBondLine = new TEBUBondLinePO();
                int srcNeID = asnBondLine.srcLineStr.neID.intValue();
                srcNeID = 0 == srcNeID ? srcNeID : TEConfigurationDataMgr.getInstance().getNEID(srcNeID);
                int snkNeID = asnBondLine.snkLineStr.neID.intValue();
                snkNeID = 0 == snkNeID ? snkNeID : TEConfigurationDataMgr.getInstance().getNEID(snkNeID);
                buBondLine.setSrcNeID((long)srcNeID);
                buBondLine.setSnkNeID((long)snkNeID);
                buBondLine.setLineId(asnBondLine.lineId.intValue());
                buBondLine.setControlPart(asnBondLine.controlPart.intValue());
                bondList.add(buBondLine);
            }
        }
    }

    private List<TEMarineLogInfo> getLogInfo(AsnMarineModifyBUReq req, AsnMarineModifyBURsp rsp, TETaskInfo info) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        String buName = new String(req.bu.buname);
        TEMarineLogInfo logInfo = new TEMarineLogInfo();
        logInfo.setCmdID(info.getMsgHead().cmdCode);
        logInfo.setOperateName(res.getString("SET_BU_INFO"));
        logInfo.setOperateObject(buName);
        int ret = rsp.result.retCode.intValue();
        logInfo.setResult(ret);
        logInfo.setOperateDesc(this.getErrDetail(req));
        logInfo.setErrCode(ret);
        logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)ret));
        logInfoList.add(logInfo);
        return logInfoList;
    }

    private String getErrDetail(AsnMarineModifyBUReq req) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        StringBuilder logDetailSB = new StringBuilder(res.getString("BU_NAME"));
        AsnMarineBU asnBU = req.bu;
        logDetailSB.append(":").append(new String(asnBU.buname)).append(",");
        logDetailSB.append(res.getString("bumac")).append(":").append(new String(asnBU.macAddr)).append(",");
        logDetailSB.append(res.getString("butype")).append(":").append(TEMarineBUUtil.getBUTypeString(asnBU.type.intValue())).append(",");
        logDetailSB.append(res.getString("pressure")).append(":").append(asnBU.pressure.intValue()).append(";");
        logDetailSB.append(res.getString("bondslmunit")).append(",").append(res.getString("porta")).append(":");
        logDetailSB.append(this.getBondSLMNEName(asnBU.portList, "A")).append(";");
        logDetailSB.append(res.getString("portb")).append(":");
        logDetailSB.append(this.getBondSLMNEName(asnBU.portList, "B")).append(";");
        logDetailSB.append(res.getString("portc")).append(":");
        logDetailSB.append(this.getBondSLMNEName(asnBU.portList, "C")).append(";");
        logDetailSB.append(res.getString("bondpfeunit")).append(",").append(res.getString("porta")).append(":");
        logDetailSB.append(this.getBondPFENEName(asnBU.portList, "A")).append(";");
        logDetailSB.append(res.getString("portb")).append(":");
        logDetailSB.append(this.getBondPFENEName(asnBU.portList, "B")).append(";");
        logDetailSB.append(res.getString("portc")).append(":");
        logDetailSB.append(this.getBondPFENEName(asnBU.portList, "C")).append(";");
        int len = asnBU.bondLineList.size();
        for (int i = 0; i < len; ++i) {
            AsnMarineBUBondLine bondline = (AsnMarineBUBondLine)asnBU.bondLineList.get(i);
            logDetailSB.append(res.getString("lineIDStr")).append(':').append(this.getBondLineStr(bondline));
        }
        return logDetailSB.toString();
    }

    private String getBondSLMNEName(AsnMarineBUPortList asnBuPortList, String portName) {
        String bondNeStrings = "";
        int len = asnBuPortList.size();
        for (int i = 0; i < len; ++i) {
            AsnMarineBUPort asnPort = (AsnMarineBUPort)asnBuPortList.get(i);
            if (!portName.equals(new String(asnPort.portName))) continue;
            bondNeStrings = new String(asnPort.bondSLM);
            break;
        }
        StringBuilder bondNeStr = new StringBuilder("");
        if (bondNeStrings.equals("") || bondNeStrings.equals("-1")) {
            bondNeStr.append("-");
        } else {
            String[] bondNeIDs = bondNeStrings.split(",");
            for (int i = 0; i < bondNeIDs.length; ++i) {
                TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(bondNeIDs[i]));
                if (null == ne) continue;
                if (!bondNeStr.toString().equals("")) {
                    bondNeStr.append(",");
                }
                bondNeStr.append(ne.getNEName());
            }
        }
        return bondNeStr.toString();
    }

    private String getBondPFENEName(AsnMarineBUPortList asnBuPortList, String portName) {
        String bondNeStrings = "";
        int len = asnBuPortList.size();
        for (int i = 0; i < len; ++i) {
            AsnMarineBUPort asnPort = (AsnMarineBUPort)asnBuPortList.get(i);
            if (!portName.equals(new String(asnPort.portName))) continue;
            bondNeStrings = new String(asnPort.bondPFE);
            break;
        }
        if (bondNeStrings.equals("") || bondNeStrings.equals("0")) {
            bondNeStrings = "-";
        }
        return bondNeStrings;
    }

    private String getBondLineStr(AsnMarineBUBondLine bondline) {
        int srcNEID = bondline.srcLineStr.neID.intValue();
        TENE ne = TENEListMgr.getInstance().getNE(srcNEID);
        String bondLineStr = "";
        bondLineStr = null == ne ? bondLineStr + (0 == srcNEID ? "" : "UNKNOWN-") : bondLineStr + ne.getNEName() + "-";
        int snkNEID = bondline.snkLineStr.neID.intValue();
        ne = TENEListMgr.getInstance().getNE(snkNEID);
        bondLineStr = null == ne ? bondLineStr + (0 == snkNEID ? "" : "UNKNOWN-") : bondLineStr + ne.getNEName() + "-";
        bondLineStr = bondLineStr + bondline.lineId.intValue() + " ";
        return bondLineStr;
    }

    private void writeLog(int userID, String ipAddress, List<TEMarineLogInfo> logInfoList) {
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, logInfoList);
    }
}

