/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.bue2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnStrList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineDelBURtnList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineDeleteBUReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineDeleteBUReturn;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineDeleteBURsp;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TEBUE2EDeleteHandler {
    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        TELogFactory.getNormalLogger().info("TEBUE2EDeleteHandler begin !");
        AsnMarineDeleteBUReq cReq = (AsnMarineDeleteBUReq)req;
        AsnMarineDeleteBURsp cRsp = (AsnMarineDeleteBURsp)rsp;
        List<String> buNameList = this.getDelBUNames(cReq.buNameList);
        List<String> usedBUNameList = TEMarineBUE2EUtil.getBUE2EUtilInstance().filtrateUnUsedBUNameList(buNameList);
        TEBUDataBaseOperService dataBaseService = new TEBUDataBaseOperService();
        int result = dataBaseService.deleteBU(buNameList);
        AsnSingleReturn singleRtn = cRsp.result;
        singleRtn.isSuccess = true;
        singleRtn.retCode = BigInteger.valueOf(result);
        if (0 != result) {
            List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
            this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
            TELogFactory.getNormalLogger().info("TEBUE2EDeleteHandler: Delete bu into database failed! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2EDeleteHandler end !");
            return 0;
        }
        if (null != usedBUNameList && !usedBUNameList.isEmpty()) {
            for (String buName : usedBUNameList) {
                AsnMarineDeleteBUReturn buRtn = new AsnMarineDeleteBUReturn();
                buRtn.buname = buName.getBytes();
                buRtn.result.isSuccess = true;
                buRtn.result.retCode = BigInteger.valueOf(1090615090L);
                cRsp.delResultList.add((Object)buRtn);
            }
            singleRtn.retCode = buNameList.isEmpty() ? BigInteger.valueOf(1090650122L) : BigInteger.valueOf(1090650126L);
        }
        if (!buNameList.isEmpty()) {
            TEMarineBUUtil.sendDelMessageToTopo(buNameList);
        }
        List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
        this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
        TELogFactory.getNormalLogger().info("TEBUE2EDeleteHandler: Delete bu result is successfule!");
        TELogFactory.getNormalLogger().info("TEBUE2EDeleteHandler end !");
        return 0;
    }

    private List<String> getDelBUNames(AsnStrList asnBUNameList) {
        ArrayList<String> buNameList = new ArrayList<String>();
        if (null != asnBUNameList && !asnBUNameList.isEmpty()) {
            int len = asnBUNameList.size();
            for (int i = 0; i < len; ++i) {
                String name = new String((byte[])asnBUNameList.get(i));
                buNameList.add(name);
            }
        }
        return buNameList;
    }

    private List<TEMarineLogInfo> getLogInfo(AsnMarineDeleteBUReq req, AsnMarineDeleteBURsp rsp, TETaskInfo info) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        AsnStrList asnBuNames = req.buNameList;
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        int len = asnBuNames.size();
        for (int i = 0; i < len; ++i) {
            String buName = new String((byte[])asnBuNames.get(i));
            TEMarineLogInfo logInfo = new TEMarineLogInfo();
            logInfo.setCmdID(info.getMsgHead().cmdCode);
            logInfo.setOperateName(res.getString("DELETE_BU"));
            logInfo.setOperateObject(buName);
            logInfo.setResult(rsp.result.retCode.intValue());
            logInfo.setOperateDesc(res.getString("BU_NAME") + ":" + buName);
            this.getErrDetail(buName, rsp, logInfo);
            logInfoList.add(logInfo);
        }
        return logInfoList;
    }

    private void getErrDetail(String buName, AsnMarineDeleteBURsp rsp, TEMarineLogInfo logInfo) {
        AsnMarineDelBURtnList delBURtnList = rsp.delResultList;
        AsnMarineDeleteBUReturn delBuRtn = null;
        int len = delBURtnList.size();
        for (int i = 0; i < len; ++i) {
            AsnMarineDeleteBUReturn tmpDelBuRtn = (AsnMarineDeleteBUReturn)delBURtnList.get(i);
            String tmpBuName = new String(tmpDelBuRtn.buname);
            if (!tmpBuName.equals(buName)) continue;
            delBuRtn = tmpDelBuRtn;
            break;
        }
        if (null == delBuRtn) {
            logInfo.setErrCode(0);
            logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)0));
        } else {
            int ret = delBuRtn.result.retCode.intValue();
            logInfo.setErrCode(ret);
            logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)ret));
        }
    }

    private void writeLog(int userID, String ipAddress, List<TEMarineLogInfo> logInfoList) {
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, logInfoList);
    }
}

