/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.bue2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBU;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUBondLine;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUPort;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUPortList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineCreateBUReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineCreateBURsp;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

class TEBUE2ECreateHandler {
    TEBUE2ECreateHandler() {
    }

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        TELogFactory.getNormalLogger().info("TEBUE2ECreateHandler begin !");
        AsnMarineCreateBUReq cReq = (AsnMarineCreateBUReq)req;
        AsnMarineCreateBURsp cRsp = (AsnMarineCreateBURsp)rsp;
        TEMarineBUPO bu = this.getNewBU(cReq.bu);
        TEBUDataBaseOperService dataBaseService = new TEBUDataBaseOperService();
        int result = dataBaseService.createBUInfo(bu);
        AsnSingleReturn singleRtn = cRsp.result;
        singleRtn.isSuccess = true;
        singleRtn.retCode = BigInteger.valueOf(result);
        List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
        if (0 != result) {
            TELogFactory.getNormalLogger().info("TEBUE2ECreateHandler: Create bu into database failed! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2ECreateHandler end !");
        } else {
            TEMarineBUUtil.sendMessageToTopo(bu);
            TELogFactory.getNormalLogger().info("TEBUE2ECreateHandler: Create bu result is successfule!");
            TELogFactory.getNormalLogger().info("TEBUE2ECreateHandler end !");
        }
        this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
        return 0;
    }

    private TEMarineBUPO getNewBU(AsnMarineBU asnBU) {
        TEMarineBUE2EUtil.getBUE2EUtilInstance();
        TEMarineBUPO bu = TEMarineBUE2EUtil.convertAsn1ToBUPO(asnBU);
        TEMarineBUUtil.calcBUE2EPos(bu);
        return bu;
    }

    private List<TEMarineLogInfo> getLogInfo(AsnMarineCreateBUReq req, AsnMarineCreateBURsp rsp, TETaskInfo info) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo logInfo = new TEMarineLogInfo();
        logInfo.setCmdID(info.getMsgHead().cmdCode);
        logInfo.setErrCode(rsp.result.retCode.intValue());
        logInfo.setResult(rsp.result.retCode.intValue());
        logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)rsp.result.retCode.intValue()));
        logInfo.setOperateName(res.getString("CREATE_BU"));
        logInfo.setOperateObject(new String(req.bu.buname));
        logInfo.setOperateDesc(this.getDetailStr(req));
        logInfoList.add(logInfo);
        return logInfoList;
    }

    private String getDetailStr(AsnMarineCreateBUReq req) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        StringBuilder logDetailSB = new StringBuilder(res.getString("BU_NAME"));
        AsnMarineBU bu = req.bu;
        if (null != bu) {
            logDetailSB.append(":").append(new String(bu.buname)).append(",");
            logDetailSB.append(res.getString("bumac")).append(":").append(new String(bu.macAddr)).append(",");
            logDetailSB.append(res.getString("butype")).append(":").append(TEMarineBUUtil.getBUTypeString(bu.type.intValue())).append(",");
            logDetailSB.append(res.getString("pressure")).append(":").append(bu.pressure).append(";");
            logDetailSB.append(res.getString("bondslmunit")).append(",").append(res.getString("porta")).append(":");
            logDetailSB.append(this.getBondSLMNEName(bu.portList, "A")).append(";");
            logDetailSB.append(res.getString("portb")).append(":");
            logDetailSB.append(this.getBondSLMNEName(bu.portList, "B")).append(";");
            logDetailSB.append(res.getString("portc")).append(":");
            logDetailSB.append(this.getBondSLMNEName(bu.portList, "C")).append(";");
            logDetailSB.append(res.getString("bondpfeunit")).append(",").append(res.getString("porta")).append(":");
            logDetailSB.append(this.getBondPFENEName(bu.portList, "A")).append(";");
            logDetailSB.append(res.getString("portb")).append(":");
            logDetailSB.append(this.getBondPFENEName(bu.portList, "B")).append(";");
            logDetailSB.append(res.getString("portc")).append(":");
            logDetailSB.append(this.getBondPFENEName(bu.portList, "C")).append(";");
            AsnMarineBUBondLine bondline = null;
            int len = bu.bondLineList.size();
            for (int i = 0; i < len; ++i) {
                bondline = (AsnMarineBUBondLine)bu.bondLineList.get(i);
                logDetailSB.append(this.getBondLineStr(bondline));
            }
        }
        return logDetailSB.toString();
    }

    private String getBondSLMNEName(AsnMarineBUPortList buPortList, String portName) {
        String bondNeStrings = "";
        AsnMarineBUPort buPort = null;
        int len = buPortList.size();
        for (int i = 0; i < len; ++i) {
            buPort = (AsnMarineBUPort)buPortList.get(i);
            if (!portName.equals(new String(buPort.portName))) continue;
            bondNeStrings = new String(buPort.bondSLM);
            break;
        }
        StringBuilder bondNeStr = new StringBuilder("");
        if (bondNeStrings.equals("") || bondNeStrings.equals("-1") || bondNeStrings.equals("0")) {
            bondNeStr.append("-");
        } else {
            String[] bondNeIDs = bondNeStrings.split(",");
            for (int i = 0; i < bondNeIDs.length; ++i) {
                TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(bondNeIDs[i]));
                if (null == ne) continue;
                if (!bondNeStr.toString().equals("")) {
                    bondNeStr.append(",");
                }
                bondNeStr.append(ne.getNEName());
            }
        }
        return bondNeStr.toString();
    }

    private String getBondPFENEName(AsnMarineBUPortList buPortList, String portName) {
        String bondNeStrings = "";
        AsnMarineBUPort buPort = null;
        int len = buPortList.size();
        for (int i = 0; i < len; ++i) {
            buPort = (AsnMarineBUPort)buPortList.get(i);
            if (!portName.equals(new String(buPort.portName))) continue;
            bondNeStrings = new String(buPort.bondPFE);
            break;
        }
        if ("".equals(bondNeStrings) || "0".equals(bondNeStrings)) {
            bondNeStrings = "-";
        }
        return bondNeStrings;
    }

    private String getBondLineStr(AsnMarineBUBondLine bondline) {
        int srcNEID = bondline.srcLineStr.neID.intValue();
        TENE ne = TENEListMgr.getInstance().getPhyNE(srcNEID);
        String bondLineStr = "";
        bondLineStr = null == ne ? bondLineStr + (0 == srcNEID ? "" : "UNKNOWN-") : bondLineStr + ne.getNEName() + "-";
        int snkNEID = bondline.snkLineStr.neID.intValue();
        ne = TENEListMgr.getInstance().getPhyNE(snkNEID);
        bondLineStr = null == ne ? bondLineStr + (0 == snkNEID ? "" : "UNKNOWN-") : bondLineStr + ne.getNEName() + "-";
        bondLineStr = bondLineStr + bondline.lineId.intValue();
        return bondLineStr;
    }

    private void writeLog(int userID, String ipAddress, List<TEMarineLogInfo> logInfoList) {
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, logInfoList);
    }
}

