/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.bue2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineCalcBUVoltageReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineCalcBUVoltageRsp;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineCalcBUVoltageData;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;

public class TEBUE2ECalcVoltageHandler {
    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm) {
        TELogFactory.getNormalLogger().info("TEBUE2ECalcVoltageHandler begin !");
        AsnMarineCalcBUVoltageReq request = (AsnMarineCalcBUVoltageReq)req;
        AsnMarineCalcBUVoltageRsp response = (AsnMarineCalcBUVoltageRsp)rsp;
        TEMarineCalcBUVoltageData buVoltageData = this.initCalcBUVoltageToData(request);
        buVoltageData = TEMarineBUUtil.getBUVoltage(buVoltageData);
        int ret = this.doCalcBUVoltageToAsn(response, buVoltageData);
        TELogFactory.getNormalLogger().info("TEBUE2ECalcVoltageHandler handle result is : " + ret);
        TELogFactory.getNormalLogger().info("TEBUE2ECalcVoltageHandler end !");
        return 0;
    }

    private int doCalcBUVoltageToAsn(AsnMarineCalcBUVoltageRsp rsp, TEMarineCalcBUVoltageData buVoltageData) {
        int retCode = buVoltageData.getResultCode().intValue();
        rsp.result.setRetCode(retCode);
        rsp.result.isSuccess = 0 == retCode;
        rsp.voltage = buVoltageData.getBuVoltage();
        return retCode;
    }

    private TEMarineCalcBUVoltageData initCalcBUVoltageToData(AsnMarineCalcBUVoltageReq req) {
        TEMarineCalcBUVoltageData buVoltageData = new TEMarineCalcBUVoltageData();
        buVoltageData.setUserID(req.userID);
        buVoltageData.setForceSwitch(req.forceSwitch);
        buVoltageData.setFaultType(req.faultType);
        buVoltageData.setControlUnit(req.controlUnit);
        buVoltageData.setFaultLength(req.faultLength);
        buVoltageData.setLineID(req.lineID);
        buVoltageData.setMarineBUPO(TEMarineBUE2EUtil.convertAsn1ToBUPO(req.marineBU));
        buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
        buVoltageData.setResultCode(BigInteger.valueOf(0L));
        return buVoltageData;
    }
}

