/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.bue2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnModifyBUBondLine;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnModifyBUBondLineList;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnModifyBUBondLineReq;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnModifyBUBondLineRsp;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class TEBUBondLineE2EModifyHandler {
    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        TELogFactory.getNormalLogger().info("TEBUBondLineE2EModifyHandler begin !");
        AsnModifyBUBondLineReq cReq = (AsnModifyBUBondLineReq)req;
        AsnModifyBUBondLineRsp cRsp = (AsnModifyBUBondLineRsp)rsp;
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        TEBUDataBaseOperService dataBaseService = new TEBUDataBaseOperService();
        int result = dataBaseService.queryBUInfoByName(new String(cReq.buName), buList);
        if (0 != result) {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(result);
            List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
            this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler: Query bu by name from database failed! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler end !");
            return 0;
        }
        if (null == buList || buList.isEmpty()) {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(1090615228L);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler: The result of query bu by name from database is empty! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler end !");
            List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
            this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
            return 0;
        }
        TEMarineBUPO bu = (TEMarineBUPO)buList.get(0);
        Set buBondLineSet = bu.getBondLineList();
        buBondLineSet.clear();
        TEBUBondLinePO buBondLine = null;
        AsnModifyBUBondLineList asnBondLineList = cReq.bondLineList;
        AsnModifyBUBondLine asnBondLine = null;
        int len = asnBondLineList.size();
        for (int i = 0; i < len; ++i) {
            asnBondLine = (AsnModifyBUBondLine)asnBondLineList.get(i);
            buBondLine = new TEBUBondLinePO();
            int srcNeID = asnBondLine.srcNeID.intValue();
            srcNeID = 0 == srcNeID ? srcNeID : TEConfigurationDataMgr.getInstance().getNEID(srcNeID);
            int snkNeID = asnBondLine.snkNeID.intValue();
            snkNeID = 0 == snkNeID ? snkNeID : TEConfigurationDataMgr.getInstance().getNEID(snkNeID);
            buBondLine.setSrcNeID((long)srcNeID);
            buBondLine.setSnkNeID((long)snkNeID);
            buBondLine.setLineId(asnBondLine.lineId.intValue());
            buBondLine.setControlPart(asnBondLine.controlPart.intValue());
            buBondLineSet.add(buBondLine);
        }
        bu.setBondLineList(buBondLineSet);
        result = dataBaseService.updateBUInfo(bu);
        cRsp.result.retCode = BigInteger.valueOf(result);
        List<TEMarineLogInfo> logInfoList = this.getLogInfo(cReq, cRsp, info);
        this.writeLog(cReq.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
        if (0 != result) {
            cRsp.result.isSuccess = false;
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler: Update bu in database failed! Result code is " + result);
            TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler end !");
            return 0;
        }
        cRsp.result.isSuccess = true;
        TELogFactory.getNormalLogger().info("TEBUE2EModifyHandler: Modify bu result is successfule!");
        TELogFactory.getNormalLogger().info("TEBUE2EDeleteHandler end !");
        return 0;
    }

    private List<TEMarineLogInfo> getLogInfo(AsnModifyBUBondLineReq req, AsnModifyBUBondLineRsp rsp, TETaskInfo info) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        String buName = new String(req.buName);
        TEMarineLogInfo logInfo = new TEMarineLogInfo();
        logInfo.setCmdID(info.getMsgHead().cmdCode);
        logInfo.setOperateName(res.getString("bondLine"));
        logInfo.setOperateObject(buName);
        int ret = rsp.result.retCode.intValue();
        logInfo.setResult(ret);
        logInfo.setOperateDesc(this.getErrDetail(req));
        logInfo.setErrCode(ret);
        logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)ret));
        logInfoList.add(logInfo);
        return logInfoList;
    }

    private String getErrDetail(AsnModifyBUBondLineReq req) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        StringBuilder logDetailSB = new StringBuilder(res.getString("BU_NAME"));
        logDetailSB.append(":").append(new String(req.buName)).append("; ");
        logDetailSB.append(res.getString("lineIDStr")).append(":");
        int len = req.bondLineList.size();
        for (int i = 0; i < len; ++i) {
            AsnModifyBUBondLine bondline = (AsnModifyBUBondLine)req.bondLineList.get(i);
            logDetailSB.append(this.getBondLineStr(bondline));
        }
        return logDetailSB.toString();
    }

    private String getBondLineStr(AsnModifyBUBondLine bondline) {
        int srcNEID = bondline.srcNeID.intValue();
        TENE ne = TENEListMgr.getInstance().getNE(srcNEID);
        String bondLineStr = "";
        bondLineStr = null == ne ? bondLineStr + (0 == srcNEID ? "" : "UNKNOWN-") : bondLineStr + ne.getNEName() + "-";
        int snkNEID = bondline.snkNeID.intValue();
        ne = TENEListMgr.getInstance().getNE(snkNEID);
        bondLineStr = null == ne ? bondLineStr + (0 == snkNEID ? "" : "UNKNOWN-") : bondLineStr + ne.getNEName() + "-";
        bondLineStr = bondLineStr + bondline.lineId.intValue() + " ";
        return bondLineStr;
    }

    private void writeLog(int userID, String ipAddress, List<TEMarineLogInfo> logInfoList) {
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, logInfoList);
    }
}

