/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.budataoperation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEBUCommonConstants;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.util.xml.TERWCfgFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEBUDataFileOperService
implements TEBUDataOperationInterface {
    @Override
    public int deleteBU(List<String> buNameList) {
        if (null == buNameList || buNameList.isEmpty()) {
            return 0;
        }
        Document doc = null;
        try {
            doc = this.parseBUDataFile();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine BU ----- Parse buinfo file is error!");
            return 3843;
        }
        NodeList buNodeList = doc.getElementsByTagName("bu");
        if (null == buNodeList || 0 == buNodeList.getLength()) {
            return 0;
        }
        for (int i = buNodeList.getLength() - 1; i >= 0; --i) {
            Element aElement = (Element)buNodeList.item(i);
            if (!buNameList.contains(aElement.getAttribute("name"))) continue;
            aElement.getParentNode().removeChild(aElement);
        }
        doc.normalize();
        return this.writeBUDataFile(doc);
    }

    @Override
    public int queryAllBUInfo(List<TEMarineBUPO> buSet) {
        Document doc = null;
        try {
            doc = this.parseBUDataFile();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine BU ----- Parse buinfo file is error!");
            return 3843;
        }
        if (null == doc) {
            return 3840;
        }
        NodeList buNodeList = doc.getElementsByTagName("bu");
        if (null == buSet) {
            buSet = new ArrayList<TEMarineBUPO>();
        }
        TEMarineBUPO buInfo = null;
        int length = buNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node buNode = buNodeList.item(i);
            if (1 != buNode.getNodeType()) continue;
            buInfo = this.getBUInfoFromNode(buNode);
            if (null == buSet) continue;
            buSet.add(buInfo);
        }
        return 0;
    }

    private TEMarineBUPO getBUInfoFromNode(Node buNode) {
        if (null == buNode || 1 != buNode.getNodeType()) {
            return null;
        }
        TEMarineBUPO buInfo = new TEMarineBUPO();
        Set buPortSet = buInfo.getPortList();
        Element buElement = (Element)buNode;
        buInfo.setBuName(buElement.getAttribute("name"));
        buInfo.setType(Integer.parseInt(buElement.getAttribute("type")));
        buInfo.setMacAddr(buElement.getAttribute("macaddr"));
        buInfo.setPressure(Integer.valueOf(buElement.getAttribute("pressure")).intValue());
        NodeList childNodeList = buNode.getChildNodes();
        int childLen = childNodeList.getLength();
        for (int i = 0; i < childLen; ++i) {
            Node childNode = childNodeList.item(i);
            if (1 != childNode.getNodeType()) continue;
            if (childNode.getNodeName().startsWith("port")) {
                TEBUPortPO buPort = this.parseBUPort(childNode);
                if (null == buPort) continue;
                buPortSet.add(buPort);
                continue;
            }
            if (childNode.getNodeName().equals("lineinfoList")) {
                buInfo.setBondLineList(this.parseBUBondLine(childNode.getChildNodes()));
                continue;
            }
            if (childNode.getNodeName().equals("mainbridge")) {
                buInfo.setPrimaryLine(Integer.parseInt(((Element)childNode).getAttribute("value")));
                continue;
            }
            if (!childNode.getNodeName().equals("lastOperTime")) continue;
            buInfo.setLastOperTime(((Element)childNode).getAttribute("value"));
        }
        return buInfo;
    }

    private TEBUPortPO parseBUPort(Node portInfoNode) {
        NodeList elecDirectionList;
        NodeList isEarthList;
        NodeList bondPFENodeList;
        if (null == portInfoNode || 1 != portInfoNode.getNodeType() || 0 == portInfoNode.getChildNodes().getLength()) {
            return null;
        }
        TEBUPortPO buPort = new TEBUPortPO();
        String portNodeName = portInfoNode.getNodeName();
        buPort.setPortName(String.valueOf(portNodeName.charAt(portNodeName.length() - 1)));
        NodeList bondSLMNodeList = ((Element)portInfoNode).getElementsByTagName("bondSLM");
        if (null != bondSLMNodeList && null != bondSLMNodeList.item(0)) {
            buPort.setBondSLM(((Element)bondSLMNodeList.item(0)).getAttribute("value"));
        }
        if (null != (bondPFENodeList = ((Element)portInfoNode).getElementsByTagName("bondPFE")) && null != bondPFENodeList.item(0)) {
            buPort.setBondPFE(((Element)bondPFENodeList.item(0)).getAttribute("value"));
        }
        if (null != (isEarthList = ((Element)portInfoNode).getElementsByTagName("isEarth")) && null != isEarthList.item(0)) {
            buPort.setIsEarth((int)Short.parseShort(((Element)isEarthList.item(0)).getAttribute("value")));
        }
        if (null != (elecDirectionList = ((Element)portInfoNode).getElementsByTagName("elecDirection")) && null != elecDirectionList.item(0)) {
            buPort.setElecDirection(Integer.parseInt(((Element)elecDirectionList.item(0)).getAttribute("value")));
        }
        return buPort;
    }

    private Set<TEBUBondLinePO> parseBUBondLine(NodeList bondLineList) {
        if (null == bondLineList || 0 == bondLineList.getLength()) {
            return null;
        }
        HashSet<TEBUBondLinePO> bondlineSet = new HashSet<TEBUBondLinePO>();
        int lineLen = bondLineList.getLength();
        for (int i = 0; i < lineLen; ++i) {
            Node lineNode = bondLineList.item(i);
            if (1 != lineNode.getNodeType()) continue;
            TEBUBondLinePO bondLine = new TEBUBondLinePO();
            Element te = (Element)lineNode;
            bondLine.setLineId(Integer.parseInt(te.getAttribute("id")));
            bondLine.setControlPart(Integer.parseInt(te.getAttribute("controlPort")));
            bondLine.setSrcNeID((long)Integer.parseInt(te.getAttribute("srcneid")));
            bondLine.setSnkNeID((long)Integer.parseInt(te.getAttribute("snkneid")));
            bondlineSet.add(bondLine);
        }
        return bondlineSet;
    }

    @Override
    public int queryBUInfoByName(String buName, List<TEMarineBUPO> buList) {
        ArrayList<TEMarineBUPO> buSet = new ArrayList<TEMarineBUPO>();
        int resultCode = this.queryAllBUInfo(buSet);
        if (null == buSet || buSet.isEmpty()) {
            return resultCode;
        }
        if (null == buList) {
            buList = new ArrayList<TEMarineBUPO>();
        }
        for (TEMarineBUPO tmpBu : buSet) {
            if (!buName.equals(tmpBu.getBuName())) continue;
            buList.add(tmpBu);
            return 0;
        }
        return 1090615228;
    }

    @Override
    public int queryBUInfoByNeid(int neid, List<TEMarineBUPO> bondNEBUSet) {
        ArrayList<TEMarineBUPO> buSet = new ArrayList<TEMarineBUPO>();
        int resultCode = this.queryAllBUInfo(buSet);
        if (0 != resultCode) {
            return resultCode;
        }
        if (null == buSet || buSet.isEmpty()) {
            return 0;
        }
        if (null == bondNEBUSet) {
            bondNEBUSet = new ArrayList<TEMarineBUPO>();
        }
        block0: for (TEMarineBUPO bu : buSet) {
            Set buPortSet = bu.getPortList();
            for (TEBUPortPO buPort : buPortSet) {
                TENE ne = TENEListMgr.getInstance().getNE(neid);
                if (null == ne || !buPort.getBondSLM().contains(String.valueOf(ne.getRealNEID()))) continue;
                bondNEBUSet.add(bu);
                continue block0;
            }
        }
        return 0;
    }

    @Override
    public int createBUInfo(TEMarineBUPO bu) {
        Document doc = this.parseBUDataFile();
        if (null == doc) {
            TELogFactory.getNormalLogger().error("Marine----Create BU in file system fail!");
            return 3843;
        }
        Element buElement = this.findBUElement(doc, bu.getBuName());
        if (null == buElement) {
            if (this.isMacExist(bu)) {
                TELogFactory.getNormalLogger().error("Marine----Create BU in file system fail! BU is exist!");
                return 1090615085;
            }
        } else {
            TELogFactory.getNormalLogger().error("Marine----Create BU in file system fail! BU is exist!");
            return 1090615074;
        }
        this.addBUNode(bu, doc);
        doc.normalize();
        return this.writeBUDataFile(doc);
    }

    @Override
    public int updateBUInfo(TEMarineBUPO bu) {
        if (this.isMacExist(bu)) {
            TELogFactory.getNormalLogger().error("Marine----Modify BU in file system fail! BU is exist!");
            return 1090615085;
        }
        Document doc = this.parseBUDataFile();
        if (null == doc) {
            TELogFactory.getNormalLogger().error("Marine----Update BU in file system fail!");
            return 3843;
        }
        Element buElement = this.findBUElement(doc, bu.getBuName());
        if (null == buElement) {
            TELogFactory.getNormalLogger().error("Marine----Update BU in file system fail! BU is not exist!");
            return 3843;
        }
        this.modifyBUNode(bu, buElement, doc);
        doc.normalize();
        return this.writeBUDataFile(doc);
    }

    public Element findBUElement(Document doc, String buName) {
        if (null == doc || null == buName || "".equals(buName)) {
            return null;
        }
        NodeList buNodeList = doc.getElementsByTagName("bu");
        int buNodeLen = buNodeList.getLength();
        for (int i = 0; i < buNodeLen; ++i) {
            Element buElement;
            if (buNodeList.item(i).getNodeType() != 1 || !(buElement = (Element)buNodeList.item(i)).getAttribute("name").equals(buName)) continue;
            return buElement;
        }
        return null;
    }

    private Document parseBUDataFile() {
        File file = TERWCfgFile.getBundleRWCfgFileObj(this.getClass(), (String)TEBUCommonConstants.BUINFO_FILEPATH);
        Document doc = TEParseXMLFile.parseFile((File)file);
        return doc;
    }

    private void addBUNode(TEMarineBUPO bu, Document doc) {
        if (null == bu) {
            return;
        }
        Element buElement = doc.createElement("bu");
        buElement.setAttribute("name", bu.getBuName());
        buElement.setAttribute("type", String.valueOf(bu.getType()));
        buElement.setAttribute("macaddr", bu.getMacAddr());
        buElement.setAttribute("pressure", String.valueOf(bu.getPressure()));
        DocumentFragment docFrag = doc.createDocumentFragment();
        if (null != bu.getPortList() && 0 != bu.getPortList().size()) {
            this.createBUPortNodes(bu.getPortList(), docFrag, doc);
        }
        Element bondLineElm = null;
        if (null != bu.getBondLineList() && 0 != bu.getBondLineList().size()) {
            bondLineElm = this.createBondLineList(bu.getBondLineList(), doc);
        }
        if (null != bondLineElm) {
            docFrag.appendChild(bondLineElm);
        }
        Element primaryLineElm = doc.createElement("mainbridge");
        primaryLineElm.setAttribute("value", String.valueOf(bu.getPrimaryLine()));
        docFrag.appendChild(primaryLineElm);
        Element lastOperTimeElm = doc.createElement("lastOperTime");
        lastOperTimeElm.setAttribute("value", String.valueOf(bu.getLastOperTime()));
        docFrag.appendChild(lastOperTimeElm);
        buElement.appendChild(docFrag);
        doc.getDocumentElement().appendChild(buElement);
    }

    private void createBUPortNodes(Set<TEBUPortPO> buPortSet, DocumentFragment docFrag, Document doc) {
        if (null == buPortSet || buPortSet.isEmpty() || null == docFrag) {
            return;
        }
        for (TEBUPortPO buPort : buPortSet) {
            Element portElm = doc.createElement("port" + buPort.getPortName());
            DocumentFragment portFrag = doc.createDocumentFragment();
            Element innerElm = doc.createElement("bondSLM");
            innerElm.setAttribute("value", String.valueOf(buPort.getBondSLM()));
            portFrag.appendChild(innerElm);
            innerElm = doc.createElement("bondPFE");
            innerElm.setAttribute("value", String.valueOf(buPort.getBondPFE()));
            portFrag.appendChild(innerElm);
            innerElm = doc.createElement("isEarth");
            innerElm.setAttribute("value", String.valueOf(buPort.getIsEarth()));
            portFrag.appendChild(innerElm);
            innerElm = doc.createElement("elecDirection");
            innerElm.setAttribute("value", String.valueOf(buPort.getElecDirection()));
            portFrag.appendChild(innerElm);
            portElm.appendChild(portFrag);
            docFrag.appendChild(portElm);
        }
    }

    private Element createBondLineList(Set<TEBUBondLinePO> bondLineSet, Document doc) {
        if (null == doc || null == bondLineSet || bondLineSet.isEmpty()) {
            return null;
        }
        Element bondLineElm = doc.createElement("lineinfoList");
        DocumentFragment bondLineFrg = doc.createDocumentFragment();
        for (TEBUBondLinePO bondLine : bondLineSet) {
            Element lineElm = doc.createElement("line");
            lineElm.setAttribute("id", String.valueOf(bondLine.getLineId()));
            lineElm.setAttribute("controlPort", String.valueOf(bondLine.getControlPart()));
            lineElm.setAttribute("srcneid", String.valueOf(bondLine.getSrcNeID()));
            lineElm.setAttribute("snkneid", String.valueOf(bondLine.getSnkNeID()));
            bondLineFrg.appendChild(lineElm);
        }
        bondLineElm.appendChild(bondLineFrg);
        return bondLineElm;
    }

    private void modifyBUNode(TEMarineBUPO bu, Element buElement, Document doc) {
        if (null == bu || null == buElement) {
            return;
        }
        buElement.setAttribute("type", String.valueOf(bu.getType()));
        buElement.setAttribute("macaddr", bu.getMacAddr());
        buElement.setAttribute("pressure", String.valueOf(bu.getPressure()));
        this.modifyBUPortInfo(bu.getPortList(), buElement);
        this.modifyBUBondLineInfo(bu.getBondLineList(), buElement, doc);
        NodeList primaryLineNodeList = buElement.getElementsByTagName("mainbridge");
        Node primaryLineLine = null;
        if (null != primaryLineNodeList && 0 != primaryLineNodeList.getLength()) {
            primaryLineLine = primaryLineNodeList.item(0);
        }
        if (null != primaryLineLine) {
            ((Element)primaryLineLine).setAttribute("value", String.valueOf(bu.getPrimaryLine()));
        }
        NodeList lastOperTimeNodeList = buElement.getElementsByTagName("lastOperTime");
        Node lastOperTime = null;
        if (null != lastOperTimeNodeList && 0 != lastOperTimeNodeList.getLength()) {
            lastOperTime = lastOperTimeNodeList.item(0);
        }
        if (null != lastOperTime) {
            ((Element)lastOperTime).setAttribute("value", String.valueOf(bu.getLastOperTime()));
        }
    }

    private void modifyBUPortInfo(Set<TEBUPortPO> buPortSet, Element buElement) {
        if (null == buPortSet || null == buElement || null == buElement.getChildNodes() || 0 == buElement.getChildNodes().getLength()) {
            return;
        }
        NodeList childNodeList = buElement.getChildNodes();
        int childlen = childNodeList.getLength();
        for (int i = 0; i < childlen; ++i) {
            Node aNode = childNodeList.item(i);
            if (aNode.getNodeType() != 1 || !aNode.getNodeName().startsWith("port")) continue;
            this.modifyPortElm(buPortSet, (Element)aNode);
        }
    }

    private void modifyPortElm(Set<TEBUPortPO> buPortSet, Element buPortElm) {
        if (null == buPortSet || null == buPortElm) {
            return;
        }
        String bondSlm = "-1";
        String bondPfe = "-1";
        int isEarth = 0;
        int elecDirection = 0;
        for (TEBUPortPO buPort : buPortSet) {
            if (!buPortElm.getNodeName().endsWith(String.valueOf(buPort.getPortName()))) continue;
            bondSlm = buPort.getBondSLM();
            bondPfe = buPort.getBondPFE();
            isEarth = buPort.getIsEarth();
            elecDirection = buPort.getElecDirection();
            break;
        }
        this.setElementValue(buPortElm, "bondSLM", String.valueOf(bondSlm));
        this.setElementValue(buPortElm, "bondPFE", String.valueOf(bondPfe));
        this.setElementValue(buPortElm, "isEarth", String.valueOf(isEarth));
        this.setElementValue(buPortElm, "elecDirection", String.valueOf(elecDirection));
    }

    private void setElementValue(Element buPortElm, String tagName, String value) {
        NodeList nodeList = buPortElm.getElementsByTagName(tagName);
        Element aElm = null;
        if (null != nodeList && 0 != nodeList.getLength()) {
            aElm = (Element)nodeList.item(0);
            aElm.setAttribute("value", value);
        }
    }

    private void modifyBUBondLineInfo(Set<TEBUBondLinePO> bondLineSet, Element buElement, Document doc) {
        Element lineListElm;
        if (null == buElement) {
            return;
        }
        NodeList nodeList = buElement.getElementsByTagName("lineinfoList");
        Node lineListNode = null;
        if (null != nodeList && 0 != nodeList.getLength()) {
            lineListNode = nodeList.item(0);
            buElement.removeChild(lineListNode);
        }
        if (null != (lineListElm = this.createBondLineList(bondLineSet, doc))) {
            buElement.appendChild(lineListElm);
        }
    }

    private synchronized int writeBUDataFile(Document doc) {
        try {
            boolean isSucc;
            DOMSource source = new DOMSource(doc);
            String realFilePath = "";
            realFilePath = TERWCfgFile.getBundleRWCfgFilePath(this.getClass(), (String)TEBUCommonConstants.BUINFO_FILEPATH);
            File file = new File(realFilePath);
            StreamResult result = new StreamResult(file);
            if (!file.canWrite() && !(isSucc = file.delete())) {
                return 1052;
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return 0;
        }
        catch (TransformerConfigurationException e) {
            return 1052;
        }
        catch (TransformerException e) {
            return 1052;
        }
    }

    private boolean isMacExist(TEMarineBUPO buPO) {
        if (null == buPO) {
            return false;
        }
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        int result = this.queryAllBUInfo(buList);
        if (0 == result && null != buList && !buList.isEmpty()) {
            for (TEMarineBUPO tmpBuPO : buList) {
                if (tmpBuPO.getBuName().equals(buPO.getBuName()) || !tmpBuPO.getMacAddr().equalsIgnoreCase(buPO.getMacAddr())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public TEMarineBUPO getBUInfoByAddress(String buAddr) {
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        int result = this.queryAllBUInfo(buList);
        if (0 == result && null != buList && 0 != buList.size()) {
            for (TEMarineBUPO tmpBuPO : buList) {
                if (!tmpBuPO.getMacAddr().equalsIgnoreCase(buAddr)) continue;
                return tmpBuPO;
            }
        }
        return null;
    }
}

