/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement.budataoperation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TEBUDataBaseOperService
implements TEBUDataOperationInterface {
    @Override
    public int deleteBU(List<String> buNameList) {
        if (null == buNameList || buNameList.isEmpty()) {
            return 0;
        }
        ArrayList<TEDaoNameValuePair> deleteCriterion = new ArrayList<TEDaoNameValuePair>();
        for (String buName : buNameList) {
            TEDaoNameValuePair aPair = new TEDaoNameValuePair("BuName", buName);
            deleteCriterion.add(aPair);
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.deleteByID(TEMarineBUPO.class, deleteCriterion);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine----Delete BU in DataBase fail!", (Throwable)e);
            return 1092743443;
        }
        return dbResult.getResult();
    }

    @Override
    public int queryAllBUInfo(List<TEMarineBUPO> buSet) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineBUPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine----Find all BU in DataBase fail!", (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            return 1092743443;
        }
        List objList = dbResult.getData();
        if (null == buSet) {
            buSet = new ArrayList<TEMarineBUPO>();
        }
        for (Object obj : objList) {
            buSet.add((TEMarineBUPO)obj);
        }
        return dbResult.getResult();
    }

    @Override
    public int queryBUInfoByName(String buName, List<TEMarineBUPO> buList) {
        TEDaoOperationResult dbResult = null;
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("BuName", buName);
        criteria.add(aPair);
        try {
            dbResult = TECommonDaoService.findByID(TEMarineBUPO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine----Find BU by name in DataBase fail!", (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            return 1092743443;
        }
        if (null == buList) {
            buList = new ArrayList<TEMarineBUPO>();
        }
        List objList = dbResult.getData();
        for (Object obj : objList) {
            buList.add((TEMarineBUPO)obj);
        }
        return dbResult.getResult();
    }

    @Override
    public int queryBUInfoByNeid(int neid, List<TEMarineBUPO> bondNeBUSet) {
        ArrayList<TEMarineBUPO> buSet = new ArrayList<TEMarineBUPO>();
        int resultCode = this.queryAllBUInfo(buSet);
        if (null == bondNeBUSet) {
            bondNeBUSet = new ArrayList<TEMarineBUPO>();
        }
        Set buPortSet = null;
        block0: for (TEMarineBUPO bu : buSet) {
            buPortSet = bu.getPortList();
            if (null == buPortSet || buPortSet.isEmpty()) continue;
            for (TEBUPortPO buPort : buPortSet) {
                TENE ne = TENEListMgr.getInstance().getNE(neid);
                if (null == ne || !buPort.getBondSLM().contains(String.valueOf(ne.getRealNEID()))) continue;
                bondNeBUSet.add(bu);
                continue block0;
            }
        }
        return resultCode;
    }

    @Override
    public int createBUInfo(TEMarineBUPO bu) {
        if (bu != null && null != bu.getBuName() && !bu.getBuName().equals("")) {
            ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
            int result = this.queryBUInfoByName(bu.getBuName(), buList);
            if (0 == result && null != buList && !buList.isEmpty()) {
                return 1090615074;
            }
        }
        if (this.isMacExist(bu)) {
            return 1090615085;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((Object)bu);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine----Create BU in DataBase fail!", (Throwable)e);
            return 1092743443;
        }
        return dbResult.getResult();
    }

    @Override
    public int updateBUInfo(TEMarineBUPO bu) {
        if (this.isMacExist(bu)) {
            return 1090615085;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)bu);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine----Update BU in DataBase fail!", (Throwable)e);
            return 1092743443;
        }
        return dbResult.getResult();
    }

    @Override
    public TEMarineBUPO getBUInfoByAddress(String buAddr) {
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        int result = this.queryAllBUInfo(buList);
        if (0 == result && null != buList && !buList.isEmpty()) {
            for (TEMarineBUPO tmpBuPO : buList) {
                if (!tmpBuPO.getMacAddr().equalsIgnoreCase(buAddr)) continue;
                return tmpBuPO;
            }
        }
        return null;
    }

    private boolean isMacExist(TEMarineBUPO buPO) {
        if (null == buPO) {
            return false;
        }
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        int result = this.queryAllBUInfo(buList);
        if (0 == result && null != buList && !buList.isEmpty()) {
            for (TEMarineBUPO tmpBuPO : buList) {
                if (tmpBuPO.getBuName().equals(buPO.getBuName()) || !tmpBuPO.getMacAddr().equalsIgnoreCase(buPO.getMacAddr())) continue;
                return true;
            }
        }
        return false;
    }
}

