/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TESetBUStatusBean
extends TECommonWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            int resultCode;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.modifyInputParams();
            this.outputData = new Datainterface();
            TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
            if (null == inputData || null == inputData.getBussinessParams()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                return this.outputData;
            }
            ArrayList rowList = inputData.getBussinessParams().getRowParamList();
            if (null == rowList || 0 == rowList.size()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                return this.outputData;
            }
            TEMarineBUPO buPO = this.getBU(rowList, buDataOperService);
            if (null != buPO) {
                this.setBUStatus(rowList, buPO);
                resultCode = buDataOperService.updateBUInfo(buPO);
            } else {
                resultCode = 1090615228;
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultCode));
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception ex1) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)ex1);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private TEMarineBUPO getBU(List<RowParams> rowList, TEBUDataOperationInterface buDataOperService) {
        RowParams row = rowList.get(0);
        if (null == row.getParam("buname")) {
            return null;
        }
        String buName = row.getParam("buname").getValue();
        ArrayList<TEMarineBUPO> buSet = new ArrayList<TEMarineBUPO>();
        buDataOperService.queryBUInfoByName(buName, buSet);
        if (null == buSet || 0 == buSet.size()) {
            return null;
        }
        TEMarineBUPO buPO = (TEMarineBUPO)buSet.get(0);
        return buPO;
    }

    private void setBUStatus(List<RowParams> rowList, TEMarineBUPO buPO) {
        RowParams row = rowList.get(0);
        if (null == row || null == buPO || null == row.getParam("buname") || !row.getParam("buname").getValue().equals(buPO.getBuName())) {
            return;
        }
        int statusFlg = Integer.parseInt(row.getParam("statusFlg").getValue());
        if (null != row.getParam("mainbridge")) {
            this.setBUPrimaryLine(statusFlg, buPO, row.getParam("mainbridge").getValue());
        }
        this.setBUPortDirection(statusFlg, buPO, row);
        this.setBUPortIsEarth(statusFlg, buPO, row);
    }

    private void setBUPrimaryLine(int statusFlg, TEMarineBUPO buPO, String primaryLine) {
        buPO.setPrimaryLine(Integer.parseInt(primaryLine));
    }

    private void setBUPortDirection(int statusFlg, TEMarineBUPO buPO, RowParams row) {
        Set buPorts = buPO.getPortList();
        for (TEBUPortPO buPort : buPorts) {
            if (null == row.getParam(buPort.getPortName().toLowerCase() + "elecdir")) continue;
            String dirValue = row.getParam(buPort.getPortName().toLowerCase() + "elecdir").getValue();
            buPort.setElecDirection(Integer.parseInt(dirValue));
        }
    }

    private void setBUPortIsEarth(int statusFlg, TEMarineBUPO buPO, RowParams row) {
        Set buPorts = buPO.getPortList();
        for (TEBUPortPO buPort : buPorts) {
            if (null == row.getParam(buPort.getPortName().toLowerCase() + "isearth")) continue;
            String dirValue = row.getParam(buPort.getPortName().toLowerCase() + "isearth").getValue();
            buPort.setIsEarth(Integer.parseInt(dirValue));
        }
    }
}

