/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEBUPFEOperations;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Set;

public class TERefreshBUStatusBean
extends TENEExplorerBean {
    private TEMarineBUPO bu = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.modifyInputParams();
            this.outputData = new Datainterface();
            int errCode = this.resetBUStatus();
            if (0 == errCode) {
                errCode = this.resetPFEBingding();
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errCode));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private int resetBUStatus() {
        if (null == this.inputData || null == this.inputData.getBussinessParams() || 0 == this.inputData.getBussinessParams().getRowParamsCount()) {
            return 2;
        }
        int errCode = 0;
        RowParams rowParam = this.inputData.getBussinessParams().getRowParams(0);
        String buName = rowParam.getParam("buname").getValue();
        TEBUDataOperationInterface dataOperService = TEMarineBUUtil.getBUDataOperationHandler();
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        errCode = dataOperService.queryBUInfoByName(buName, buList);
        if (!buList.isEmpty()) {
            this.bu = (TEMarineBUPO)buList.get(0);
            int step = Integer.parseInt(rowParam.getParam("step").getValue());
            if (0 == step) {
                this.bu.setPrimaryLine(0);
                Set buPortSet = this.bu.getPortList();
                for (TEBUPortPO buPort : buPortSet) {
                    buPort.setIsEarth(1);
                }
            } else {
                this.secondStepSetBUStatus();
            }
            dataOperService.updateBUInfo(this.bu);
        }
        return errCode;
    }

    private void secondStepSetBUStatus() {
        RowParams rowParam = this.inputData.getBussinessParams().getRowParams(0);
        Set buPortSet = this.bu.getPortList();
        for (TEBUPortPO buPort : buPortSet) {
            char buPortName = buPort.getPortName().charAt(0);
            int currency = buPort.getElecDirection();
            int isEarth = buPort.getIsEarth();
            switch (buPortName) {
                case 'A': {
                    currency = Integer.parseInt(rowParam.getParam("aelecdir").getValue());
                    isEarth = Integer.parseInt(rowParam.getParam("aisearth").getValue());
                    break;
                }
                case 'B': {
                    currency = Integer.parseInt(rowParam.getParam("belecdir").getValue());
                    isEarth = Integer.parseInt(rowParam.getParam("bisearth").getValue());
                    break;
                }
                case 'C': {
                    currency = Integer.parseInt(rowParam.getParam("celecdir").getValue());
                    isEarth = Integer.parseInt(rowParam.getParam("cisearth").getValue());
                    break;
                }
            }
            buPort.setElecDirection(currency);
            buPort.setIsEarth(isEarth);
        }
        this.bu.setPrimaryLine(Integer.parseInt(rowParam.getParam("mainbridge").getValue()));
    }

    private int resetPFEBingding() {
        int errCode = 0;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            errCode = TEBUPFEOperations.reBindPFE(this.bu);
        }
        return errCode;
    }
}

