/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEBUPFEOperations;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQueryBUStatusBean
extends TECommonWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
            ArrayList rowList = inputData.getBussinessParams().getRowParamList();
            String buName = "";
            if (null != rowList && !rowList.isEmpty()) {
                RowParams row = (RowParams)rowList.get(0);
                buName = null == row.getParam("buname") ? "" : row.getParam("buname").getValue();
            }
            ArrayList<TEMarineBUPO> buPOList = new ArrayList<TEMarineBUPO>();
            int result = !"".equals(buName) ? buDataOperService.queryBUInfoByName(buName, buPOList) : 2;
            BussinessParams bsparam = new BussinessParams();
            this.outputData.setBussinessParams(bsparam);
            this.handleReturnMessage(buPOList);
            if (0 != result) {
                this.handleErrMessage(result, buName);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine------Query BU performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private void handleErrMessage(int result, String buName) {
        RowErrors rowError = new RowErrors();
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        if (!"".equals(buName)) {
            Param param = new Param("buname", buName);
            rowError.addParam(param);
        } else {
            Param param = new Param("neid", String.valueOf(this.neid));
            rowError.addParam(param);
        }
        RowParams row = new RowParams();
        row.addRowErrors(rowError);
        this.outputData.getBussinessParams().addRowParams(row);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
    }

    private void handleReturnMessage(List<TEMarineBUPO> buPOList) {
        if (null == buPOList || 0 == buPOList.size()) {
            return;
        }
        BussinessParams bsparam = this.outputData.getBussinessParams();
        TEMarineBUPO bu = buPOList.get(0);
        RowParams row = new RowParams();
        Param param = new Param("buname", bu.getBuName());
        row.addParam(param);
        param = new Param("mainbridge", this.getMainBridge(bu));
        row.addParam(param);
        if (null == bu.getPortList() || bu.getPortList().isEmpty()) {
            return;
        }
        Map<String, TEMarinePowerSupplyUnitPO> psuMap = null;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            psuMap = TEMarineBUUtil.doQueryPSUs();
        }
        for (TEBUPortPO buPort : bu.getPortList()) {
            param = new Param(buPort.getPortName().toLowerCase() + "bondpfe", this.getPFEStr(buPort.getBondPFE()));
            row.addParam(param);
            param = new Param(buPort.getPortName().toLowerCase() + "pfevoltage", this.getPFEVoltage(buPort.getBondPFE(), psuMap));
            row.addParam(param);
            param = new Param(buPort.getPortName().toLowerCase() + "isearth", this.getBUPortIsEarth(buPort));
            row.addParam(param);
            param = new Param(buPort.getPortName().toLowerCase() + "elecdir", this.getBUPortCurDir(buPort));
            row.addParam(param);
        }
        bsparam.addRowParams(row);
    }

    private String getMainBridge(TEMarineBUPO bu) {
        return String.valueOf(bu.getPrimaryLine());
    }

    private String getBUPortIsEarth(TEBUPortPO buPort) {
        return String.valueOf(buPort.getIsEarth());
    }

    private String getBUPortCurDir(TEBUPortPO buPort) {
        return String.valueOf(buPort.getElecDirection());
    }

    private String getPFEStr(String pfeName) {
        if (null == pfeName || "0".equals(pfeName)) {
            return "-";
        }
        return pfeName;
    }

    private String getPFEVoltage(String pfeName, Map<String, TEMarinePowerSupplyUnitPO> psuMap) {
        TEMarinePowerSupplyUnitPO psu;
        if ("SE".equals(pfeName) || "-".equals(pfeName) || "0".equals(pfeName)) {
            return "";
        }
        if (TESysManagerBean.getInstance().isIntegratedStatus() && psuMap != null && (psu = psuMap.get(pfeName)) != null) {
            return String.valueOf(psu.getVoltage());
        }
        HashMap pfeMap = new HashMap();
        int ret = TEBUPFEOperations.getPFEVoltageHandler(pfeName, pfeMap);
        String voltage = "";
        if (0 == ret) {
            voltage = String.valueOf(pfeMap.get("pfeVoltage"));
        }
        return voltage;
    }
}

