/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TEQueryBUBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
            ArrayList rowList = inputData.getBussinessParams().getRowParamList();
            String buName = "";
            if (null != rowList && !rowList.isEmpty()) {
                RowParams row = (RowParams)rowList.get(0);
                buName = null == row.getParam("buname") ? "" : row.getParam("buname").getValue();
            }
            ArrayList<TEMarineBUPO> buPOList = new ArrayList<TEMarineBUPO>();
            int result = "".equals(buName) ? buDataOperService.queryBUInfoByNeid(neid, buPOList) : buDataOperService.queryBUInfoByName(buName, buPOList);
            BussinessParams bsparam = new BussinessParams();
            this.outputData.setBussinessParams(bsparam);
            this.handleReturnMessage(buPOList);
            if (!"".equals(buName) && 0 == result && null != buPOList && buPOList.isEmpty()) {
                result = 1090615228;
            }
            if (0 == result) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else {
                this.handleErrMessage(result, buName);
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine------Query BU performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private void handleErrMessage(int result, String buName) {
        RowErrors rowError = new RowErrors();
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        if ("".equals(buName)) {
            Param param = new Param("neid", String.valueOf(this.neid));
            rowError.addParam(param);
        } else {
            Param param = new Param("buname", buName);
            rowError.addParam(param);
        }
        RowParams row = new RowParams();
        row.addRowErrors(rowError);
        this.outputData.getBussinessParams().addRowParams(row);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
    }

    private void handleReturnMessage(List<TEMarineBUPO> buPOList) {
        if (null == buPOList || buPOList.isEmpty()) {
            return;
        }
        Collections.sort(buPOList);
        BussinessParams bsparam = this.outputData.getBussinessParams();
        if (null == bsparam) {
            bsparam = new BussinessParams();
            this.outputData.setBussinessParams(bsparam);
        }
        for (TEMarineBUPO bu : buPOList) {
            RowParams row = new RowParams();
            Param param = new Param("buname", bu.getBuName());
            row.addParam(param);
            param = new Param("macaddr", bu.getMacAddr());
            row.addParam(param);
            param = new Param("type", String.valueOf(bu.getType()));
            row.addParam(param);
            param = new Param("pressure", String.valueOf(bu.getPressure()));
            row.addParam(param);
            param = new Param("mainbridge", String.valueOf(bu.getPrimaryLine()));
            row.addParam(param);
            param = new Param("lastpertime", String.valueOf(bu.getPrimaryLine()));
            row.addParam(param);
            param = new Param("posx", String.valueOf(bu.getPosX()));
            row.addParam(param);
            param = new Param("posy", String.valueOf(bu.getPosX()));
            row.addParam(param);
            this.addPortParams(row, bu.getPortList());
            bsparam.addRowParams(row);
        }
    }

    private void addPortParams(RowParams row, Set<TEBUPortPO> buPortSet) {
        int MARINEPSU_NETYPE = -2027;
        if (null == buPortSet || buPortSet.isEmpty()) {
            return;
        }
        for (TEBUPortPO buPort : buPortSet) {
            String portName = String.valueOf(buPort.getPortName()).toLowerCase();
            Param param = new Param(portName + "bondslm", this.convertNeid(buPort.getBondSLM()));
            row.addParam(param);
            param = new Param(portName + "bondslmname", this.getSLMNEName(buPort.getBondSLM()));
            row.addParam(param);
            String pfeNeid = this.convertPFENeid(buPort.getBondPFE());
            String pfeName = this.getNEName(buPort.getBondPFE());
            if (TESysManagerBean.getInstance().isIntegratedStatus() && "unknown".equals(pfeName)) {
                for (TEMarinePowerSupplyUnitPO psu : TEMarineBUUtil.doQueryPSUs().values()) {
                    if (!psu.getName().equals(buPort.getBondPFE())) continue;
                    pfeNeid = String.valueOf(-2027);
                    pfeName = buPort.getBondPFE();
                    break;
                }
            }
            param = new Param(portName + "bondpfe", pfeNeid);
            row.addParam(param);
            param = new Param(portName + "bondpfename", pfeName);
            row.addParam(param);
            param = new Param(portName + "isearth", String.valueOf(buPort.getIsEarth()));
            row.addParam(param);
            param = new Param(portName + "elecdir", String.valueOf(buPort.getElecDirection()));
            row.addParam(param);
        }
    }

    private String getSLMNEName(String bondNEId) {
        if ("0".equals(bondNEId) || "-1".equals(bondNEId)) {
            return "-";
        }
        StringBuilder bondNeNameStr = new StringBuilder();
        String[] bondNeids = bondNEId.split(",");
        HashSet<String> neidSet = new HashSet<String>();
        for (int i = 0; i < bondNeids.length; ++i) {
            TENE ne = TENEListMgr.getInstance().getPhyNE(Integer.parseInt(bondNeids[i]));
            if (null == ne || neidSet.contains(bondNeids[i])) continue;
            if (!"".equals(bondNeNameStr.toString())) {
                bondNeNameStr.append(",");
            }
            bondNeNameStr.append(ne.getNEName());
            neidSet.add(bondNeids[i]);
        }
        if (bondNeNameStr.toString().equals("")) {
            bondNeNameStr.append("-");
        }
        return bondNeNameStr.toString();
    }

    private String getNEName(String pfeNeName) {
        if (null == pfeNeName || "0".equals(pfeNeName)) {
            return "-";
        }
        if ("SE".equals(pfeNeName)) {
            return pfeNeName;
        }
        TENE ne = TENEListMgr.getInstance().getTL1NEByNEName(pfeNeName);
        if (null == ne) {
            return "unknown";
        }
        return pfeNeName;
    }

    private String convertNeid(String aNEID) {
        if ("0".equals(aNEID)) {
            return "-1";
        }
        String[] aNeIDs = aNEID.split(",");
        StringBuilder logcNeIDStr = new StringBuilder();
        HashSet<String> neidSet = new HashSet<String>();
        for (int i = 0; i < aNeIDs.length; ++i) {
            TENE ne = TENEListMgr.getInstance().getPhyNE(Integer.parseInt(aNeIDs[i]));
            if (null == ne || neidSet.contains(aNeIDs[i])) continue;
            if (!"".equals(logcNeIDStr.toString())) {
                logcNeIDStr.append(",");
            }
            logcNeIDStr.append(ne.getNEID());
            neidSet.add(aNeIDs[i]);
        }
        if (logcNeIDStr.toString().equals("")) {
            logcNeIDStr.append("-1");
        }
        return logcNeIDStr.toString();
    }

    private String convertPFENeid(String pfeName) {
        if (null == pfeName || "0".equals(pfeName)) {
            return "-1";
        }
        if ("SE".equals(pfeName)) {
            return "0";
        }
        TENE tl1Ne = TENEListMgr.getInstance().getTL1NEByNEName(pfeName);
        if (null == tl1Ne) {
            return "0";
        }
        return String.valueOf(tl1Ne.getNEID());
    }
}

