/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.TECreateBUBean;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TEModifyBUInfoBean
extends TECreateBUBean {
    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            int resultCode;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.modifyInputParams();
            this.outputData = new Datainterface();
            TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
            this.buPO = this.getBUInfomation(buDataOperService);
            if (null == this.buPO) {
                resultCode = 1090615228;
            } else {
                this.setBUInfomation(this.buPO);
                resultCode = buDataOperService.updateBUInfo(this.buPO);
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultCode));
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)ex);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private TEMarineBUPO getBUInfomation(TEBUDataOperationInterface buDataOperService) {
        if (null == this.inputData || null == this.inputData.getBussinessParams()) {
            return null;
        }
        ArrayList rowList = this.inputData.getBussinessParams().getRowParamList();
        if (null == rowList || rowList.isEmpty()) {
            return null;
        }
        RowParams row = (RowParams)rowList.get(0);
        if (null == row.getParam("buname")) {
            return null;
        }
        String buName = row.getParam("buname").getValue();
        ArrayList<TEMarineBUPO> buSet = new ArrayList<TEMarineBUPO>();
        buDataOperService.queryBUInfoByName(buName, buSet);
        if (null == buSet || buSet.isEmpty()) {
            return null;
        }
        TEMarineBUPO buPO = (TEMarineBUPO)buSet.get(0);
        return buPO;
    }

    private int setBUInfomation(TEMarineBUPO buPO) {
        boolean modifyLineOnly;
        ArrayList rowList = this.inputData.getBussinessParams().getRowParamList();
        if (null == rowList || rowList.isEmpty()) {
            return 2;
        }
        RowParams rows = (RowParams)rowList.get(0);
        if (null == buPO || "".equals(buPO.getBuName())) {
            return 0;
        }
        if (null == buPO.getPortList() || buPO.getPortList().isEmpty()) {
            return 2;
        }
        Param modifylineflag = rows.getParam("ismodifyline");
        boolean bl = modifyLineOnly = null != modifylineflag;
        if (!modifyLineOnly) {
            this.setBUBasicInfo(rows, buPO);
        }
        HashSet<TEBUBondLinePO> bondLineSet = new HashSet<TEBUBondLinePO>();
        Param param = rows.getParam("bindLines");
        if (null != param) {
            this.setBUBondLineInfo(param, bondLineSet);
        }
        buPO.setBondLineList(bondLineSet);
        return 0;
    }

    private void setBUBasicInfo(RowParams rows, TEMarineBUPO buPO) {
        if (null != rows.getParam("type")) {
            buPO.setType(Integer.parseInt(rows.getParam("type").getValue()));
        }
        if (null != rows.getParam("macaddr")) {
            buPO.setMacAddr(rows.getParam("macaddr").getValue());
        }
        if (null != rows.getParam("pressure")) {
            buPO.setPressure(Integer.valueOf(rows.getParam("pressure").getValue()).intValue());
        }
        Set buPortSet = buPO.getPortList();
        for (TEBUPortPO buPort : buPortSet) {
            buPort.setBondSLM(this.getRealNEID(rows.getParam(buPort.getPortName().toLowerCase() + "bondslm")));
            buPort.setBondPFE(this.getPFENeName(rows.getParam(buPort.getPortName().toLowerCase() + "bondpfe"), rows.getParam(buPort.getPortName().toLowerCase() + "bondpfename").getValue()));
        }
    }

    private void setBUBondLineInfo(Param param, Set<TEBUBondLinePO> bondLineSet) {
        String[] lines;
        String lineStr = param.getValue();
        for (String line : lines = lineStr.split(";")) {
            String[] la = line.split(",");
            TEBUBondLinePO blpo1 = new TEBUBondLinePO();
            int lineID = Integer.parseInt(la[0]);
            int srcNEID = Integer.parseInt(la[1]);
            TENE tmpNe = TENEListMgr.getInstance().getNE(srcNEID);
            srcNEID = null == tmpNe ? srcNEID : tmpNe.getRealNEID();
            int snkNEID = Integer.parseInt(la[6]);
            tmpNe = TENEListMgr.getInstance().getNE(snkNEID);
            snkNEID = null == tmpNe ? snkNEID : tmpNe.getRealNEID();
            int bucontrolpoint = Integer.parseInt(la[12]);
            blpo1.setLineId(lineID);
            blpo1.setSrcNeID((long)srcNEID);
            blpo1.setSnkNeID((long)snkNEID);
            blpo1.setControlPart(bucontrolpoint);
            bondLineSet.add(blpo1);
        }
    }

    @Override
    public String getRealNEID(Param param) {
        if (null == param || param.getValue().equals("-1")) {
            return "0";
        }
        String[] neids = param.getValue().split(",");
        StringBuilder realNeIdStr = new StringBuilder();
        for (int i = 0; i < neids.length; ++i) {
            TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(neids[i]));
            if (null == ne) continue;
            int realNeId = ne.getRealNEID();
            if (!"".equals(realNeIdStr.toString())) {
                realNeIdStr.append(",");
            }
            realNeIdStr.append(realNeId);
        }
        return realNeIdStr.toString();
    }

    private String getPFENeName(Param param, String boundName) {
        if (null == param || param.getValue().equals("-1")) {
            return "0";
        }
        if (param.getValue().equals("0")) {
            return "SE";
        }
        TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(param.getValue()));
        if (ne == null) {
            return boundName;
        }
        return ne.getNEName();
    }
}

