/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEBUPFEOperations;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TEGetPFEPolarityBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            Map<String, TEMarinePowerSupplyUnitPO> psuMap = null;
            if (TESysManagerBean.getInstance().isIntegratedStatus()) {
                psuMap = TEMarineBUUtil.doQueryPSUs();
            }
            Map<String, String> pfeNameMap = this.getPFEMap();
            Iterator<Map.Entry<String, String>> it = pfeNameMap.entrySet().iterator();
            boolean allFail = true;
            boolean allSuccess = true;
            RowParams row = new RowParams();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String key = entry.getKey();
                String pfeName = entry.getValue();
                String voltage = "";
                if (TESysManagerBean.getInstance().isIntegratedStatus() && psuMap != null && psuMap.containsKey(pfeName)) {
                    TEMarinePowerSupplyUnitPO psu = psuMap.get(pfeName);
                    if (psu != null) {
                        voltage = String.valueOf(psu.getVoltage());
                        allFail = false;
                    }
                } else if (!("SE".equals(pfeName) || "-".equals(pfeName) || "--".equals(pfeName))) {
                    HashMap pfeMap = new HashMap();
                    int ret = TEBUPFEOperations.getPFEVoltageHandler(pfeName, pfeMap);
                    if (0 == ret) {
                        voltage = String.valueOf(pfeMap.get("pfeVoltage"));
                        allFail = false;
                    } else {
                        allSuccess = false;
                    }
                }
                Param param = new Param(key.charAt(0) + "pfevoltage", voltage);
                row.addParam(param);
            }
            this.outputData.getBussinessParams().addRowParams(row);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            if (allSuccess) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else if (allFail) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private Map<String, String> getPFEMap() {
        HashMap<String, String> pfeNameMap = new HashMap<String, String>();
        RowParams row = this.inputData.getBussinessParams().getRowParams(0);
        pfeNameMap.put("abondpfe", row.getParam("abondpfe").getValue());
        pfeNameMap.put("bbondpfe", row.getParam("bbondpfe").getValue());
        pfeNameMap.put("cbondpfe", row.getParam("cbondpfe").getValue());
        return pfeNameMap;
    }
}

