/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMBUDataMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMSwitchBUStatus;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEGetBUSwitchProgress
extends TENEExplorerBean {
    private TEMarineBUPO bu = null;
    private String buName = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.modifyInputParams();
            this.outputData = new Datainterface();
            if (null == inputData || null == inputData.getBussinessParams() || 0 == inputData.getBussinessParams().getRowParamsCount()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            this.bu = this.getBU();
            if (null == this.bu) {
                this.outputData = this.handleErrorMessage(1090615228);
            } else {
                this.getBUStatus();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private TEMarineBUPO getBU() {
        RowParams inputRowParams = this.inputData.getBussinessParams().getRowParams(0);
        Param param = inputRowParams.getParam("buname");
        TEMarineBUPO bu = null;
        if (null != param) {
            TEBUDataOperationInterface buDataOper = TEMarineBUUtil.getBUDataOperationHandler();
            ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
            this.buName = param.getValue();
            int errCode = buDataOper.queryBUInfoByName(this.buName, buList);
            if (0 == errCode && !buList.isEmpty()) {
                bu = (TEMarineBUPO)buList.get(0);
            }
        }
        return bu;
    }

    private Datainterface handleErrorMessage(int errCode) {
        Datainterface errOutput = new Datainterface();
        if (0 == errCode) {
            errOutput.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            errOutput.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            BussinessParams busParam = new BussinessParams();
            RowParams rowParam = new RowParams();
            Param neidParam = new Param("neid", String.valueOf(this.neid));
            Param buNameParam = new Param("buname", this.bu.getBuName());
            RowErrors rowError = new RowErrors();
            rowError.addParam(neidParam);
            rowError.addParam(buNameParam);
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errCode));
            rowParam.addRowErrors(rowError);
            busParam.addRowParams(rowParam);
            errOutput.setBussinessParams(busParam);
        }
        return errOutput;
    }

    private void getBUStatus() {
        int errCode;
        TESLMSwitchBUStatus buSwitch = TESLMBUDataMgr.getInstance().getBUSwitchStatus(this.buName);
        if (null == buSwitch) {
            errCode = 2;
        } else {
            errCode = buSwitch.getErrCode();
            if (1090615114 != errCode) {
                TESLMBUDataMgr.getInstance().removeBUSwitchStatus(this.buName);
            }
        }
        this.outputData = this.handleErrorMessage(errCode);
    }
}

