/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnStrList;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEBUASN1Commond;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.util.ArrayList;
import java.util.List;

public class TEDeleteBUBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
            ArrayList rowList = inputData.getBussinessParams().getRowParamList();
            List<String> buNameList = this.getDelBuNameList(rowList);
            List<String> usedBUNameList = null;
            if (TESysManagerBean.getInstance().isIntegratedStatus()) {
                usedBUNameList = TEMarineBUE2EUtil.getBUE2EUtilInstance().filtrateUnUsedBUNameList(buNameList);
            }
            int result = 0;
            if (null != buNameList && !buNameList.isEmpty()) {
                result = buDataOperService.deleteBU(buNameList);
            }
            if (result == 0) {
                this.sendMessageToTopo(buNameList);
            }
            if (0 != result) {
                this.handleErrMessage(result);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
            this.addUsedBUErrMessage(usedBUNameList, buNameList.isEmpty());
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine------Query BU performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private void handleErrMessage(int result) {
        BussinessParams bsparam = new BussinessParams();
        this.outputData.setBussinessParams(bsparam);
        RowErrors rowError = new RowErrors();
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        Param param = new Param("neid", String.valueOf(this.neid));
        rowError.addParam(param);
        RowParams row = new RowParams();
        row.addRowErrors(rowError);
        bsparam.addRowParams(row);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
    }

    private void addUsedBUErrMessage(List<String> usedBUNameList, boolean delBULstIsEmpty) {
        if (null != usedBUNameList && !usedBUNameList.isEmpty()) {
            BussinessParams bsparam;
            if (0 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
                int ret = delBULstIsEmpty ? 2 : 1;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)ret));
            }
            if (null == (bsparam = this.outputData.getBussinessParams())) {
                bsparam = new BussinessParams();
                this.outputData.setBussinessParams(bsparam);
            }
            RowParams row = new RowParams();
            for (String usedBUName : usedBUNameList) {
                RowErrors rowError = new RowErrors();
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090615090));
                Param param = new Param("neid", String.valueOf(this.neid));
                rowError.addParam(param);
                param = new Param("buname", usedBUName);
                rowError.addParam(param);
                row.addRowErrors(rowError);
            }
            bsparam.addRowParams(row);
        }
    }

    private List<String> getDelBuNameList(List<RowParams> rowList) {
        if (null == rowList || rowList.isEmpty()) {
            return null;
        }
        ArrayList<String> buNameList = new ArrayList<String>();
        for (RowParams row : rowList) {
            if (null == row.getParam("buname")) continue;
            buNameList.add(row.getParam("buname").getValue());
        }
        return buNameList;
    }

    private void sendMessageToTopo(List<String> buNameList) {
        if (null == buNameList || buNameList.isEmpty()) {
            return;
        }
        if (TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_INTEGRATION_STATUS) {
            AsnStrList asnBUNameList = new AsnStrList();
            for (String buName : buNameList) {
                asnBUNameList.add((Object)buName.getBytes());
            }
            TEBUASN1Commond.sendDeleteBUMessageToClient(asnBUNameList);
        }
    }

    public String getDetailStr(RowParams rowparams) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        Param param = rowparams.getParam("buname");
        String detailStr = res.getString("BU_NAME") + ":" + param.getValue();
        return detailStr;
    }
}

