/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TECreateBUBean
extends TENEExplorerBean {
    protected TEMarineBUPO buPO = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            int resultCode;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.modifyInputParams();
            this.outputData = new Datainterface();
            TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
            boolean isModify = this.isModify();
            this.buPO = this.getNewBUPO(isModify, buDataOperService);
            if (isModify) {
                resultCode = buDataOperService.updateBUInfo(this.buPO);
            } else {
                resultCode = buDataOperService.createBUInfo(this.buPO);
                if (resultCode == 0) {
                    TEMarineBUUtil.sendMessageToTopo(this.buPO);
                }
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultCode));
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private boolean isModify() {
        boolean isModify = false;
        if (null == this.inputData || null == this.inputData.getBussinessParams() || 0 == this.inputData.getBussinessParams().getRowParamsCount()) {
            return isModify;
        }
        ArrayList rowList = this.inputData.getBussinessParams().getRowParamList();
        RowParams row = (RowParams)rowList.get(0);
        Param param = row.getParam("modify");
        if (null != param && "1".equals(param.getValue())) {
            isModify = true;
        }
        return isModify;
    }

    private TEMarineBUPO getNewBUPO(boolean isModify, TEBUDataOperationInterface buDataOperService) {
        TEMarineBUPO buPO = new TEMarineBUPO();
        if (null == this.inputData || null == this.inputData.getBussinessParams() || 0 == this.inputData.getBussinessParams().getRowParamsCount()) {
            return buPO;
        }
        ArrayList rowList = this.inputData.getBussinessParams().getRowParamList();
        RowParams row = (RowParams)rowList.get(0);
        Param param = row.getParam("buname");
        if (null == param) {
            return buPO;
        }
        if (isModify) {
            ArrayList<TEMarineBUPO> buSet = new ArrayList<TEMarineBUPO>();
            int errCode = buDataOperService.queryBUInfoByName(row.getParam("buname").getValue(), buSet);
            if (errCode == 0 && null != buSet && !buSet.isEmpty()) {
                buPO = (TEMarineBUPO)buSet.get(0);
            }
        } else {
            buPO.setBuName(param.getValue());
            buPO.setLastOperTime("0");
        }
        param = row.getParam("type");
        buPO.setType(null == param ? 0 : Integer.parseInt(param.getValue()));
        param = row.getParam("macaddr");
        buPO.setMacAddr(null == param ? "" : param.getValue());
        param = row.getParam("pressure");
        buPO.setPressure(null == param ? 28 : Integer.valueOf(param.getValue()));
        param = row.getParam("mainbridge");
        String tmpParamStr = null == param ? "-1" : param.getValue();
        buPO.setPrimaryLine(Integer.parseInt(tmpParamStr));
        HashSet<TEBUPortPO> buPortSet = new HashSet<TEBUPortPO>();
        TEBUPortPO buPort = this.setNewPortValue("A", buPO, row, isModify);
        buPortSet.add(buPort);
        buPort = this.setNewPortValue("B", buPO, row, isModify);
        buPortSet.add(buPort);
        buPort = this.setNewPortValue("C", buPO, row, isModify);
        buPortSet.add(buPort);
        buPO.setPortList(buPortSet);
        HashSet<TEBUBondLinePO> bondLineSet = new HashSet<TEBUBondLinePO>();
        param = row.getParam("bindLines");
        if (null != param) {
            this.setBondLine(param, bondLineSet);
        }
        buPO.setBondLineList(bondLineSet);
        TEMarineBUUtil.calcBUE2EPos(buPO);
        return buPO;
    }

    private void setBondLine(Param param, Set<TEBUBondLinePO> bondLineSet) {
        String[] lines;
        String lineStr = param.getValue();
        for (String line : lines = lineStr.split(";")) {
            String[] la = line.split(",");
            TEBUBondLinePO blpo = new TEBUBondLinePO();
            int lineID = Integer.parseInt(la[0]);
            int srcNEID = Integer.parseInt(la[1]);
            TENE tmpNe = TENEListMgr.getInstance().getNE(srcNEID);
            srcNEID = null == tmpNe ? srcNEID : tmpNe.getRealNEID();
            int snkNEID = Integer.parseInt(la[6]);
            tmpNe = TENEListMgr.getInstance().getNE(snkNEID);
            snkNEID = null == tmpNe ? snkNEID : tmpNe.getRealNEID();
            int bucontrolpoint = Integer.parseInt(la[12]);
            blpo.setLineId(lineID);
            blpo.setSrcNeID((long)srcNEID);
            blpo.setSnkNeID((long)snkNEID);
            blpo.setControlPart(bucontrolpoint);
            bondLineSet.add(blpo);
        }
    }

    private TEBUPortPO setNewPortValue(String portName, TEMarineBUPO buPO, RowParams row, boolean isModify) {
        TEBUPortPO buPort;
        if (isModify) {
            buPort = this.getBUPort(buPO.getPortList(), portName);
        } else {
            buPort = new TEBUPortPO();
            buPort.setPortName(portName);
        }
        String slmStr = this.getRealNEID(row.getParam(portName.toLowerCase() + "bondslm"));
        buPort.setBondSLM(slmStr);
        buPort.setBondPFE(this.getPFENeName(row.getParam(portName.toLowerCase() + "bondpfe"), row.getParam(portName.toLowerCase() + "bondpfename").getValue()));
        String tmpParamStr = null == row.getParam(portName.toLowerCase() + "elecdir") ? "0" : row.getParam(portName.toLowerCase() + "elecdir").getValue();
        buPort.setElecDirection(Integer.parseInt(tmpParamStr));
        tmpParamStr = null == row.getParam(portName.toLowerCase() + "isearth") ? "0" : row.getParam(portName.toLowerCase() + "isearth").getValue();
        buPort.setIsEarth((int)Short.parseShort(tmpParamStr));
        return buPort;
    }

    private TEBUPortPO getBUPort(Set<TEBUPortPO> buPortSet, String portName) {
        if (null == buPortSet || buPortSet.isEmpty()) {
            TEBUPortPO buPort = new TEBUPortPO();
            buPort.setPortName(portName);
            return buPort;
        }
        for (TEBUPortPO tmpBuPort : buPortSet) {
            if (!tmpBuPort.getPortName().equals(portName)) continue;
            return tmpBuPort;
        }
        TEBUPortPO buPort = new TEBUPortPO();
        buPort.setPortName(portName);
        return buPort;
    }

    public String getRealNEID(Param param) {
        if (null == param || "-1".equals(param.getValue())) {
            return "0";
        }
        String[] bondNes = param.getValue().split(",");
        StringBuilder realNeIds = new StringBuilder("");
        int len = bondNes.length;
        for (int i = 0; i < len; ++i) {
            int tmpNeid = Integer.parseInt(bondNes[i]);
            TENE ne = TENEListMgr.getInstance().getNE(tmpNeid);
            if (null == ne) continue;
            int realNeId = ne.getRealNEID();
            if (!"".equals(realNeIds.toString())) {
                realNeIds.append(",");
            }
            realNeIds.append(String.valueOf(realNeId));
        }
        return realNeIds.toString();
    }

    private String getPFENeName(Param param, String bondPFEName) {
        if (null == param || param.getValue().equals("-1")) {
            return "0";
        }
        if (param.getValue().equals("0")) {
            return "SE";
        }
        TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(param.getValue()));
        if (ne == null) {
            return bondPFEName;
        }
        return ne.getNEName();
    }

    public String getDetailStr(RowParams rowparams) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        StringBuilder logDetailSB = new StringBuilder(res.getString("BU_NAME"));
        Param param = rowparams.getParam("buname");
        logDetailSB.append(":").append(param.getValue()).append(",");
        if (null != this.buPO) {
            logDetailSB.append(res.getString("bumac")).append(":").append(this.buPO.getMacAddr()).append(",");
            logDetailSB.append(res.getString("butype")).append(":").append(TEMarineBUUtil.getBUTypeString(this.buPO.getType())).append(",");
            logDetailSB.append(res.getString("pressure")).append(":").append(this.buPO.getPressure()).append(";");
            logDetailSB.append(res.getString("bondslmunit")).append(",").append(res.getString("porta")).append(":");
            logDetailSB.append(this.getBondSLMNEName(this.buPO.getPortList(), "A")).append(";");
            logDetailSB.append(res.getString("portb")).append(":");
            logDetailSB.append(this.getBondSLMNEName(this.buPO.getPortList(), "B")).append(";");
            logDetailSB.append(res.getString("portc")).append(":");
            logDetailSB.append(this.getBondSLMNEName(this.buPO.getPortList(), "C")).append(";");
            logDetailSB.append(res.getString("bondpfeunit")).append(",").append(res.getString("porta")).append(":");
            logDetailSB.append(this.getBondPFENEName(this.buPO.getPortList(), "A")).append(";");
            logDetailSB.append(res.getString("portb")).append(":");
            logDetailSB.append(this.getBondPFENEName(this.buPO.getPortList(), "B")).append(";");
            logDetailSB.append(res.getString("portc")).append(":");
            logDetailSB.append(this.getBondPFENEName(this.buPO.getPortList(), "C")).append(";");
            for (TEBUBondLinePO bondline : this.buPO.getBondLineList()) {
                logDetailSB.append(this.getBondLineStr(bondline));
            }
        }
        return logDetailSB.toString();
    }

    private String getBondSLMNEName(Set<TEBUPortPO> buPortList, String portName) {
        String bondNeStrings = "";
        for (TEBUPortPO buPort : buPortList) {
            if (!portName.equals(buPort.getPortName())) continue;
            bondNeStrings = buPort.getBondSLM();
            break;
        }
        StringBuilder bondNeStr = new StringBuilder("");
        if (bondNeStrings.equals("") || bondNeStrings.equals("-1") || bondNeStrings.equals("0")) {
            bondNeStr.append("-");
        } else {
            String[] bondNeIDs = bondNeStrings.split(",");
            for (int i = 0; i < bondNeIDs.length; ++i) {
                TENE ne = TENEListMgr.getInstance().getPhyNE(Integer.parseInt(bondNeIDs[i]));
                if (null == ne) continue;
                if (!bondNeStr.toString().equals("")) {
                    bondNeStr.append(",");
                }
                bondNeStr.append(ne.getNEName());
            }
        }
        return bondNeStr.toString();
    }

    private String getBondPFENEName(Set<TEBUPortPO> buPortList, String portName) {
        String bondNeStrings = "";
        for (TEBUPortPO buPort : buPortList) {
            if (!portName.equals(buPort.getPortName())) continue;
            bondNeStrings = buPort.getBondPFE();
            break;
        }
        if (bondNeStrings.equals("") || bondNeStrings.equals("0")) {
            bondNeStrings = "-";
        }
        return bondNeStrings;
    }

    private String getBondLineStr(TEBUBondLinePO bondline) {
        int srcNEID = bondline.getSrcNeID();
        TENE ne = TENEListMgr.getInstance().getPhyNE(srcNEID);
        String bondLineStr = "";
        bondLineStr = null == ne ? bondLineStr + (0 == srcNEID ? "" : "UNKNOWN-") : bondLineStr + ne.getNEName() + "-";
        int snkNEID = bondline.getSnkNeID();
        ne = TENEListMgr.getInstance().getPhyNE(snkNEID);
        bondLineStr = null == ne ? bondLineStr + (0 == snkNEID ? "" : "UNKNOWN-") : bondLineStr + ne.getNEName() + "-";
        bondLineStr = bondLineStr + bondline.getLineId();
        return bondLineStr;
    }
}

