/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineCalcBUVoltageData;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMBUDataMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMSwitchBUStatus;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TEBUSwitchBean
extends TENEExplorerBean {
    private static final int NSERR_MARINE_BU_VOLTAGE_OVER = 1090615112;
    private static final int NSERR_MARINE_BU_SHORT_INTERVAL = 1090615113;
    private static final int NSERR_MARINE_WRONG_PFE_POLARITY = 1090615115;
    private static final int NSERR_MARINE_BU_SWITCH_CONFLICT = 1090615202;
    private static final int SWITCH_STEP_ONE = 0;
    private static final int BU_SWITCH_CHECK = 1;
    private static final int BU_SWITCH_NO_FORCE = 0;
    private static final int BU_SWITCH_VOLTAGE_CHECK = 0;
    private static final int SWITCH_MIN_INTERVAL = 30000;
    private static final int OVERHEIGHT_VOTAGE = 500;
    private TEMarineBUPO bu = null;
    private String buName = "";
    private int switchStep = 0;
    private String user;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.inputData = inputData;
        this.user = user;
        this.bu = this.getBU();
        if (null == this.bu) {
            this.outputData = this.handleErrorMessage(1090615228);
        } else {
            int errorCode = this.checkBeforSwitch();
            if (0 == errorCode) {
                inputData.getBussinessParams().getRowParams(0).getParam("macAddr").setValue(String.valueOf(this.bu.getRealAddrByInt()));
                this.outputData = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            } else {
                this.outputData = this.handleErrorMessage(errorCode);
            }
        }
        if (0 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            this.resetBULastOperTime();
            Param ise2eParam = inputData.getBussinessParams().getRowParams(0).getParam("ise2e");
            if (null == ise2eParam || !ise2eParam.getValue().equals("0")) {
                this.addBUInCash();
            }
        }
        return this.outputData;
    }

    private Datainterface handleErrorMessage(int errCode) {
        Datainterface errOutput = new Datainterface();
        errOutput.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        BussinessParams busParam = new BussinessParams();
        RowParams rowParam = new RowParams();
        Param neidParam = new Param("neid", String.valueOf(this.neid));
        Param buNameParam = new Param("buname", this.buName);
        RowErrors rowError = new RowErrors();
        rowError.addParam(neidParam);
        rowError.addParam(buNameParam);
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errCode));
        rowParam.addRowErrors(rowError);
        busParam.addRowParams(rowParam);
        errOutput.setBussinessParams(busParam);
        return errOutput;
    }

    private TEMarineBUPO getBU() {
        if (null == this.inputData || null == this.inputData.getBussinessParams() || this.inputData.getBussinessParams().getRowParamList().isEmpty()) {
            return null;
        }
        RowParams inputRowParams = this.inputData.getBussinessParams().getRowParams(0);
        Param param = inputRowParams.getParam("buname");
        TEMarineBUPO bu = null;
        if (null != param) {
            TEBUDataOperationInterface buDataOper = TEMarineBUUtil.getBUDataOperationHandler();
            ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
            this.buName = param.getValue();
            int errCode = buDataOper.queryBUInfoByName(this.buName, buList);
            if (0 == errCode && !buList.isEmpty()) {
                bu = (TEMarineBUPO)buList.get(0);
            }
        }
        return bu;
    }

    private int checkBeforSwitch() {
        Param aimStatusParam;
        int forceSwitchValue;
        if (this.isShortOperInterval()) {
            int errCode = 1090615113;
            return errCode;
        }
        if (null == this.inputData || null == this.inputData.getBussinessParams() || this.inputData.getBussinessParams().getRowParamList().isEmpty()) {
            return 2;
        }
        RowParams inputRowParams = this.inputData.getBussinessParams().getRowParams(0);
        Param param = inputRowParams.getParam("step");
        this.switchStep = null == param ? this.switchStep : Integer.valueOf(param.getValue());
        Param forceSwitchParam = inputRowParams.getParam("voltageCheck");
        int n = forceSwitchValue = null == forceSwitchParam ? 0 : Integer.parseInt(forceSwitchParam.getValue());
        int errCode = 0 == this.switchStep ? this.checkFirstStep(forceSwitchValue) : (null == (aimStatusParam = inputRowParams.getParam("confStatusAfter")) ? 2 : this.checkSecondStep(Integer.parseInt(aimStatusParam.getValue())));
        return errCode;
    }

    private int checkFirstStep(int forceSwitchValue) {
        int errCode = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            return errCode;
        }
        if (TESysManagerBean.getInstance().isIntegratedStatus() && !this.checkPrimaryLine(this.bu)) {
            return errCode;
        }
        if (0 == errCode && 0 == forceSwitchValue) {
            errCode = this.isOverHeighVoltage();
        }
        return errCode;
    }

    private boolean checkPrimaryLine(TEMarineBUPO bu) {
        Map<String, TEMarinePowerSupplyUnitPO> psuMap = TEMarineBUUtil.doQueryPSUs();
        int primaryLine = bu.getPrimaryLine();
        String abondpfe = null;
        String bbondpfe = null;
        String cbondpfe = null;
        for (TEBUPortPO port : bu.getPortList()) {
            if ("A".equals(port.getPortName())) {
                abondpfe = port.getBondPFE();
                continue;
            }
            if ("B".equals(port.getPortName())) {
                bbondpfe = port.getBondPFE();
                continue;
            }
            if (!"C".equals(port.getPortName())) continue;
            cbondpfe = port.getBondPFE();
        }
        boolean result = true;
        switch (primaryLine) {
            case 1: {
                result = psuMap.get(abondpfe) == null || psuMap.get(bbondpfe) == null;
                break;
            }
            case 2: {
                result = psuMap.get(abondpfe) == null || psuMap.get(cbondpfe) == null;
                break;
            }
            case 3: {
                result = psuMap.get(cbondpfe) == null || psuMap.get(bbondpfe) == null;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    private boolean isShortOperInterval() {
        long lastOperTime = Long.parseLong(this.bu.getLastOperTime());
        long currTime = System.currentTimeMillis();
        return currTime - lastOperTime <= 30000L;
    }

    private int isOverHeighVoltage() {
        TEMarineCalcBUVoltageData buVoltageData = this.initCalcBUVoltageToData();
        int errorCode = (buVoltageData = TEMarineBUUtil.getBUVoltage(buVoltageData)).getResultCode().intValue();
        if (0 == errorCode && Math.abs(buVoltageData.getBuVoltage().intValue()) > 500) {
            errorCode = 1090615112;
        }
        return errorCode;
    }

    private TEMarineCalcBUVoltageData initCalcBUVoltageToData() {
        TEMarineCalcBUVoltageData buVoltageData = new TEMarineCalcBUVoltageData();
        if (null == this.inputData || null == this.inputData.getBussinessParams() || this.inputData.getBussinessParams().getRowParamList().isEmpty()) {
            return buVoltageData;
        }
        RowParams rowParams = this.inputData.getBussinessParams().getRowParams(0);
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            buVoltageData.setUserID(BigInteger.valueOf(TESecurityVerify.getSuperUserID()));
        } else {
            buVoltageData.setUserID(BigInteger.valueOf(Integer.parseInt(this.user)));
        }
        int forceSwitch = Integer.parseInt(rowParams.getParam("voltageCheck").getValue());
        buVoltageData.setForceSwitch(BigInteger.valueOf(forceSwitch));
        int faultType = Integer.parseInt(rowParams.getParam("malfunctiontype").getValue());
        buVoltageData.setFaultType(BigInteger.valueOf(faultType));
        String controlUnitStr = rowParams.getParam("malfunctionend").getValue();
        byte controlUnit = "".equals(controlUnitStr) ? (byte)0 : controlUnitStr.getBytes()[0];
        buVoltageData.setControlUnit(BigInteger.valueOf(controlUnit));
        int faultLength = Integer.parseInt(rowParams.getParam("malfunctionpoint").getValue());
        buVoltageData.setFaultLength(BigInteger.valueOf(faultLength));
        int lineID = Integer.parseInt(rowParams.getParam("lineID").getValue());
        buVoltageData.setLineID(BigInteger.valueOf(lineID));
        buVoltageData.setMarineBUPO(this.bu);
        buVoltageData.setBuVoltage(BigInteger.valueOf(0L));
        buVoltageData.setResultCode(BigInteger.valueOf(0L));
        return buVoltageData;
    }

    private int checkSecondStep(int aimStatus) {
        int NEEDCHECK_NUM = 2;
        Set<String> pfeNameSet = this.getPFENameSet(aimStatus);
        int errCode = 0;
        if (null != pfeNameSet && pfeNameSet.size() >= 2) {
            Map<String, String> pfePolarityMap = TEMarineBUUtil.getPFEPolarityMap(pfeNameSet);
            Iterator<Map.Entry<String, String>> it = pfePolarityMap.entrySet().iterator();
            if (pfePolarityMap.size() >= 2) {
                String polarity2;
                String polarity1 = it.next().getValue();
                errCode = polarity1.equals(polarity2 = it.next().getValue()) ? 1090615115 : 0;
            }
        }
        return errCode;
    }

    private Set<String> getPFENameSet(int aimStatus) {
        HashSet<String> pfeNameSet = new HashSet<String>();
        block5: for (TEBUPortPO buPO : this.bu.getPortList()) {
            switch (aimStatus) {
                case 1: {
                    if (!"A".equals(buPO.getPortName()) && !"B".equals(buPO.getPortName())) continue block5;
                    pfeNameSet.add(buPO.getBondPFE());
                    continue block5;
                }
                case 2: {
                    if (!"A".equals(buPO.getPortName()) && !"C".equals(buPO.getPortName())) continue block5;
                    pfeNameSet.add(buPO.getBondPFE());
                    continue block5;
                }
                case 3: {
                    if (!"B".equals(buPO.getPortName()) && !"C".equals(buPO.getPortName())) continue block5;
                    pfeNameSet.add(buPO.getBondPFE());
                    continue block5;
                }
            }
        }
        return pfeNameSet;
    }

    private void resetBULastOperTime() {
        this.bu.setLastOperTime(String.valueOf(System.currentTimeMillis()));
        TEMarineBUUtil.getBUDataOperationHandler().updateBUInfo(this.bu);
    }

    private void addBUInCash() {
        if (null == this.inputData || null == this.inputData.getBussinessParams() || this.inputData.getBussinessParams().getRowParamList().isEmpty()) {
            return;
        }
        TESLMSwitchBUStatus buStatus = new TESLMSwitchBUStatus();
        buStatus.setBuName(this.bu.getBuName());
        buStatus.setBuAddr(this.bu.getMacAddr());
        buStatus.setStep(this.switchStep);
        buStatus.setNeID(this.neid);
        RowParams rowParam = this.inputData.getBussinessParams().getRowParams(0);
        int lineID = Integer.parseInt(rowParam.getParam("lineID").getValue());
        buStatus.setLineID(lineID);
        int switchMode = Integer.parseInt(rowParam.getParam("switchMode").getValue());
        buStatus.setSwitchMode(switchMode);
        int confStatusBefore = Integer.parseInt(rowParam.getParam("confStatusBefore").getValue());
        buStatus.setConfStatusBefore(confStatusBefore);
        int confStatusAfter = Integer.parseInt(rowParam.getParam("confStatusAfter").getValue());
        buStatus.setConfStatusAfter(confStatusAfter);
        TESLMBUDataMgr.getInstance().addBUSwitchStatus(buStatus.getBuName(), buStatus);
    }

    public String getDetailStr(RowParams rowparams) {
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        StringBuilder detailStr = new StringBuilder();
        Param param = rowparams.getParam("buname");
        detailStr.append(res.getString("BU_NAME")).append(":").append(param.getValue()).append(",");
        param = rowparams.getParam("controlne");
        detailStr.append(res.getString("controlend")).append(":").append(this.getNeName(param.getValue())).append(",");
        param = rowparams.getParam("lineID");
        detailStr.append(res.getString("lineIDStr")).append(":").append(param.getValue()).append(",");
        param = rowparams.getParam("lineID");
        detailStr.append(res.getString("lineIDStr")).append(":").append(param.getValue()).append(",");
        param = rowparams.getParam("confStatusBefore");
        detailStr.append(res.getString("confStatusBefore")).append(":").append(this.getBUStatus(param.getValue())).append(",");
        param = rowparams.getParam("confStatusAfter");
        detailStr.append(res.getString("confStatusAfter")).append(":").append(this.getBUStatus(param.getValue()));
        return detailStr.toString();
    }

    private String getNeName(String neidStr) {
        int controlNeid = "".equals(neidStr) ? 0 : Integer.parseInt(neidStr);
        TENE ne = TENEListMgr.getInstance().getNE(controlNeid);
        String controlNeName = null == ne ? "UNKNOWN" : ne.getNEName();
        return controlNeName;
    }

    private String getBUStatus(String buStatusValue) {
        String buStatusStr;
        TEResourceUtil res = TEMarineBUE2EUtil.getBUE2EUtilInstance().getLogRes();
        int buStatusInt = Integer.parseInt(buStatusValue);
        switch (buStatusInt) {
            case 1: {
                buStatusStr = res.getString("abstatus");
                break;
            }
            case 2: {
                buStatusStr = res.getString("acstatus");
                break;
            }
            case 3: {
                buStatusStr = res.getString("bcstatus");
                break;
            }
            case 0: {
                buStatusStr = res.getString("threeendearth");
                break;
            }
            default: {
                buStatusStr = "-";
            }
        }
        return buStatusStr;
    }
}

