/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import gnu.trove.TIntArrayList;

public class TEBUQueryResourceNEBean
extends TENEExplorerBean {
    private static final int MARINESLM_NETYPE = 61;
    private static final int MARINEPFE_NETYPE = 72;
    private static final int MARINEPSU_NETYPE = -2027;
    private static final long SLM_VALID_VERSION = 87884298L;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TELogFactory.getNormalLogger().info("Start to get BU bond NE resourde!");
            TIntArrayList neidlist = TENEListMgr.getInstance().getNEIDList();
            if (null == neidlist || 0 == neidlist.size()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
                return this.outputData;
            }
            boolean slmNeExistFlg = false;
            BussinessParams bussinessParams = new BussinessParams();
            RowParams row = null;
            Param param = null;
            TENE tmpNe = null;
            int length = neidlist.size();
            for (int i = 0; i < length; ++i) {
                tmpNe = TENEListMgr.getInstance().getNE(neidlist.get(i));
                int tmpNetype = tmpNe.getNEType();
                if (tmpNetype == 61) {
                    slmNeExistFlg = true;
                }
                if ((tmpNetype != 61 || !this.isRightVersion(tmpNe.getNEID())) && tmpNetype != 72) continue;
                row = new RowParams();
                param = new Param("neid", String.valueOf(tmpNe.getNEID()));
                row.addParam(param);
                param = new Param("nename", tmpNe.getNEName());
                row.addParam(param);
                param = new Param("netype", String.valueOf(tmpNetype));
                row.addParam(param);
                bussinessParams.addRowParams(row);
            }
            if (TESysManagerBean.getInstance().isIntegratedStatus()) {
                for (TEMarinePowerSupplyUnitPO psu : TEMarineBUUtil.doQueryPSUs().values()) {
                    row = new RowParams();
                    param = new Param("neid", String.valueOf(-2027));
                    row.addParam(param);
                    param = new Param("nename", psu.getName());
                    row.addParam(param);
                    param = new Param("netype", String.valueOf(-2027));
                    row.addParam(param);
                    bussinessParams.addRowParams(row);
                }
            }
            TELogFactory.getNormalLogger().info("Get BU bond NE resourde operation end!");
            if (!slmNeExistFlg) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090594251));
                return this.outputData;
            }
            this.outputData.setBussinessParams(bussinessParams);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private boolean isRightVersion(int neid) {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neid);
        }
        return (long)TENECommMgr.getInstance().getNeVersion((long)neid) >= 87884298L;
    }
}

